/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.conversation;

import com.ibm.able.Able;
import com.ibm.able.AbleLogger;
import com.ibm.able.conversation.AbleConversation;
import com.ibm.able.conversation.AbleConversationManager;
import com.ibm.able.conversation.AbleCpGraphLoader;
import com.ibm.able.conversation.AbleCpGraphViewer;
import com.ibm.able.conversation.AbleCpStateMachineHandler;
import com.ibm.able.editor.AbleCustomInspectorView;
import com.ibm.able.editor.AbleInspectorContext;
import com.ibm.conversation.Conversation;
import com.ibm.conversation.ConversationPolicyHandler;
import com.ibm.graph.Drawable;
import com.ibm.graph.Edge;
import com.ibm.graph.GraphObject;
import com.ibm.graph.Net;
import com.ibm.graph.NotDrawableException;
import com.ibm.graph.Vertex;
import com.ibm.graph.awt.event.GraphCanvasEvent;
import com.ibm.graph.awt.event.GraphCanvasEventListener;
import com.ibm.graph.draw.Draw2EdgeLoopEllipse;
import com.ibm.graph.draw.Draw2EdgeParabolaDirectedArrowThenText;
import com.ibm.graph.ext.visual.VisualVertex;
import com.ibm.graph.swing.JGraphCanvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AbleConversationGraphicView
extends JPanel
implements PropertyChangeListener,
AbleCustomInspectorView,
Serializable {
    protected static final long serialVersionUID = 2002091900100300001L;
    public static final String VIEWER_KEY = "viewer";
    final AbleLogger logger = Able.MessageLog;
    private Net graph;
    private JGraphCanvas graphCanvas;
    private PropertyChangeSupport propertyChangeSupport;
    private Hashtable localStore = null;
    private Vector cpViewerList = null;
    private DraggedListener draggedListener = null;
    private ReleasedListener releasedListener = null;
    AbleConversationManager convManager = null;

    public void setContext(AbleInspectorContext ableInspectorContext) {
        if (ableInspectorContext != null && ableInspectorContext.customViewData instanceof Vector) {
            Vector vector = (Vector)ableInspectorContext.customViewData;
            for (int i = 0; i < vector.size(); ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)vector.elementAt(i));
                LinkedList linkedList = (LinkedList)this.localStore.get(stringTokenizer.nextToken());
                AbleCpGraphViewer ableCpGraphViewer = (AbleCpGraphViewer)linkedList.get(Integer.parseInt(stringTokenizer.nextToken()));
                Point point = new Point(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                ableCpGraphViewer.setLocation(point);
                ableCpGraphViewer.loadFrame();
            }
        }
    }

    public AbleConversationGraphicView(Object object) {
        if (object instanceof AbleConversationManager) {
            this.convManager = (AbleConversationManager)object;
        }
        this.initializeLocalStore();
        this.initializeParameters();
        this.refreshView();
    }

    private void initializeLocalStore() {
        this.localStore = new Hashtable();
        this.cpViewerList = new Vector();
        String string = null;
        Conversation conversation = null;
        ConversationPolicyHandler conversationPolicyHandler = null;
        Iterator iterator = this.convManager.getConversationIds().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            conversation = this.convManager.getConversation(string);
            LinkedList<AbleCpGraphViewer> linkedList = new LinkedList<AbleCpGraphViewer>();
            int n = conversation.getContext().getNumPolicyLevels();
            for (int i = 0; i < n; ++i) {
                conversationPolicyHandler = conversation.getConversationPolicyHandlerAt(i);
                String string2 = conversationPolicyHandler.getPolicyName();
                if (conversationPolicyHandler instanceof AbleCpStateMachineHandler) {
                    AbleCpStateMachineHandler ableCpStateMachineHandler = (AbleCpStateMachineHandler)conversationPolicyHandler;
                    AbleCpGraphViewer ableCpGraphViewer = null;
                    try {
                        ableCpGraphViewer = new AbleCpGraphViewer(string2, string2);
                    }
                    catch (Exception exception) {
                        this.logger.text(4L, (Object)this, "graphobjectSelected", exception.getLocalizedMessage());
                        JOptionPane.showMessageDialog(this, exception.toString(), "AbleConversationGraphicView Error: graphobjectSelected()", 0);
                    }
                    AbleCpGraphLoader ableCpGraphLoader = new AbleCpGraphLoader(ableCpStateMachineHandler.getStateMachine());
                    ableCpGraphViewer.loadGraph(ableCpGraphLoader);
                    ableCpStateMachineHandler.addPropertyChangeListener("CurrentState", (PropertyChangeListener)ableCpGraphViewer);
                    String string3 = this.convManager.getPolicyLayoutFile(string2);
                    if (string3 != null) {
                        File file = new File(string3);
                        ableCpGraphViewer.loadFromLayout(file);
                    }
                    linkedList.add(ableCpGraphViewer);
                    this.cpViewerList.add(ableCpGraphViewer);
                }
                this.localStore.put(string, linkedList);
            }
        }
    }

    private void initializeParameters() {
        this.graph = new Net();
        this.graph.setName("graph");
        this.graphCanvas = new JGraphCanvas(this.graph);
        this.graphCanvas.setBackground(Color.lightGray);
        Dragging dragging = new Dragging();
        this.draggedListener = new DraggedListener(this, dragging);
        this.releasedListener = new ReleasedListener(this, dragging);
        this.graphCanvas.addGraphCanvasEventMouseDraggedListener((GraphCanvasEventListener)this.draggedListener);
        this.graphCanvas.addGraphCanvasEventMouseReleasedListener((GraphCanvasEventListener)this.releasedListener);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.loadGraph();
        this.add((Component)this.graphCanvas);
        this.convManager.addPropertyChangeListener("NewConversation", (PropertyChangeListener)this);
        this.convManager.addPropertyChangeListener("ConversationCompleted", (PropertyChangeListener)this);
        this.convManager.addPropertyChangeListener("CpLayoutLoaded", (PropertyChangeListener)this);
    }

    public Object getContext() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.localStore.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LinkedList linkedList = (LinkedList)this.localStore.get(string);
            for (int i = 0; i < linkedList.size(); ++i) {
                AbleCpGraphViewer ableCpGraphViewer = (AbleCpGraphViewer)linkedList.get(i);
                if (!ableCpGraphViewer.isVisible()) continue;
                Point point = ableCpGraphViewer.getLocation();
                String string2 = string + " " + i + " " + point.x + " " + point.y;
                vector.add(string2);
            }
        }
        return vector;
    }

    protected void refreshView() {
        this.invalidate();
        this.repaint();
    }

    void _sizeGraphCanvas(int n, int n2) {
        Dimension dimension = null;
        try {
            dimension = this.graphCanvas.getGraph().getSize();
        }
        catch (NotDrawableException notDrawableException) {
            dimension = new Dimension(500, 200);
        }
        dimension.width += n;
        dimension.height += n2;
        this.graphCanvas.setPreferredSize(dimension);
    }

    private void _translate(Net net, int n, int n2) {
        Enumeration enumeration = net.enumerateVertices();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            try {
                Point point = vertex.getLocation();
                point.translate(n, n2);
                vertex.setLocation(point);
            }
            catch (NotDrawableException notDrawableException) {}
        }
    }

    private void _validate() {
        Rectangle rectangle = null;
        try {
            rectangle = this.graph.getBounds();
        }
        catch (NotDrawableException notDrawableException) {
            return;
        }
        if (rectangle != null) {
            if (rectangle.x < 0 || rectangle.x > 100 || rectangle.y < 0 || rectangle.y > 100) {
                this._translate(this.graph, 50 - rectangle.x, 50 - rectangle.y);
            }
            this.graphCanvas.setSize(rectangle.width + 290, rectangle.height);
        }
        this.graphCanvas.validate();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    public void fixDisplay() {
        this._translate(this.graph, 100, 30);
        this._sizeGraphCanvas(100, 150);
        this._validate();
    }

    public JComponent getGraphPane() {
        return this;
    }

    private void loadGraph() {
        this.loadGraph(this.graph);
        this.fixDisplay();
    }

    private synchronized void loadGraph(Net net) {
        this.printDebug("loadGraph: start");
        net.clear();
        if (this.localStore != null) {
            Enumeration enumeration = this.localStore.keys();
            int n = 1;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = this.convManager.isConversationCompleted(string);
                Vertex vertex = null;
                LinkedList linkedList = (LinkedList)this.localStore.get(string);
                Vertex vertex2 = null;
                for (int i = 1; i <= linkedList.size(); ++i) {
                    AbleCpGraphViewer ableCpGraphViewer = (AbleCpGraphViewer)linkedList.get(i - 1);
                    vertex = this.createVertex(ableCpGraphViewer.getName(), ableCpGraphViewer, bl);
                    Point point = this.calculateLocation(n, i);
                    vertex.setLocation(point);
                    net.add(vertex);
                    if (vertex2 != null) {
                        Edge edge = this.createEdge(vertex2, vertex);
                        if (edge != null) {
                            net.add(edge);
                            this.initDrawable(edge, 1);
                        } else {
                            this.logger.text(1L, (Object)this, "loadGraph", "Edge Creation Failed");
                        }
                    }
                    vertex2 = vertex;
                }
                ++n;
            }
        }
    }

    private Vertex createVertex(String string, Object object, boolean bl) {
        VisualVertex visualVertex = null;
        visualVertex = new VisualVertex(1, Color.yellow, Color.blue, true, GraphObject.strKeyName, Color.black, "Times", 1, 12);
        if (bl) {
            try {
                visualVertex.setColorFill(Color.white);
            }
            catch (Exception exception) {
                this.logger.text(4L, (Object)this, "createVertex", exception.getLocalizedMessage());
                JOptionPane.showMessageDialog(this, exception.toString(), "AbleConversationGraphicView Error: createVertex()", 0);
            }
        }
        visualVertex.setName(string);
        visualVertex.userdict.def((Object)VIEWER_KEY, object);
        return visualVertex;
    }

    private Point calculateLocation(int n, int n2) {
        Point point = new Point();
        double d = 1 + (n - 1) * 150;
        double d2 = 2 + (n2 - 1) * 100;
        point.setLocation(d, d2);
        return point;
    }

    private Edge createEdge(Vertex vertex, Vertex vertex2) {
        Edge edge = new Edge(vertex, vertex2, true);
        edge.setName("");
        return edge;
    }

    private void initDrawable(Edge edge, int n) {
        if (edge.isLoop()) {
            Draw2EdgeLoopEllipse draw2EdgeLoopEllipse = new Draw2EdgeLoopEllipse();
            edge.setDrawable((Drawable)draw2EdgeLoopEllipse);
        } else {
            Draw2EdgeParabolaDirectedArrowThenText draw2EdgeParabolaDirectedArrowThenText = new Draw2EdgeParabolaDirectedArrowThenText();
            draw2EdgeParabolaDirectedArrowThenText.setArrowHeadFill(true);
            draw2EdgeParabolaDirectedArrowThenText.setText(edge.getName());
            double d = 5.0 * (double)n + 10.0;
            draw2EdgeParabolaDirectedArrowThenText.setFlatness(d);
            edge.setDrawable((Drawable)draw2EdgeParabolaDirectedArrowThenText);
        }
    }

    public void selectCP(Vertex vertex) {
        try {
            AbleCpGraphViewer ableCpGraphViewer = (AbleCpGraphViewer)vertex.userdict.get((Object)VIEWER_KEY);
            ableCpGraphViewer.loadFrame();
        }
        catch (Exception exception) {
            this.logger.text(4L, (Object)this, "selectCP", exception.getLocalizedMessage());
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleConversationGraphicView Error: selectCP()", 0);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        this.printDebug("propertyChange: " + string);
        if (string != null) {
            if (string.equals("CpLayoutLoaded")) {
                String string2 = (String)propertyChangeEvent.getOldValue();
                String string3 = (String)propertyChangeEvent.getNewValue();
                for (int i = 0; i < this.cpViewerList.size(); ++i) {
                    AbleCpGraphViewer ableCpGraphViewer = (AbleCpGraphViewer)this.cpViewerList.elementAt(i);
                    if (!ableCpGraphViewer.getName().equals(string2)) continue;
                    File file = new File(string3);
                    ableCpGraphViewer.loadFromLayout(file);
                }
            } else if (!string.equals("ConversationCompleted")) {
                if (string.equals("NewConversation")) {
                    String string4 = (String)propertyChangeEvent.getNewValue();
                    AbleConversation ableConversation = (AbleConversation)this.convManager.getConversation(string4);
                    ableConversation.addPropertyChangeListener("ChildCpLoaded", (PropertyChangeListener)this);
                    ableConversation.addPropertyChangeListener("ChildCpDone", (PropertyChangeListener)this);
                    ConversationPolicyHandler conversationPolicyHandler = ableConversation.getActivePolicyHandler();
                    this.updateLocalStore(string4, conversationPolicyHandler);
                } else if (string.equals("ChildCpLoaded")) {
                    String string5 = (String)propertyChangeEvent.getNewValue();
                    Conversation conversation = this.convManager.getConversation(string5);
                    ConversationPolicyHandler conversationPolicyHandler = conversation.getActivePolicyHandler();
                    this.updateLocalStore(string5, conversationPolicyHandler);
                } else if (string.equals("ChildCpDone")) {
                    // empty if block
                }
            }
        }
        this.loadGraph();
        this.validate();
        this.repaint();
    }

    private void updateLocalStore(String string, ConversationPolicyHandler conversationPolicyHandler) {
        Serializable serializable;
        if (conversationPolicyHandler == null) {
            this.printDebug("updateLocalStore: CPH is null.");
            return;
        }
        if (!(conversationPolicyHandler instanceof AbleCpStateMachineHandler)) {
            this.printDebug("updateLocalStore: can't handle the CPH: it's a " + conversationPolicyHandler.getClass().getName());
            return;
        }
        AbleCpStateMachineHandler ableCpStateMachineHandler = (AbleCpStateMachineHandler)conversationPolicyHandler;
        String string2 = ableCpStateMachineHandler.getPolicyName();
        AbleCpGraphViewer ableCpGraphViewer = null;
        try {
            ableCpGraphViewer = new AbleCpGraphViewer(string2, string2);
        }
        catch (Exception exception) {
            this.logger.text(4L, (Object)this, "updateLocalStore", exception.getLocalizedMessage());
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleConversationGraphicView Error: updateLocalStore()", 0);
        }
        AbleCpGraphLoader ableCpGraphLoader = new AbleCpGraphLoader(ableCpStateMachineHandler.getStateMachine());
        ableCpGraphViewer.loadGraph(ableCpGraphLoader);
        String string3 = this.convManager.getPolicyLayoutFile(string2);
        if (string3 != null) {
            serializable = new File(string3);
            ableCpGraphViewer.loadFromLayout((File)serializable);
        }
        ableCpStateMachineHandler.addPropertyChangeListener("CurrentState", (PropertyChangeListener)ableCpGraphViewer);
        serializable = null;
        if (this.localStore.containsKey(string)) {
            serializable = (LinkedList)this.localStore.get(string);
            ((LinkedList)serializable).add(ableCpGraphViewer);
        } else {
            serializable = new LinkedList();
            ((LinkedList)serializable).add(ableCpGraphViewer);
            this.localStore.put(string, serializable);
        }
    }

    public void printDebug(String string) {
        System.out.println("AbleConversationGraphicView[" + Integer.toHexString(this.hashCode()) + "]: " + string);
    }

    class ReleasedListener
    implements GraphCanvasEventListener {
        private Dragging _dragging;
        private AbleConversationGraphicView _app;

        public ReleasedListener(AbleConversationGraphicView ableConversationGraphicView2, Dragging dragging) {
            this._app = ableConversationGraphicView2;
            this._dragging = dragging;
        }

        public void graphobjectSelected(GraphCanvasEvent graphCanvasEvent) {
            if (this._dragging.zDragging) {
                MouseEvent mouseEvent = (MouseEvent)graphCanvasEvent.getAWTEvent();
                this._app._sizeGraphCanvas(100, 150);
                Component component = mouseEvent.getComponent();
                component.repaint();
                this._dragging.zDragging = false;
            } else if (graphCanvasEvent.getGraphObject() instanceof Vertex) {
                Vertex vertex = (Vertex)graphCanvasEvent.getGraphObject();
                System.err.println("Selected vertex: " + vertex.getName());
                this._app.selectCP(vertex);
            }
        }
    }

    class DraggedListener
    implements GraphCanvasEventListener {
        private AbleConversationGraphicView _app;
        private Dragging _dragging;

        public DraggedListener(AbleConversationGraphicView ableConversationGraphicView2, Dragging dragging) {
            this._app = ableConversationGraphicView2;
            this._dragging = dragging;
        }

        public void graphobjectSelected(GraphCanvasEvent graphCanvasEvent) {
            if (graphCanvasEvent.getGraphObject() instanceof Vertex) {
                Vertex vertex = (Vertex)graphCanvasEvent.getGraphObject();
                MouseEvent mouseEvent = (MouseEvent)graphCanvasEvent.getAWTEvent();
                Point point = mouseEvent.getPoint();
                if (!this._dragging.zDragging) {
                    this._dragging.zDragging = true;
                    try {
                        this._dragging.iXDelta = -point.x + vertex.getLocation().x;
                        this._dragging.iYDelta = -point.y + vertex.getLocation().y;
                    }
                    catch (NotDrawableException notDrawableException) {
                        AbleConversationGraphicView.this.logger.text(4L, (Object)this, "graphobjectSelected", notDrawableException.getLocalizedMessage());
                        JOptionPane.showMessageDialog(this._app, notDrawableException.toString(), "AbleConversationGraphicView Error: graphobjectSelected()", 0);
                    }
                }
                point.translate(this._dragging.iXDelta, this._dragging.iYDelta);
                Component component = mouseEvent.getComponent();
                Graphics graphics = component.getGraphics();
                graphics.setXORMode(component.getBackground());
                vertex.draw(graphics);
                vertex.setLocation(point);
                vertex.draw(graphics);
            } else if (graphCanvasEvent.getGraphObject() instanceof Edge) {
                // empty if block
            }
        }
    }

    class Dragging {
        public boolean zDragging = false;
        public int iXDelta = 0;
        public int iYDelta = 0;

        Dragging() {
        }
    }
}

