/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.petrinet;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.petrinet.AblePetriTransition;
import com.ibm.able.beans.petrinet.AblePetriTransitionCustomizer;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;

class AblePetriTransitionPanel
extends JPanel
implements AbleCustomizerPanel {
    private AblePetriTransition myBean = null;
    private AblePetriTransitionCustomizer myCustomizer = null;
    private JTextArea myExpressionTextArea = null;
    private JTextArea myGuardClauseTextArea = null;
    private JSpinner myFiringProbabilitySpinner = null;
    private JSpinner myMeanDelaySpinner = null;

    private AblePetriTransitionPanel() {
    }

    public AblePetriTransitionPanel(AblePetriTransitionCustomizer ablePetriTransitionCustomizer) {
        this.myCustomizer = ablePetriTransitionCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myBean == null) {
            this.myBean = (AblePetriTransition)object;
        }
        this.myExpressionTextArea.setText(this.myBean.getExpressionText());
        this.myGuardClauseTextArea.setText(this.myBean.getGuardClauseText());
        this.myFiringProbabilitySpinner.setValue(new Double(this.myBean.getFiringProbability()));
        this.myMeanDelaySpinner.setValue(new Double(this.myBean.getMeanDelay()));
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myBean.setExpressionText(this.myExpressionTextArea.getText().trim());
            this.myBean.setGuardClauseText(this.myGuardClauseTextArea.getText().trim());
            this.myBean.setFiringProbability(((Double)this.myFiringProbabilitySpinner.getValue()).doubleValue());
            this.myBean.setMeanDelay(((Double)this.myMeanDelaySpinner.getValue()).doubleValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on PetriTransition panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on PetriTransition panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 5, 10), 0, 0));
        this.add(this.getBottomPanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 10, 10), 0, 0));
    }

    private Component getTopPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        JPanel jPanel2 = new JPanel();
        this.myGuardClauseTextArea = AblePanelHelper.addTextArea(jPanel2, -1, 2, null);
        jPanel.add((Component)new JLabel("Guard clause"), new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel.add((Component)jPanel2, new AbleGridBagConstraints(1, n, 3, 2, 0.5, 0.3, 17, 1, new Insets(0, 10, 10, 0), 0, 0));
        JPanel jPanel3 = new JPanel();
        this.myExpressionTextArea = AblePanelHelper.addTextArea(jPanel3, -1, 2, null);
        jPanel.add((Component)new JLabel("Action expression"), new AbleGridBagConstraints(0, n += 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel.add((Component)jPanel3, new AbleGridBagConstraints(1, n, 3, 4, 0.5, 0.7, 17, 1, new Insets(0, 10, 10, 0), 0, 0));
        return jPanel;
    }

    private Component getBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        int n2 = 0;
        jPanel.add((Component)new JLabel("Firing probability"), new AbleGridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0.0, 0.0, 1.0, 0.1);
        this.myFiringProbabilitySpinner = new JSpinner(spinnerNumberModel);
        jPanel.add((Component)this.myFiringProbabilitySpinner, new AbleGridBagConstraints(n2++, n, 1, 1, 0.7, 0.0, 17, 2, new Insets(0, 10, 0, 20), 0, 0));
        jPanel.add(Box.createHorizontalStrut(20), new AbleGridBagConstraints(n2++, n, 1, 1, 0.8, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel("Mean delay"), new AbleGridBagConstraints(n2++, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(0.0, 0.0, 1.0E9, 1.0);
        this.myMeanDelaySpinner = new JSpinner(spinnerNumberModel2);
        jPanel.add((Component)this.myMeanDelaySpinner, new AbleGridBagConstraints(n2++, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 0, 20), 0, 0));
        jPanel.add(Box.createHorizontalStrut(20), new AbleGridBagConstraints(n2++, n, 1, 1, 0.8, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/petrinet/doc-files/AblePetriTransitionHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

