/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.petrinet;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.petrinet.AblePetriPlace;
import com.ibm.able.beans.petrinet.AblePetriPlaceCustomizer;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class AblePetriPlacePanel
extends JPanel
implements AbleCustomizerPanel {
    private AblePetriPlace myBean = null;
    private AblePetriPlaceCustomizer myCustomizer = null;
    private JTextArea myExpressionTextArea = null;
    private JLabel myTokenCountLabel = null;

    private AblePetriPlacePanel() {
    }

    public AblePetriPlacePanel(AblePetriPlaceCustomizer ablePetriPlaceCustomizer) {
        this.myCustomizer = ablePetriPlaceCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myBean == null) {
            this.myBean = (AblePetriPlace)object;
        }
        this.myExpressionTextArea.setText(this.myBean.getExpressionText());
        this.myTokenCountLabel.setText("Number of tokens: " + this.myBean.getNumTokens());
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myBean.setExpressionText(this.myExpressionTextArea.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on PetriPlace panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on PetriPlace panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 5, 10), 0, 0));
        this.add(this.getBottomPanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 10, 10), 0, 0));
    }

    private Component getTopPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        JPanel jPanel2 = new JPanel();
        this.myExpressionTextArea = AblePanelHelper.addTextArea(jPanel2, -1, 2, null);
        jPanel.add((Component)new JLabel("Initialization expression"), new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel.add((Component)jPanel2, new AbleGridBagConstraints(1, n, 3, 2, 0.5, 0.5, 17, 1, new Insets(0, 10, 10, 0), 0, 0));
        return jPanel;
    }

    private Component getBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        int n2 = 0;
        this.myTokenCountLabel = new JLabel("Number of tokens: ");
        jPanel.add((Component)this.myTokenCountLabel, new AbleGridBagConstraints(n2++, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/petrinet/doc-files/AblePetriPlaceHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

