/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.petrinet;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObject;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.petrinet.AblePetriNet;
import com.ibm.able.editor.AbleGridBagConstraints;
import com.ibm.able.rules.AbleRuleSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

class AblePetriNetRuleSetPanel
extends JPanel
implements AbleCustomizerPanel {
    private AblePetriNet myAbleObject = null;
    private AbleObjectCustomizer myCustomizer = null;
    private JList myDataInputList = null;
    private DefaultListModel myDataInputListModel = null;
    private Hashtable myDataInputHash = new Hashtable();
    private JTextField myRuleSetFileNameTextField = new JTextField();

    private AblePetriNetRuleSetPanel() {
    }

    public AblePetriNetRuleSetPanel(AbleObjectCustomizer ableObjectCustomizer) {
        this.myCustomizer = ableObjectCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
    }

    public void getDataFromBean(AbleObject ableObject) throws RemoteException {
        AbleRuleSet ableRuleSet;
        if (this.myAbleObject == null) {
            this.myAbleObject = (AblePetriNet)ableObject;
        }
        if ((ableRuleSet = this.myAbleObject.getRuleSet()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(ableRuleSet.arlString(), Able.LS);
            while (stringTokenizer.hasMoreTokens()) {
                this.myDataInputListModel.addElement(stringTokenizer.nextToken());
            }
            this.myRuleSetFileNameTextField.setText(ableRuleSet.getSrcFileName());
        } else {
            this.myDataInputListModel.removeAllElements();
            this.myRuleSetFileNameTextField.setText(this.myCustomizer.getWorkingDirectory() + File.separator + "ruleset.arl");
        }
    }

    public void setDataOnBean() throws RemoteException {
    }

    private void initializePanel() {
        int n = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getRuleSetPanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 5, 10), 0, 0));
    }

    private Component getRuleSetPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Resulting ruleset"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        this.myDataInputListModel = new DefaultListModel();
        JPanel jPanel2 = new JPanel();
        this.myDataInputList = AblePanelHelper.addList(jPanel2, null, 2);
        this.myDataInputList.setModel(this.myDataInputListModel);
        jPanel.add((Component)jPanel2, new AbleGridBagConstraints(0, n++, 2, 1, 0.5, 0.5, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
        JButton jButton = new JButton("Save as...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AblePetriNetRuleSetPanel.this.saveAsButton_actionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText("Save the ruleset generated from the PetriNet to file");
        jPanel.add((Component)jButton, new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        jPanel.add((Component)this.myRuleSetFileNameTextField, new AbleGridBagConstraints(1, n++, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
        return jPanel;
    }

    private void saveAsButton_actionPerformed(ActionEvent actionEvent) {
        String string = this.myRuleSetFileNameTextField.getText().trim();
        AbleRuleSet ableRuleSet = this.myAbleObject.getRuleSet();
        if (ableRuleSet != null) {
            AblePanelHelper.setTextFieldFromFileSaveDialog(this.myRuleSetFileNameTextField, "Able ruleset (*.arl)", new String[]{"arl"}, string == "" ? this.myCustomizer.getWorkingDirectory() : string);
            try {
                string = this.myRuleSetFileNameTextField.getText().trim();
                ableRuleSet.saveAsArl(string);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.toString(), "AblePetriNetRuleSetPanel Error: SaveAs()", 0);
            }
        }
    }

    private void add(DefaultListModel defaultListModel, Hashtable hashtable, String string, Object object) {
        if (!hashtable.containsKey(string)) {
            hashtable.put(string, object);
            defaultListModel.addElement(string);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/petrinet/doc-files/AblePetriNetRuleSetHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

