/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.knn;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.knn.AbleKnn;
import com.ibm.able.beans.knn.AbleKnnCustomizer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AbleKnnPanel
extends JPanel
implements AbleCustomizerPanel {
    private static Vector Modes = new Vector();
    private AbleKnn myBeanObject = null;
    private int mode = 0;
    private JTextField myKparTextField = null;
    private JTextField myNumAttrTextField = null;
    private JTextField myNumClassesTextField = null;
    private JTextField myNumRecordsTextField = null;
    private JComboBox myModeComboBox = null;
    private AbleKnnCustomizer myCustomizer = null;

    public AbleKnnPanel(AbleKnnCustomizer ableKnnCustomizer) {
        this.myCustomizer = ableKnnCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        this.myBeanObject = (AbleKnn)object;
        this.myKparTextField.setText(String.valueOf(this.myBeanObject.getK()));
        this.myNumAttrTextField.setText(String.valueOf(this.myBeanObject.getNumAttributes()));
        this.myNumClassesTextField.setText(String.valueOf(this.myBeanObject.getNumClasses()));
        this.myNumRecordsTextField.setText(String.valueOf(this.myBeanObject.getNumRecords()));
        int n = this.myBeanObject.getKnnMode();
        if (n > Modes.size() - 1 || n < 0) {
            n = 0;
        }
        this.myModeComboBox.setSelectedIndex(n);
    }

    public void setKparTextField(PropertyChangeEvent propertyChangeEvent) {
        this.myKparTextField.setText(this.myBeanObject.getK() + "");
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myBeanObject.setKnnMode(this.myModeComboBox.getSelectedIndex());
            this.myBeanObject.setK(new Integer(this.myKparTextField.getText()).intValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on k-NN panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on k-NN panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = -25;
        int n2 = 30;
        int n3 = 70;
        int n4 = 60;
        int n5 = 100;
        n3 = 120;
        AblePanelHelper.addLabel(this, 120, n += n2, n5, "k param");
        AblePanelHelper.addLabel(this, n3 += n5, n, n5, "Inputs");
        AblePanelHelper.addLabel(this, n3 += n5, n, n5, "Outputs");
        AblePanelHelper.addLabel(this, n3 += n5, n, n5, "NumRecords");
        AblePanelHelper.addLabel(this, 20, n += 20, 100, "Parameters:");
        n3 = 120;
        this.myKparTextField = AblePanelHelper.addTextField(this, 120, n, n5 - 10);
        this.myKparTextField.setToolTipText("Number of neighbours considered when classifying a new instance");
        this.myNumAttrTextField = AblePanelHelper.addTextField(this, n3 += n5, n, n5 - 10);
        this.myNumAttrTextField.setToolTipText("Number of attributes");
        this.myNumAttrTextField.setEnabled(false);
        this.myNumClassesTextField = AblePanelHelper.addTextField(this, n3 += n5, n, n5 - 10);
        this.myNumClassesTextField.setToolTipText("Number of classes");
        this.myNumClassesTextField.setEnabled(false);
        this.myNumRecordsTextField = AblePanelHelper.addTextField(this, n3 += n5, n, n5 - 10);
        this.myNumRecordsTextField.setToolTipText("Number of records");
        this.myNumRecordsTextField.setEnabled(false);
        n3 = 20;
        AblePanelHelper.addLabel(this, 20, n += 2 * n2, 100, "Mode:");
        n3 = 120;
        this.myModeComboBox = AblePanelHelper.addComboBox(this, 120, n, 100);
        this.myModeComboBox.setModel(new DefaultComboBoxModel(Modes));
        this.myModeComboBox.setToolTipText("Lazy learning: Store data, calculate error, or calculate only results");
        AblePanelHelper.addButton(this, 300, n, 100, "Reset Bean", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleKnnPanel.this.ResetButton_actionPerformed(actionEvent);
            }
        }, "Reset the algorithm statistics (e.g., number correct examples, error)");
    }

    void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (1 == JOptionPane.showConfirmDialog(this, "This will reset the statistics of the bean and start over the test or run phase  \n Are you sure you want to do this?", "Reset", 0)) {
                return;
            }
            this.myBeanObject.reset();
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, remoteException.toString(), "AbleKnnBeanPanel Error: ResetButton()", 0);
        }
    }

    private void addPropertyListeners() {
        this.myCustomizer.addPropertyChangeMethod("K", this, "setKparTextField");
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/knn/doc-files/AbleKnnHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static {
        Modes.addElement("Train");
        Modes.addElement("Test");
        Modes.addElement("Run");
    }
}

