/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.knn;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.AbleNetwork;
import com.ibm.able.beans.knn.AbleDecisionTreeClassifierAgent;
import com.ibm.able.beans.knn.AbleDecisionTreeClassifierAgentCustomizer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AbleDecisionTreeClassifierAgentPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleDecisionTreeClassifierAgent myAgent = null;
    private AbleDecisionTreeClassifierAgentCustomizer myCustomizer = null;
    private JTextField myTrainFileTextField = null;
    private JTextField myTestFileTextField = null;
    private JTextField myNumAttrTextField = null;
    private JTextField myNumClassesTextField = null;
    private JTextField myNumRecordsTextField = null;
    private JTextField myMetricTextField = null;
    private JTextField myDiscretizationTextField = null;
    private JButton myGenerateButton = null;
    private JComboBox myAgentModeComboBox = null;
    private JButton myResetBeansButton = null;
    private TextListener myTextListener = null;

    private AbleDecisionTreeClassifierAgentPanel() {
    }

    public AbleDecisionTreeClassifierAgentPanel(AbleDecisionTreeClassifierAgentCustomizer ableDecisionTreeClassifierAgentCustomizer) {
        this.myCustomizer = ableDecisionTreeClassifierAgentCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myAgent == null) {
            this.myAgent = (AbleDecisionTreeClassifierAgent)object;
        }
        String string = this.myAgent.getTrainDataFileName();
        if (!this.myTrainFileTextField.getText().equals(string)) {
            this.myTrainFileTextField.setText(string);
        }
        string = this.myAgent.getTestDataFileName();
        if (!this.myTestFileTextField.getText().equals(string)) {
            this.myTestFileTextField.setText(string);
        }
        int n = this.myAgent.getMode();
        if (this.myAgentModeComboBox.getSelectedIndex() != n) {
            this.myAgentModeComboBox.setSelectedIndex(n);
        }
        this.myMetricTextField.setText(String.valueOf(this.myAgent.getMetric()));
        this.myDiscretizationTextField.setText(String.valueOf(this.myAgent.getDiscretization()));
        this.myNumAttrTextField.setText(String.valueOf(this.myAgent.getNumAttributes()));
        this.myNumClassesTextField.setText(String.valueOf(this.myAgent.getNumClasses()));
        this.myNumRecordsTextField.setText(String.valueOf(this.myAgent.getNumRecords()));
        this.setButtonStates();
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myAgent.setTrainDataFileName(this.myTrainFileTextField.getText().trim());
            this.myAgent.setTestDataFileName(this.myTestFileTextField.getText().trim());
            this.myAgent.setMetric(Integer.valueOf(this.myMetricTextField.getText().trim()).intValue());
            this.myAgent.setDiscretization(Integer.valueOf(this.myDiscretizationTextField.getText().trim()).intValue());
            this.myAgent.setMode(this.myAgentModeComboBox.getSelectedIndex());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Decision Tree Classifer panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Decision Tree Classifer panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = -25;
        int n2 = 35;
        int n3 = 50;
        int n4 = 80;
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Training File Name:");
        this.myTrainFileTextField = AblePanelHelper.addTextField(this, 170, n, 220);
        this.myTrainFileTextField.setToolTipText("Definition file which provides the record layout and data type");
        this.myTextListener = new TextListener();
        this.myTrainFileTextField.getDocument().addDocumentListener(this.myTextListener);
        AblePanelHelper.addButton(this, 400, n, 100, "Browse...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDecisionTreeClassifierAgentPanel.this.BrowseTrainingButton_actionPerformed(actionEvent);
            }
        }, "Select a definition file for constructing beans and training");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Testing File Name:");
        this.myTestFileTextField = AblePanelHelper.addTextField(this, 170, n, 220);
        this.myTestFileTextField.setToolTipText("Definition file which provides the record layout and data type");
        this.myTestFileTextField.getDocument().addDocumentListener(this.myTextListener);
        AblePanelHelper.addButton(this, 400, n, 100, "Browse...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDecisionTreeClassifierAgentPanel.this.BrowseTestingButton_actionPerformed(actionEvent);
            }
        }, "Select a definition file to test decision tree algorithm");
        n3 = 170;
        AblePanelHelper.addLabel(this, 170, n += n2, n4, "SplitCrit");
        AblePanelHelper.addLabel(this, n3 += n4, n, n4, "DiscrInt");
        AblePanelHelper.addLabel(this, 20, n += 20, 150, "Alg parameters:");
        n3 = 170;
        this.myMetricTextField = AblePanelHelper.addTextField(this, 170, n, n4 - 10);
        this.myMetricTextField.setToolTipText("Metric used to choose best attribute");
        this.myDiscretizationTextField = AblePanelHelper.addTextField(this, n3 += n4, n, n4 - 10);
        this.myDiscretizationTextField.setToolTipText("Number of discretization intervals");
        n3 = 170;
        AblePanelHelper.addLabel(this, 170, n += n2, n4, "Inputs");
        AblePanelHelper.addLabel(this, n3 += n4, n, n4, "Outputs");
        AblePanelHelper.addLabel(this, n3 += n4, n, n4, "NumRecords");
        AblePanelHelper.addLabel(this, 20, n += 20, 150, "Data parameters:");
        n3 = 170;
        this.myNumAttrTextField = AblePanelHelper.addTextField(this, 170, n, n4 - 10);
        this.myNumAttrTextField.setToolTipText("Number of attributes");
        this.myNumAttrTextField.setEnabled(false);
        this.myNumClassesTextField = AblePanelHelper.addTextField(this, n3 += n4, n, n4 - 10);
        this.myNumClassesTextField.setToolTipText("Number of possible classes");
        this.myNumClassesTextField.setEnabled(false);
        this.myNumRecordsTextField = AblePanelHelper.addTextField(this, n3 += n4, n, n4 - 10);
        this.myNumRecordsTextField.setToolTipText("Number of records in training set");
        this.myNumRecordsTextField.setEnabled(false);
        this.myGenerateButton = AblePanelHelper.addButton(this, 170, n += n2, 160, "Generate Beans", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDecisionTreeClassifierAgentPanel.this.GenerateButton_actionPerformed(actionEvent);
            }
        }, "Create beans from training data");
        this.myResetBeansButton = AblePanelHelper.addButton(this, 170, n += n2, 160, "Reset Beans", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDecisionTreeClassifierAgentPanel.this.ResetButton_actionPerformed(actionEvent);
            }
        }, "Reset all agent beans");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Agent Mode:");
        this.myAgentModeComboBox = AblePanelHelper.addComboBox(this, 170, n, 100);
        for (int i = 0; i < AbleNetwork.MODE_NAMES.length; ++i) {
            this.myAgentModeComboBox.addItem(AbleNetwork.MODE_NAMES[i]);
        }
        this.myAgentModeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AbleDecisionTreeClassifierAgentPanel.this.setButtonStates();
            }
        });
    }

    private void addPropertyListeners() {
        this.myCustomizer.addPropertyChangeMethod("Metric", this, "refreshPanel");
        this.myCustomizer.addPropertyChangeMethod("Discretization", this, "refreshPanel");
    }

    private void setButtonStates() {
        try {
            boolean bl = this.myTrainFileTextField.getText().trim().length() > 0;
            boolean bl2 = this.myTestFileTextField.getText().trim().length() > 0;
            boolean bl3 = this.isGenerated();
            this.myGenerateButton.setEnabled(bl);
            this.myResetBeansButton.setEnabled(bl3);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private boolean isGenerated() throws RemoteException {
        return this.myAgent != null && this.myAgent.getBeans() != null && this.myAgent.getBeans().size() >= 5;
    }

    private void BrowseTrainingButton_actionPerformed(ActionEvent actionEvent) {
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myTrainFileTextField, "Definition File (*.dfn)", "dfn", this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void BrowseTestingButton_actionPerformed(ActionEvent actionEvent) {
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myTestFileTextField, "Definition File (*.dfn)", "dfn", this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void GenerateButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myAgent.getBeans() != null && this.myAgent.getBeans().size() > 0 && 1 == JOptionPane.showConfirmDialog(this, "This will erase existing beans and regenerate them.\nInspector property changes and inspectors themselves will need to be recreated.\n\nAre you sure you want to do this?", "Regenerate Beans", 0)) {
                return;
            }
            this.myCustomizer.updateProperties();
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myAgent.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleDecisionTreeClassifierAgentPanel Error: GenerateButton()", 0);
        }
    }

    private void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.updateProperties();
            this.myAgent.reset();
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleDecisionTreeClassifierAgentPanel Error: ResetButton()", 0);
        }
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.getDataFromBean(this.myAgent);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this.myCustomizer, "Panel values for training changed, but were not updated.\n" + remoteException.toString(), "AbleDecisionTreeClassifierAgentPanel Warning: refreshPanel()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/knn/doc-files/AbleDecisionTreeClassifierAgentHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class TextListener
    implements DocumentListener {
        TextListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AbleDecisionTreeClassifierAgentPanel.this.setButtonStates();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbleDecisionTreeClassifierAgentPanel.this.setButtonStates();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbleDecisionTreeClassifierAgentPanel.this.setButtonStates();
        }
    }
}

