/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.decisiontree;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.decisiontree.AbleDecisionTree;
import com.ibm.able.beans.decisiontree.AbleDecisionTreeCustomizer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AbleDecisionTreePanel
extends JPanel
implements AbleCustomizerPanel {
    private static Vector Modes = new Vector();
    private AbleDecisionTree myBeanObject = null;
    private AbleObjectCustomizer myCustomizer = null;
    private JComboBox myModeComboBox = null;
    private JTextField myDiscretizationIntervalTextField = null;
    private JLabel myTreeBuiltLabel = null;
    private JButton myInitButton = null;
    private JButton myResetButton = null;

    private AbleDecisionTreePanel() {
    }

    public AbleDecisionTreePanel(AbleDecisionTreeCustomizer ableDecisionTreeCustomizer) {
        this.myCustomizer = ableDecisionTreeCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        int n;
        if (this.myBeanObject == null) {
            this.myBeanObject = (AbleDecisionTree)object;
        }
        if ((n = this.myBeanObject.getNetMode()) > Modes.size() - 1 || n < 0) {
            n = 0;
        }
        this.myModeComboBox.setSelectedIndex(n);
        this.myDiscretizationIntervalTextField.setText(String.valueOf(this.myBeanObject.getDiscretizationInterval()));
        this.handleTreeBuilt(null);
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myBeanObject.setNetMode(this.myModeComboBox.getSelectedIndex());
            this.myBeanObject.setDiscretizationInterval(Integer.parseInt(this.myDiscretizationIntervalTextField.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on DecisionTree panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input or invalid definition file provided on DecisionTree panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = -25;
        int n2 = 40;
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Mode:");
        this.myModeComboBox = AblePanelHelper.addComboBox(this, 170, n, 100);
        for (int i = 0; i < Modes.size(); ++i) {
            this.myModeComboBox.addItem(Modes.elementAt(i));
        }
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Discretization interval:");
        this.myDiscretizationIntervalTextField = AblePanelHelper.addTextField(this, 170, n, 100);
        this.myDiscretizationIntervalTextField.setToolTipText("Number of intervals used to discretize continuous fields");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Tree built:");
        this.myTreeBuiltLabel = AblePanelHelper.addLabel(this, 170, n, 70, "");
        this.myTreeBuiltLabel.setToolTipText("Tree is built by initializing the bean and cycling the container agent");
        this.myInitButton = AblePanelHelper.addButton(this, 70, n += n2, 180, "Initialize", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDecisionTreePanel.this.InitButton_actionPerformed(actionEvent);
            }
        }, "Read the active data source and initialize the Decision Tree for this bean");
        this.myResetButton = AblePanelHelper.addButton(this, 280, n, 180, "Reset statistics", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDecisionTreePanel.this.ResetButton_actionPerformed(actionEvent);
            }
        }, "Reset tree and statistics for this DecisionTree bean");
    }

    private void addPropertyListeners() {
        this.myCustomizer.addPropertyChangeMethod("built", this, "handleTreeBuilt");
    }

    public void handleTreeBuilt(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        this.setButtonStates();
        this.setTreeBuiltLabel();
    }

    private void setTreeBuiltLabel() {
        this.myTreeBuiltLabel.setText(new Boolean(this.myBeanObject.isDecisionTreeBuilt()).toString());
    }

    private void setButtonStates() {
        this.myResetButton.setEnabled(this.myBeanObject.isDecisionTreeBuilt());
    }

    private void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myBeanObject.isDecisionTreeBuilt() && 1 == JOptionPane.showConfirmDialog(this, "This will reset test statistics.\n\nAre you sure you want to do this?", "Reset Tree", 0)) {
                return;
            }
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.setDataOnBean();
            this.myBeanObject.resetStatistics();
            this.myCustomizer.setObject(this.myBeanObject);
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occurred while resetting the Decision Tree\n" + exception.toString(), "AbleDecisionTreePanel Error: resetButton()", 2);
        }
    }

    private void InitButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.setDataOnBean();
            this.myBeanObject.init();
            this.myCustomizer.setObject(this.myBeanObject);
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occurred while initializing the Decision Tree\n" + exception.toString(), "AbleDecisionTreePanel Error: InitButton()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/decisiontree/doc-files/AbleDecisionTreeHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 2000.";
    }

    static {
        Modes.addElement("Train");
        Modes.addElement("Test");
        Modes.addElement("Run");
    }
}

