/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans.bayes;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.bayes.AbleNaiveBayes;
import com.ibm.able.beans.bayes.AbleNaiveBayesCustomizer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AbleNaiveBayesPanel
extends JPanel
implements AbleCustomizerPanel {
    private static Vector Modes = new Vector();
    private AbleNaiveBayes myBeanObject = null;
    private AbleObjectCustomizer myCustomizer = null;
    private JComboBox myModeComboBox = null;

    private AbleNaiveBayesPanel() {
    }

    public AbleNaiveBayesPanel(AbleNaiveBayesCustomizer ableNaiveBayesCustomizer) {
        this.myCustomizer = ableNaiveBayesCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        this.myBeanObject = (AbleNaiveBayes)object;
        int n = this.myBeanObject.getNetMode();
        if (n > Modes.size() - 1 || n < 0) {
            n = 0;
        }
        this.myModeComboBox.setSelectedIndex(n);
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myBeanObject.setNetMode(this.myModeComboBox.getSelectedIndex());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on NaiveBayes panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input or invalid definition file provided on NaiveBayes panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = -25;
        int n2 = 40;
        AblePanelHelper.addLabel(this, 20, n += n2, 100, "Mode:");
        this.myModeComboBox = AblePanelHelper.addComboBox(this, 120, n, 100);
        for (int i = 0; i < Modes.size(); ++i) {
            this.myModeComboBox.addItem(Modes.elementAt(i));
        }
        AblePanelHelper.addButton(this, 70, n += n2, 180, "Create network", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleNaiveBayesPanel.this.OpenButton_actionPerformed(actionEvent);
            }
        }, "Read the data file and create the Naive Bayes network for this bean");
    }

    private void BrowseButton_actionPerformed(ActionEvent actionEvent) {
    }

    private void GenerateButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setDataOnBean();
            this.getDataFromBean(this.myBeanObject);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "An error occurred while generating the filter template\n" + iOException.toString(), "AbleNaiveBayesPanel Error: generateButton()", 2);
        }
    }

    private void OpenButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setDataOnBean();
            this.myBeanObject.init();
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, "An error occurred while opening the definition file\n" + remoteException.toString(), "AbleNaiveBayesPanel Error: openButton()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/bayes/doc-files/AbleNaiveBayesHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static {
        Modes.addElement("Train");
        Modes.addElement("Test");
    }
}

