/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.beans.AbleTimeSeriesFilter;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AbleTimeSeriesFilterPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleTimeSeriesFilter myTimeSeriesFilterObject = null;
    private AbleObjectCustomizer myCustomizer = null;
    private JTextField myWindowSizeTextField = null;
    private JTextField myHorizonTextField = null;
    private JTextField myNumInUnitsTextField = null;
    private JTextField myNumOutUnitsTextField = null;

    private AbleTimeSeriesFilterPanel() {
    }

    public AbleTimeSeriesFilterPanel(AbleObjectCustomizer ableObjectCustomizer) {
        this.myCustomizer = ableObjectCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myTimeSeriesFilterObject == null) {
            this.myTimeSeriesFilterObject = (AbleTimeSeriesFilter)object;
        }
        this.myWindowSizeTextField.setText(String.valueOf(this.myTimeSeriesFilterObject.getWindowSize()));
        this.myHorizonTextField.setText(String.valueOf(this.myTimeSeriesFilterObject.getHorizon()));
        this.myNumInUnitsTextField.setText(String.valueOf(this.myTimeSeriesFilterObject.getNumInUnits()));
        this.myNumOutUnitsTextField.setText(String.valueOf(this.myTimeSeriesFilterObject.getNumOutUnits()));
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myTimeSeriesFilterObject.setWindowSize(Integer.parseInt(this.myWindowSizeTextField.getText().trim()));
            this.myTimeSeriesFilterObject.setHorizon(Integer.parseInt(this.myHorizonTextField.getText().trim()));
            this.myTimeSeriesFilterObject.setNumInUnits(Integer.parseInt(this.myNumInUnitsTextField.getText().trim()));
            this.myTimeSeriesFilterObject.setNumOutUnits(Integer.parseInt(this.myNumOutUnitsTextField.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Time Series Filter panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Time Series Filter panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)new JLabel("Window Size:"), new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.myWindowSizeTextField = new JTextField();
        this.myWindowSizeTextField.setToolTipText("Number of data points to use");
        this.add((Component)this.myWindowSizeTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 70, 0));
        this.add((Component)new JLabel("Horizon:"), new AbleGridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.myHorizonTextField = new JTextField();
        this.myHorizonTextField.setToolTipText("Number of points in the future to predict");
        this.add((Component)this.myHorizonTextField, new AbleGridBagConstraints(3, n, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 0, 5), 70, 0));
        this.add((Component)new JLabel("Number of inputs:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.myNumInUnitsTextField = new JTextField();
        this.myNumInUnitsTextField.setToolTipText("Number of inputs");
        this.add((Component)this.myNumInUnitsTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 0, 5), 70, 0));
        this.add((Component)new JLabel("Number of outputs:"), new AbleGridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.myNumOutUnitsTextField = new JTextField();
        this.myNumOutUnitsTextField.setToolTipText("Number of outputs");
        this.add((Component)this.myNumOutUnitsTextField, new AbleGridBagConstraints(3, n, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 0, 5), 70, 0));
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/doc-files/AbleTimeSeriesFilterHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

