/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.AbleTemporalDifferenceLearning;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AbleTemporalDifferenceLearningPanel
extends JPanel
implements AbleCustomizerPanel {
    private static Vector Modes = new Vector();
    private static Vector FeedbackTypes;
    private AbleTemporalDifferenceLearning myBeanObject = null;
    private String myArchitecture = null;
    private JTextField myArchInputTextField = null;
    private JTextField myArchHidden1TextField = null;
    private JTextField myArchHidden2TextField = null;
    private JTextField myArchHidden3TextField = null;
    private JTextField myArchOutputTextField = null;
    private JTextField myLearnRateTextField = null;
    private JTextField myMomentumTextField = null;
    private JTextField myToleranceTextField = null;
    private JTextField myDecayFactorTextField = null;
    private JComboBox myModeComboBox = null;
    private JComboBox myFeedbackComboBox = null;
    private JTextField myLambdaTextField = null;
    private JTextField myGammaTextField = null;
    private JCheckBox myAdaptiveLearningCheckBox = null;

    public AbleTemporalDifferenceLearningPanel() {
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.myArchitecture = "0 0 0 0 0 0";
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        int n = 0;
        this.myBeanObject = (AbleTemporalDifferenceLearning)object;
        String string = this.myBeanObject.getNetArchitecture();
        if (string != null) {
            this.myArchitecture = string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.myArchitecture);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n2) {
                case 0: {
                    this.myArchInputTextField.setText(string2);
                    break;
                }
                case 1: {
                    this.myArchHidden1TextField.setText(string2);
                    break;
                }
                case 2: {
                    this.myArchHidden2TextField.setText(string2);
                    break;
                }
                case 3: {
                    this.myArchHidden3TextField.setText(string2);
                    break;
                }
                case 4: {
                    this.myArchOutputTextField.setText(string2);
                    break;
                }
                case 5: {
                    n = Integer.parseInt(string2);
                }
            }
            ++n2;
        }
        this.myModeComboBox.setSelectedIndex(n);
        this.myLearnRateTextField.setText(String.valueOf(this.myBeanObject.getLearnRate()));
        this.myMomentumTextField.setText(String.valueOf(this.myBeanObject.getMomentum()));
        this.myToleranceTextField.setText(String.valueOf(this.myBeanObject.getTolerance()));
        this.myDecayFactorTextField.setText(String.valueOf(this.myBeanObject.getDecayFactor()));
        n2 = this.myBeanObject.getNetMode();
        if (n2 > Modes.size() - 1 || n2 < 0) {
            n2 = 0;
        }
        this.myModeComboBox.setSelectedIndex(n2);
        this.myLambdaTextField.setText(String.valueOf(this.myBeanObject.getLambda()));
        this.myGammaTextField.setText(String.valueOf(this.myBeanObject.getGamma()));
        this.myAdaptiveLearningCheckBox.setSelected(this.myBeanObject.isAdaptLearnRate());
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myBeanObject.setLearnRate(Double.valueOf(this.myLearnRateTextField.getText().trim()).doubleValue());
            this.myBeanObject.setMomentum(Double.valueOf(this.myMomentumTextField.getText().trim()).doubleValue());
            this.myBeanObject.setTolerance(Double.valueOf(this.myToleranceTextField.getText().trim()).doubleValue());
            this.myBeanObject.setDecayFactor(Double.valueOf(this.myDecayFactorTextField.getText().trim()).doubleValue());
            this.myBeanObject.setNetMode(this.myModeComboBox.getSelectedIndex());
            this.myBeanObject.setLambda(Double.valueOf(this.myLambdaTextField.getText().trim()).doubleValue());
            this.myBeanObject.setGamma(Double.valueOf(this.myGammaTextField.getText().trim()).doubleValue());
            this.myBeanObject.setAdaptLearnRate(this.myAdaptiveLearningCheckBox.isSelected());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Temporal Difference panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Temporal Difference panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n;
        int n2 = -25;
        int n3 = 30;
        int n4 = 70;
        int n5 = 60;
        n4 = 120;
        AblePanelHelper.addLabel(this, 120, n2 += n3, n5, "Inputs");
        AblePanelHelper.addLabel(this, n4 += n5, n2, n5, "Hidden1");
        AblePanelHelper.addLabel(this, n4 += n5, n2, n5, "Hidden2");
        AblePanelHelper.addLabel(this, n4 += n5, n2, n5, "Hidden3");
        AblePanelHelper.addLabel(this, n4 += n5, n2, n5, "Outputs");
        AblePanelHelper.addLabel(this, n4 += n5, n2, 80, "Feedback");
        AblePanelHelper.addLabel(this, 20, n2 += 20, 100, "Architecture:");
        n4 = 120;
        this.myArchInputTextField = AblePanelHelper.addTextField(this, 120, n2, n5 - 10);
        this.myArchInputTextField.setToolTipText("Number of inputs");
        this.myArchInputTextField.setToolTipText("Number of inputs");
        this.myArchHidden1TextField = AblePanelHelper.addTextField(this, n4 += n5, n2, n5 - 10);
        this.myArchHidden1TextField.setToolTipText("Nodes in hidden layer 1");
        this.myArchHidden2TextField = AblePanelHelper.addTextField(this, n4 += n5, n2, n5 - 10);
        this.myArchHidden2TextField.setToolTipText("Nodes in hidden layer 2");
        this.myArchHidden3TextField = AblePanelHelper.addTextField(this, n4 += n5, n2, n5 - 10);
        this.myArchHidden3TextField.setToolTipText("Nodes in hidden layer 3");
        this.myArchOutputTextField = AblePanelHelper.addTextField(this, n4 += n5, n2, n5 - 10);
        this.myArchOutputTextField.setToolTipText("Number of outputs");
        this.myFeedbackComboBox = AblePanelHelper.addComboBox(this, n4 += n5, n2, 100);
        for (n = 0; n < FeedbackTypes.size(); ++n) {
            this.myFeedbackComboBox.addItem(FeedbackTypes.elementAt(n));
        }
        AblePanelHelper.addButton(this, 150, n2 += n3, 150, "Set Architecture", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleTemporalDifferenceLearningPanel.this.SetNetArchButton_actionPerformed(actionEvent);
            }
        }, "Set the network architecture");
        AblePanelHelper.addButton(this, 320, n2, 150, "Reset Weights", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleTemporalDifferenceLearningPanel.this.ResetButton_actionPerformed(actionEvent);
            }
        }, "Reset all network weights");
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "Learn Rate:");
        this.myLearnRateTextField = AblePanelHelper.addTextField(this, 120, n2, 150);
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "Momentum:");
        this.myMomentumTextField = AblePanelHelper.addTextField(this, 120, n2, 150);
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "Tolerance:");
        this.myToleranceTextField = AblePanelHelper.addTextField(this, 120, n2, 150);
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "Decay factor:");
        this.myDecayFactorTextField = AblePanelHelper.addTextField(this, 120, n2, 150);
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "Mode:");
        this.myModeComboBox = AblePanelHelper.addComboBox(this, 120, n2, 100);
        for (n = 0; n < Modes.size(); ++n) {
            this.myModeComboBox.addItem(Modes.elementAt(n));
        }
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "Lambda:");
        this.myLambdaTextField = AblePanelHelper.addTextField(this, 120, n2, 150);
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "Gamma:");
        this.myGammaTextField = AblePanelHelper.addTextField(this, 120, n2, 150);
        this.myAdaptiveLearningCheckBox = AblePanelHelper.addCheckBox(this, 120, n2 += n3, 200, "Adaptive learn rate");
    }

    void SetNetArchButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myBeanObject.getWeights4() != null && 1 == JOptionPane.showConfirmDialog(this, "This will erase the existing network and  \n any training will be lost.\nAre you sure you want to do this?", "Change Network Architecture", 0)) {
                return;
            }
            String string = this.myArchInputTextField.getText().trim() + " " + this.myArchHidden1TextField.getText().trim() + " " + this.myArchHidden2TextField.getText().trim() + " " + this.myArchHidden3TextField.getText().trim() + " " + this.myArchOutputTextField.getText().trim() + " " + this.myFeedbackComboBox.getSelectedIndex();
            Integer.parseInt(this.myArchInputTextField.getText().trim());
            Integer.parseInt(this.myArchHidden1TextField.getText().trim());
            Integer.parseInt(this.myArchHidden2TextField.getText().trim());
            Integer.parseInt(this.myArchHidden3TextField.getText().trim());
            Integer.parseInt(this.myArchOutputTextField.getText().trim());
            this.myBeanObject.setNetArchitecture(string);
            this.myArchitecture = string;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleTemporalDifferenceLearningPanel Error: SetNetArchButton()", 0);
        }
    }

    void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myBeanObject.getWeights4() != null && 1 == JOptionPane.showConfirmDialog(this, "This will reset the existing weights and  \n any training will be lost.\nAre you sure you want to do this?", "Reset Network Weights", 0)) {
                return;
            }
            this.myBeanObject.reset();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleTemporalDifferenceLearningPanel Error: ResetButton()", 0);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/doc-files/AbleTemporalDifferenceLearningHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static {
        Modes.addElement("Train");
        Modes.addElement("Test");
        Modes.addElement("Run");
        FeedbackTypes = new Vector();
        FeedbackTypes.addElement("None");
        FeedbackTypes.addElement("Hidden layer");
        FeedbackTypes.addElement("Output layer");
    }
}

