/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.AbleSelfOrganizingMap;
import com.ibm.able.beans.AbleSelfOrganizingMapCustomizer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AbleSelfOrganizingMapPanel
extends JPanel
implements AbleCustomizerPanel {
    private static Vector Modes = new Vector();
    private AbleSelfOrganizingMap myBeanObject = null;
    private AbleSelfOrganizingMapCustomizer myCustomizer = null;
    private String myArchitecture = null;
    private JTextField myArchInputTextField = null;
    private JTextField myArchOutput1TextField = null;
    private JTextField myArchOutput2TextField = null;
    private JTextField myLearnRateTextField = null;
    private JTextField myMaximumEpochsTextField = null;
    private JTextField myConscienceTextField = null;
    private JComboBox myModeComboBox = null;
    private JCheckBox myEpochUpdateCheckBox = null;

    private AbleSelfOrganizingMapPanel() {
    }

    public AbleSelfOrganizingMapPanel(AbleSelfOrganizingMapCustomizer ableSelfOrganizingMapCustomizer) {
        this.myCustomizer = ableSelfOrganizingMapCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.myArchitecture = "0 0 0";
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        this.myBeanObject = (AbleSelfOrganizingMap)object;
        String string = this.myBeanObject.getNetArchitecture();
        if (string != null) {
            this.myArchitecture = string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.myArchitecture);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    this.myArchInputTextField.setText(string2);
                    break;
                }
                case 1: {
                    this.myArchOutput1TextField.setText(string2);
                    break;
                }
                case 2: {
                    this.myArchOutput2TextField.setText(string2);
                }
            }
            ++n;
        }
        this.myLearnRateTextField.setText(String.valueOf(this.myBeanObject.getLearnRate()));
        this.myMaximumEpochsTextField.setText(String.valueOf(this.myBeanObject.getMaxNumEpochs()));
        this.myConscienceTextField.setText(String.valueOf(this.myBeanObject.getConscience()));
        n = this.myBeanObject.getNetMode();
        if (n > Modes.size() - 1 || n < 0) {
            n = 0;
        }
        this.myModeComboBox.setSelectedIndex(n);
        this.myEpochUpdateCheckBox.setSelected(this.myBeanObject.getEpochUpdate());
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myBeanObject.setLearnRate(Double.valueOf(this.myLearnRateTextField.getText().trim()).doubleValue());
            this.myBeanObject.setMaxNumEpochs(Integer.parseInt(this.myMaximumEpochsTextField.getText().trim()));
            this.myBeanObject.setConscience(Double.valueOf(this.myConscienceTextField.getText().trim()).doubleValue());
            this.myBeanObject.setNetMode(this.myModeComboBox.getSelectedIndex());
            this.myBeanObject.setEpochUpdate(this.myEpochUpdateCheckBox.isSelected());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Self Organizing Map panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Self Organizing Map panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = -25;
        int n2 = 40;
        int n3 = 70;
        int n4 = 100;
        n3 = 150;
        AblePanelHelper.addLabel(this, 150, n += n2, n4, "Inputs");
        AblePanelHelper.addLabel(this, n3 += n4, n, n4, "Output Rows");
        AblePanelHelper.addLabel(this, n3 += n4, n, 150, "Output Columns");
        AblePanelHelper.addLabel(this, 20, n += 20, 100, "Architecture:");
        n3 = 150;
        this.myArchInputTextField = AblePanelHelper.addTextField(this, 150, n, n4 - 30);
        this.myArchInputTextField.setToolTipText("Number of inputs");
        this.myArchOutput1TextField = AblePanelHelper.addTextField(this, n3 += n4, n, n4 - 30);
        this.myArchOutput1TextField.setToolTipText("Number of rows");
        this.myArchOutput2TextField = AblePanelHelper.addTextField(this, n3 += n4, n, n4 - 30);
        this.myArchOutput2TextField.setToolTipText("Number of columns");
        AblePanelHelper.addButton(this, 150, n += n2, 150, "Set Architecture", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleSelfOrganizingMapPanel.this.SetNetArchButton_actionPerformed(actionEvent);
            }
        }, "Set or change the network architecture");
        AblePanelHelper.addButton(this, 320, n, 150, "Reset Weights", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleSelfOrganizingMapPanel.this.ResetButton_actionPerformed(actionEvent);
            }
        }, "Reset all network weights");
        AblePanelHelper.addLabel(this, 20, n += n2, 100, "Learn Rate:");
        this.myLearnRateTextField = AblePanelHelper.addTextField(this, 175, n, 150);
        AblePanelHelper.addLabel(this, 20, n += n2, 130, "Number of passes:");
        this.myMaximumEpochsTextField = AblePanelHelper.addTextField(this, 175, n, 150);
        AblePanelHelper.addLabel(this, 20, n += n2, 100, "Conscience:");
        this.myConscienceTextField = AblePanelHelper.addTextField(this, 175, n, 150);
        AblePanelHelper.addLabel(this, 20, n += n2, 100, "Mode:");
        this.myModeComboBox = AblePanelHelper.addComboBox(this, 175, n, 100);
        for (int i = 0; i < Modes.size(); ++i) {
            this.myModeComboBox.addItem(Modes.elementAt(i));
        }
        this.myEpochUpdateCheckBox = AblePanelHelper.addCheckBox(this, 175, n += n2, 200, "Epoch (batch) updates");
    }

    void SetNetArchButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myBeanObject.getWeights() != null && 1 == JOptionPane.showConfirmDialog(this, "This will erase the existing network and   \nany training will be lost.\nAre you sure you want to do this?", "Change Network Architecture", 0)) {
                return;
            }
            this.myCustomizer.updateProperties();
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            String string = this.myArchInputTextField.getText().trim() + " " + this.myArchOutput1TextField.getText().trim() + " " + this.myArchOutput2TextField.getText().trim();
            Integer.parseInt(this.myArchInputTextField.getText().trim());
            Integer.parseInt(this.myArchOutput1TextField.getText().trim());
            Integer.parseInt(this.myArchOutput2TextField.getText().trim());
            this.myBeanObject.setNetArchitecture(string);
            this.myArchitecture = string;
            this.myBeanObject.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myBeanObject);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Invalid genetic object class name.\n" + exception.toString(), "AbleSelfOrganizingMapPanelCustomizer Error: resetButton()", 0);
        }
    }

    void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myBeanObject.getWeights() != null && 1 == JOptionPane.showConfirmDialog(this, "This will reset the existing weights and  \n any training will be lost.\nAre you sure you want to do this?", "Reset Network Weights", 0)) {
                return;
            }
            this.myBeanObject.reset();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Invalid genetic object class name.\n" + exception.toString(), "AbleSelfOrganizingMapPanelCustomizer Error: resetButton()", 0);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/doc-files/AbleSelfOrganizingMapHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static {
        Modes.addElement("Train");
        Modes.addElement("Test");
        Modes.addElement("Run");
    }
}

