/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.AbleRadialBasisFunctionNet;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AbleRadialBasisFunctionNetPanel
extends JPanel
implements AbleCustomizerPanel {
    private static Vector Modes = new Vector();
    private static Vector BasisFunctions;
    private AbleRadialBasisFunctionNet myBeanObject = null;
    private String myArchitecture = null;
    private JTextField myArchInputTextField = null;
    private JTextField myArchHiddenTextField = null;
    private JTextField myArchOutputTextField = null;
    private JTextField myLearnRateTextField = null;
    private JTextField myMomentumTextField = null;
    private JTextField myToleranceTextField = null;
    private JTextField myAllWidthsTextField = null;
    private JComboBox myModeComboBox = null;
    private JComboBox myBasisFunctionComboBox = null;
    private JCheckBox myExplicitErrorCheckBox = null;
    private JCheckBox myEpochUpdateCheckBox = null;
    private JCheckBox myAdaptiveLearningCheckBox = null;
    private JCheckBox myNormalizeCheckBox = null;
    private JCheckBox myAutoCenterCheckBox = null;

    public AbleRadialBasisFunctionNetPanel() {
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.myArchitecture = "0 0 0 0";
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        this.myBeanObject = (AbleRadialBasisFunctionNet)object;
        String string = this.myBeanObject.getNetArchitecture();
        if (string != null) {
            this.myArchitecture = string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.myArchitecture);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    this.myArchInputTextField.setText(string2);
                    break;
                }
                case 1: {
                    this.myArchHiddenTextField.setText(string2);
                    break;
                }
                case 2: {
                    this.myArchOutputTextField.setText(string2);
                }
            }
            ++n;
        }
        this.myLearnRateTextField.setText(String.valueOf(this.myBeanObject.getLearnRate()));
        this.myMomentumTextField.setText(String.valueOf(this.myBeanObject.getMomentum()));
        this.myToleranceTextField.setText(String.valueOf(this.myBeanObject.getTolerance()));
        this.myAllWidthsTextField.setText(String.valueOf(this.myBeanObject.getAllWidths()));
        n = this.myBeanObject.getNetMode();
        if (n > Modes.size() - 1 || n < 0) {
            n = 0;
        }
        this.myModeComboBox.setSelectedIndex(n);
        int n2 = this.myBeanObject.getBasisFunction();
        if (n2 >= BasisFunctions.size() - 1 || n2 < 0) {
            n2 = 0;
        }
        this.myBasisFunctionComboBox.setSelectedIndex(n2);
        this.myExplicitErrorCheckBox.setSelected(this.myBeanObject.isExplicitErrorMode());
        this.myEpochUpdateCheckBox.setSelected(this.myBeanObject.isEpochUpdate());
        this.myAdaptiveLearningCheckBox.setSelected(this.myBeanObject.isAdaptLearnRate());
        this.myNormalizeCheckBox.setSelected(this.myBeanObject.isNormalized());
        this.myAutoCenterCheckBox.setSelected(this.myBeanObject.getAutoCenter());
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myBeanObject.setLearnRate(Double.valueOf(this.myLearnRateTextField.getText().trim()).doubleValue());
            this.myBeanObject.setMomentum(Double.valueOf(this.myMomentumTextField.getText().trim()).doubleValue());
            this.myBeanObject.setTolerance(Double.valueOf(this.myToleranceTextField.getText().trim()).doubleValue());
            this.myBeanObject.setAllWidths(Double.valueOf(this.myAllWidthsTextField.getText().trim()).doubleValue());
            this.myBeanObject.setNetMode(this.myModeComboBox.getSelectedIndex());
            this.myBeanObject.setBasisFunction(this.myBasisFunctionComboBox.getSelectedIndex());
            this.myBeanObject.setExplicitErrorMode(this.myExplicitErrorCheckBox.isSelected());
            this.myBeanObject.setEpochUpdate(this.myEpochUpdateCheckBox.isSelected());
            this.myBeanObject.setAdaptLearnRate(this.myAdaptiveLearningCheckBox.isSelected());
            this.myBeanObject.setNormalized(this.myNormalizeCheckBox.isSelected());
            this.myBeanObject.setAutoCenter(this.myAutoCenterCheckBox.isSelected());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Back Propagation panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Back Propagation panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n;
        int n2 = -25;
        int n3 = 30;
        int n4 = 70;
        int n5 = 60;
        n4 = 120;
        AblePanelHelper.addLabel(this, 120, n2 += n3, n5, "Inputs");
        AblePanelHelper.addLabel(this, n4 += n5, n2, n5, "Hidden");
        AblePanelHelper.addLabel(this, n4 += n5, n2, n5, "Outputs");
        AblePanelHelper.addLabel(this, 20, n2 += 20, 100, "Architecture:");
        n4 = 120;
        this.myArchInputTextField = AblePanelHelper.addTextField(this, 120, n2, n5 - 10);
        this.myArchInputTextField.setToolTipText("Number of inputs");
        this.myArchInputTextField.setToolTipText("Number of inputs");
        this.myArchHiddenTextField = AblePanelHelper.addTextField(this, n4 += n5, n2, n5 - 10);
        this.myArchHiddenTextField.setToolTipText("Nodes in hidden layer");
        this.myArchOutputTextField = AblePanelHelper.addTextField(this, n4 += n5, n2, n5 - 10);
        this.myArchOutputTextField.setToolTipText("Number of outputs");
        AblePanelHelper.addButton(this, 150, n2 += n3, 150, "Set Architecture", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRadialBasisFunctionNetPanel.this.SetNetArchButton_actionPerformed(actionEvent);
            }
        }, "Set the network architecture");
        AblePanelHelper.addButton(this, 320, n2, 150, "Reset Weights", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRadialBasisFunctionNetPanel.this.ResetButton_actionPerformed(actionEvent);
            }
        }, "Reset all network weights");
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "Learn Rate:");
        this.myLearnRateTextField = AblePanelHelper.addTextField(this, 120, n2, 150);
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "Momentum:");
        this.myMomentumTextField = AblePanelHelper.addTextField(this, 120, n2, 150);
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "Tolerance:");
        this.myToleranceTextField = AblePanelHelper.addTextField(this, 120, n2, 150);
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "All widths:");
        this.myAllWidthsTextField = AblePanelHelper.addTextField(this, 120, n2, 150);
        AblePanelHelper.addLabel(this, 20, n2 += n3, 100, "Mode:");
        this.myModeComboBox = AblePanelHelper.addComboBox(this, 120, n2, 100);
        for (n = 0; n < Modes.size(); ++n) {
            this.myModeComboBox.addItem(Modes.elementAt(n));
        }
        AblePanelHelper.addLabel(this, 300, n2, 100, "Basis Function:");
        this.myBasisFunctionComboBox = AblePanelHelper.addComboBox(this, 400, n2, 100);
        for (n = 0; n < BasisFunctions.size(); ++n) {
            this.myBasisFunctionComboBox.addItem(BasisFunctions.elementAt(n));
        }
        this.myExplicitErrorCheckBox = AblePanelHelper.addCheckBox(this, 120, n2 += n3, 180, "Explicit error mode");
        this.myNormalizeCheckBox = AblePanelHelper.addCheckBox(this, 300, n2, 180, "Normalize basis outputs");
        this.myEpochUpdateCheckBox = AblePanelHelper.addCheckBox(this, 120, n2 += n3, 180, "Epoch (batch) updates");
        this.myAutoCenterCheckBox = AblePanelHelper.addCheckBox(this, 300, n2, 200, "Auto-find center weights");
        this.myAdaptiveLearningCheckBox = AblePanelHelper.addCheckBox(this, 120, n2 += n3, 200, "Adaptive learn rate");
    }

    void SetNetArchButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myBeanObject.getWeights() != null && 1 == JOptionPane.showConfirmDialog(this, "This will erase the existing network and  \n any training will be lost.\nAre you sure you want to do this?", "Change Network Architecture", 0)) {
                return;
            }
            String string = this.myArchInputTextField.getText().trim() + " " + this.myArchHiddenTextField.getText().trim() + " " + this.myArchOutputTextField.getText().trim();
            Integer.parseInt(this.myArchInputTextField.getText().trim());
            Integer.parseInt(this.myArchHiddenTextField.getText().trim());
            Integer.parseInt(this.myArchOutputTextField.getText().trim());
            this.myBeanObject.setAutoCenter(this.myAutoCenterCheckBox.isSelected());
            this.myBeanObject.setNetArchitecture(string);
            this.myArchitecture = string;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleRadialBasisFunctionNetPanel Error: SetNetArchButton()", 0);
        }
    }

    void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myBeanObject.getWeights() != null && 1 == JOptionPane.showConfirmDialog(this, "This will reset the existing weights and  \n any training will be lost.\nAre you sure you want to do this?", "Reset Network Weights", 0)) {
                return;
            }
            this.myBeanObject.reset();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleRadialBasisFunctionNetPanel Error: ResetButton()", 0);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/doc-files/AbleRadialBasisFunctionNetHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static {
        Modes.addElement("Train");
        Modes.addElement("Test");
        Modes.addElement("Run");
        BasisFunctions = new Vector();
        BasisFunctions.addElement("Gaussian");
        BasisFunctions.addElement("Thin-plate Spline");
        BasisFunctions.addElement("Multi-Quadratic");
    }
}

