/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.AbleEvent;
import com.ibm.able.AbleEventListener;
import com.ibm.able.beans.AbleNetwork;
import com.ibm.able.editor.AbleCustomInspectorView;
import com.ibm.able.editor.AbleInspectorContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AbleNetworkGraphicView
extends JPanel
implements AbleCustomInspectorView,
AbleEventListener,
PropertyChangeListener,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    static final int maxCharHeight = 15;
    static final int minFontSize = 6;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    static final Color red = Color.red;
    static final Color white = Color.white;
    static final Color blue = Color.blue;
    static final BasicStroke stroke = new BasicStroke(1.5f);
    static final BasicStroke wideStroke = new BasicStroke(8.0f);
    static final float[] dash1 = new float[]{10.0f};
    static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    Dimension totalSize;
    FontMetrics fontMetrics;
    int[] layerSizes;
    double[] activations;
    Vector weightsArrays;
    protected double activationOnThreshold = 0.6;
    protected double activationOffThreshold = 0.4;
    protected double weightThreshold = 0.2;
    ContextData myContext = null;
    int gridWidth;
    int gridHeight;
    int rectWidth;
    int rectHeight;
    int stringY;
    int columnOffset;
    int inset;
    int[] layerXPos;
    int[] layerYPos;
    AbleNetwork myNeuralNetwork;
    boolean okToPaint = false;
    boolean myRefreshAllowed = true;
    int myCurrentStepCount = 0;
    int myStepsPerRefresh = 1;

    public AbleNetworkGraphicView(Object object) {
        this.enableEvents(64L);
        this.setBackground(bg);
        this.setForeground(fg);
        try {
            this.myNeuralNetwork = (AbleNetwork)object;
            this.myNeuralNetwork.addAbleEventListener((AbleEventListener)this);
            this.myNeuralNetwork.addPropertyChangeListener((PropertyChangeListener)this);
            this.initNetArchParameters();
            this.refreshView();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void initializeTestNetArchParameters() {
        int n;
        this.layerSizes = new int[]{10, 7, 3};
        this.activations = new double[20];
        for (n = 0; n < this.activations.length; ++n) {
            this.activations[n] = 1.0 - Math.random();
        }
        this.weightsArrays = new Vector();
        double[] dArray = new double[70];
        this.weightsArrays.addElement(dArray);
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = 0.5 - Math.random();
        }
        dArray = new double[21];
        this.weightsArrays.addElement(dArray);
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = 0.5 - Math.random();
        }
    }

    protected void initNetArchParameters() {
        this.okToPaint = this.myNeuralNetwork.getState() != 1026;
        Vector vector = this.myNeuralNetwork.getNetworkGraphicData();
        if (vector != null) {
            this.layerSizes = (int[])vector.elementAt(0);
            this.activations = (double[])vector.elementAt(1);
            this.weightsArrays = (Vector)vector.elementAt(2);
        } else {
            System.out.println("Error -- Network does not support Network Graphic Inspector View!");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("netArchitecture")) {
            this.okToPaint = false;
            this.initNetArchParameters();
            this.refreshView();
        }
    }

    public void handleAbleEvent(AbleEvent ableEvent) {
        ++this.myCurrentStepCount;
        if (this.myCurrentStepCount >= this.myStepsPerRefresh) {
            this.myCurrentStepCount = 0;
            if (this.myRefreshAllowed) {
                this.refreshView();
            }
        }
    }

    public void init() {
    }

    FontMetrics pickFont(Graphics2D graphics2D, String string, int n) {
        boolean bl = false;
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = font.getSize();
        String string2 = font.getName();
        int n3 = font.getStyle();
        while (!bl) {
            if (fontMetrics.getHeight() <= 15 && fontMetrics.stringWidth(string) <= n) {
                bl = true;
                continue;
            }
            if (n2 <= 6) {
                bl = true;
                continue;
            }
            font = new Font(string2, n3, --n2);
            graphics2D.setFont(font);
            fontMetrics = graphics2D.getFontMetrics();
        }
        return fontMetrics;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dimension = this.getSize();
        if (!this.okToPaint) {
            return;
        }
        int n3 = this.layerSizes.length;
        int n4 = this.activations.length;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < this.layerSizes.length; ++n2) {
            n5 += this.layerSizes[n2];
            if (this.layerSizes[n2] <= n6) continue;
            n6 = this.layerSizes[n2];
        }
        if (n5 != n4) {
            System.out.println("NetGraphics - error - activations array does not match net architecture");
        }
        n2 = 0;
        boolean bl = true;
        this.gridWidth = dimension.width / (n3 + 2);
        this.gridHeight = dimension.height / (n6 + 2);
        if (this.gridWidth > this.gridHeight) {
            this.gridWidth = this.gridHeight;
        } else if (this.gridWidth < this.gridHeight) {
            this.gridHeight = this.gridWidth;
        }
        this.fontMetrics = this.pickFont(graphics2D, "8888", this.gridWidth);
        graphics2D.setPaint(fg);
        this.inset = 10;
        this.rectWidth = this.gridWidth - this.inset;
        this.stringY = this.fontMetrics.getDescent();
        this.rectHeight = this.gridHeight - this.inset;
        int n7 = dimension.width - 2 * n3 * this.gridWidth;
        this.columnOffset = this.gridWidth + (n7 /= n3);
        int n8 = this.gridWidth;
        int n9 = 7;
        this.layerYPos = new int[n3];
        for (n = 0; n < n3; ++n) {
            this.layerYPos[n] = n9 + (dimension.height - this.layerSizes[n] * this.gridHeight) / 2;
        }
        this.layerXPos = new int[n3];
        this.layerXPos[0] = n8;
        for (n = 1; n < n3; ++n) {
            this.layerXPos[n] = this.layerXPos[n - 1] + this.gridWidth + this.columnOffset;
        }
        n = 0;
        this.drawLayerOfUnits(graphics2D, 0, n);
        n += this.layerSizes[0];
        for (int i = 1; i < n3; ++i) {
            this.drawLayerOfUnits(graphics2D, i, n);
            n += this.layerSizes[i];
            this.drawConnectionsBetweenLayers(graphics2D, i - 1, this.layerSizes[i - 1]);
        }
    }

    protected void drawLayerOfUnits(Graphics2D graphics2D, int n, int n2) {
        int n3 = this.layerXPos[n];
        int n4 = this.layerYPos[n];
        graphics2D.drawString(String.valueOf(n2), n3, n4 - this.stringY);
        int n5 = n2;
        for (int i = 0; i < this.layerSizes[n]; ++i) {
            int n6 = n5++;
            double d = this.activations[n6];
            if (d < this.activationOffThreshold) {
                graphics2D.setPaint(blue);
                graphics2D.fill(new Ellipse2D.Double(n3, n4, this.rectWidth, this.rectHeight));
            } else if (d < this.activationOnThreshold) {
                graphics2D.setStroke(stroke);
                graphics2D.draw(new Ellipse2D.Double(n3, n4, this.rectWidth, this.rectHeight));
            } else {
                graphics2D.setPaint(red);
                graphics2D.fill(new Ellipse2D.Double(n3, n4, this.rectWidth, this.rectHeight));
            }
            graphics2D.setPaint(fg);
            n4 += this.gridHeight;
        }
        graphics2D.drawString(String.valueOf(n2 + this.layerSizes[n] - 1), n3, n4 - this.stringY);
    }

    protected void drawConnectionsBetweenLayers(Graphics2D graphics2D, int n, int n2) {
        int n3 = n;
        int n4 = n3 + 1;
        int n5 = this.rectHeight / 2;
        int n6 = this.layerXPos[n3] + this.rectWidth;
        int n7 = this.layerXPos[n4];
        int n8 = this.layerYPos[n3] + n5;
        int n9 = this.layerYPos[n4] + n5;
        double[] dArray = (double[])this.weightsArrays.elementAt(n);
        double d = 0.0;
        for (int i = 0; i < this.layerSizes[n3]; ++i) {
            int n10 = i;
            for (int j = 0; j < this.layerSizes[n4]; ++j) {
                d = dArray[n10];
                if (d < 0.0 - this.weightThreshold) {
                    graphics2D.setPaint(blue);
                    graphics2D.draw(new Line2D.Double(n6, n8 + i * this.gridHeight, n7, n9 + j * this.gridHeight));
                } else if (d > this.weightThreshold) {
                    graphics2D.setPaint(red);
                    graphics2D.draw(new Line2D.Double(n6, n8 + i * this.gridHeight, n7, n9 + j * this.gridHeight));
                }
                n10 += this.layerSizes[n3];
            }
        }
        graphics2D.setPaint(fg);
    }

    protected void refreshView() {
        this.invalidate();
        this.repaint();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("NeuralNetGraphicDemo");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        AbleNetworkGraphicView ableNetworkGraphicView = new AbleNetworkGraphicView((Object)null);
        jFrame.getContentPane().add("Center", ableNetworkGraphicView);
        ableNetworkGraphicView.init();
        jFrame.pack();
        jFrame.setSize(new Dimension(300, 600));
        jFrame.setVisible(true);
    }

    public double getActivationOnThreshold() {
        return this.activationOnThreshold;
    }

    public void setActivationOnThreshold(double d) {
        this.activationOnThreshold = d;
    }

    public double getActivationOffThreshold() {
        return this.activationOffThreshold;
    }

    public void setActivationOffThreshold(double d) {
        this.activationOffThreshold = d;
    }

    public double getWeightThreshold() {
        return this.weightThreshold;
    }

    public void setWeightThreshold(double d) {
        this.weightThreshold = d;
    }

    public Object getContext() {
        ContextData contextData = new ContextData();
        contextData.activationOnThreshold = this.activationOnThreshold;
        contextData.activationOffThreshold = this.activationOffThreshold;
        contextData.weightThreshold = this.weightThreshold;
        return contextData;
    }

    public void setContext(AbleInspectorContext ableInspectorContext) {
        if (ableInspectorContext != null && this.myContext == null && ableInspectorContext.customViewData instanceof ContextData) {
            ContextData contextData;
            this.myContext = contextData = (ContextData)ableInspectorContext.customViewData;
            this.setActivationOnThreshold(contextData.activationOnThreshold);
            this.setActivationOffThreshold(contextData.activationOffThreshold);
            this.setWeightThreshold(contextData.weightThreshold);
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class ContextData
    implements Serializable {
        double activationOnThreshold;
        double activationOffThreshold;
        double weightThreshold;

        ContextData() {
        }
    }
}

