/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.AbleImport;
import com.ibm.able.beans.filter.AbleFilter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AbleImportPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleImport myImportObject = null;
    private AbleObjectCustomizer myCustomizer = null;
    private JTextField myDefinitionFileTextField = null;
    private JComboBox myDelimitersComboBox = null;
    private JComboBox myBufferSizeComboBox = null;
    private JCheckBox myRandomizeCheckBox = null;
    private JTextField myCycleSizeTextField = null;
    private JCheckBox myCycleModeCheckBox = null;
    private JCheckBox myComputeStatisticsCheckBox = null;
    private JButton myOpenButton = null;
    private JButton myGenerateButton = null;
    private TextListener myTextListener = null;

    private AbleImportPanel() {
    }

    public AbleImportPanel(AbleObjectCustomizer ableObjectCustomizer) {
        this.myCustomizer = ableObjectCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        String string;
        this.myImportObject = (AbleImport)object;
        this.myDefinitionFileTextField.setText(this.myImportObject.getDataFileName());
        int n = this.myImportObject.getBufferSize();
        if (n == 0) {
            this.myBufferSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"All"}));
        } else {
            string = new Integer(n).toString();
            this.myBufferSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{string, "All"}));
        }
        string = this.myImportObject.getDelimiter();
        int n2 = AbleImport.DelimiterChars.indexOf(string == null ? " " : string);
        n2 = n2 == -1 ? 0 : n2;
        this.myDelimitersComboBox.setSelectedItem(AbleImport.DelimiterNames.elementAt(n2));
        this.myRandomizeCheckBox.setSelected(this.myImportObject.isRandomizeData());
        this.myCycleSizeTextField.setText(this.myImportObject.getCycleSizeAsString());
        this.myCycleModeCheckBox.setSelected(this.myImportObject.isCycleRelative());
        this.myComputeStatisticsCheckBox.setSelected(this.myImportObject.getComputeStatistics() || 0 == this.myImportObject.getFieldList().size());
        this.setButtonStates();
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myImportObject.setDataFileName(this.getDefinitionFile());
            this.myImportObject.setDelimiter((String)AbleImport.DelimiterChars.elementAt(this.myDelimitersComboBox.getSelectedIndex()));
            String string = ((String)this.myBufferSizeComboBox.getSelectedItem()).trim();
            if (string.equalsIgnoreCase("ALL")) {
                this.myImportObject.setBufferSize(0);
            } else {
                this.myImportObject.setBufferSize(Integer.parseInt(string));
            }
            String string2 = this.myCycleSizeTextField.getText().trim();
            this.myImportObject.setCycleSize(Double.parseDouble(string2), this.myCycleModeCheckBox.isSelected());
            this.myImportObject.setRandomizeData(this.myRandomizeCheckBox.isSelected());
            this.myImportObject.setComputeStatistics(this.myComputeStatisticsCheckBox.isSelected());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Import panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input or invalid definition file provided on Import panel.\n" + nullPointerException.toString());
        }
    }

    private String getDefinitionFile() {
        String string = this.myDefinitionFileTextField.getText().trim();
        if (string.endsWith(".dfn")) {
            int n = string.lastIndexOf(".dfn");
            return string.substring(0, n);
        }
        return string;
    }

    private void initializePanel() {
        int n = -25;
        int n2 = 40;
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Definition file:");
        this.myDefinitionFileTextField = AblePanelHelper.addTextField(this, 170, n, 230);
        this.myDefinitionFileTextField.setToolTipText("Provide the path and name of the definition and corresponding data file");
        this.myTextListener = new TextListener();
        this.myDefinitionFileTextField.getDocument().addDocumentListener(this.myTextListener);
        AblePanelHelper.addButton(this, 410, n, 100, "Browse...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleImportPanel.this.BrowseButton_actionPerformed(actionEvent);
            }
        }, "Select a definition file");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Delimiters:");
        this.myDelimitersComboBox = AblePanelHelper.addComboBox(this, 170, n, 100);
        for (int i = 0; i < AbleImport.DelimiterNames.size(); ++i) {
            this.myDelimitersComboBox.addItem(AbleImport.DelimiterNames.elementAt(i));
        }
        this.myDelimitersComboBox.setToolTipText("Select the delimiter used between fields");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Record cache count:");
        this.myBufferSizeComboBox = AblePanelHelper.addComboBox(this, 170, n, 100);
        this.myBufferSizeComboBox.setToolTipText("Number of data records to keep in memory");
        this.myBufferSizeComboBox.setEditable(true);
        this.myRandomizeCheckBox = AblePanelHelper.addCheckBox(this, 290, n, 200, "Randomize data");
        this.myRandomizeCheckBox.setToolTipText("Randomize the order of data records");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Steps per cycle:");
        this.myCycleSizeTextField = AblePanelHelper.addTextField(this, 170, n, 100);
        this.myCycleSizeTextField.setToolTipText("Number of data records to process in a cycle");
        this.myCycleModeCheckBox = AblePanelHelper.addCheckBox(this, 290, n, 200, "Relative to file size");
        this.myCycleModeCheckBox.setToolTipText("Multiply by file size or absolute");
        this.myComputeStatisticsCheckBox = AblePanelHelper.addCheckBox(this, 90, n += n2, 200, "Compute field statistics");
        this.myComputeStatisticsCheckBox.setToolTipText("Scan each field for min/max/mean or members");
        this.myOpenButton = AblePanelHelper.addButton(this, 70, n += n2, 180, "Open File", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleImportPanel.this.OpenButton_actionPerformed(actionEvent);
            }
        }, "Open the definition and data files for this import bean");
        this.myGenerateButton = AblePanelHelper.addButton(this, 280, n, 180, "Generate Filters", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleImportPanel.this.GenerateButton_actionPerformed(actionEvent);
            }
        }, "Generate filter templates to use with this Import bean");
    }

    private void setButtonStates() {
        boolean bl;
        boolean bl2 = bl = this.myDefinitionFileTextField.getText().trim().length() > 0;
        if (bl != this.myOpenButton.isEnabled()) {
            this.myOpenButton.setEnabled(bl);
        }
        if (bl != this.myGenerateButton.isEnabled()) {
            this.myGenerateButton.setEnabled(bl);
        }
    }

    private void BrowseButton_actionPerformed(ActionEvent actionEvent) {
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myDefinitionFileTextField, "Definition File (*.dfn)", "dfn", this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void GenerateButton_actionPerformed(ActionEvent actionEvent) {
        try {
            boolean bl = false;
            if (!this.myImportObject.isReady() || !this.myImportObject.getDataFileName().equals(this.getDefinitionFile())) {
                this.setDataOnBean();
                this.myImportObject.init();
                bl = true;
            }
            AbleFilter ableFilter = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
            AbleFilter ableFilter2 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_OutputFilter"));
            AbleFilter.generateTranslateTemplates((AbleFilter)ableFilter, (AbleFilter)ableFilter2, (Vector)this.myImportObject.getFieldList());
            this.myImportObject.getParent().addBean((AbleBean)ableFilter);
            new AbleBufferConnection((AbleBean)this.myImportObject, (AbleBean)ableFilter);
            this.myImportObject.getParent().addBean((AbleBean)ableFilter2);
            if (bl) {
                this.myCustomizer.setObject(this.myImportObject);
            } else {
                this.getDataFromBean(this.myImportObject);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occurred while generating the filter template\n" + exception.toString(), "AbleImportPanel Error: generateButton()", 2);
        }
    }

    private void OpenButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myCustomizer.updateProperties();
            this.myImportObject.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myImportObject);
            if (!this.myImportObject.isReady()) {
                JOptionPane.showMessageDialog(this, "An error occurred while opening the file\n", "AbleImportPanel Error: openButton()", 2);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occurred while opening the definition file\n" + exception.toString(), "AbleImportPanel Error: openButton()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/doc-files/AbleImportHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class TextListener
    implements DocumentListener {
        TextListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AbleImportPanel.this.setButtonStates();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbleImportPanel.this.setButtonStates();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbleImportPanel.this.setButtonStates();
        }
    }
}

