/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.AbleExport;
import com.ibm.able.beans.AbleImport;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AbleExportPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleExport myExportObject = null;
    private AbleObjectCustomizer myCustomizer = null;
    private JTextField myExportFileTextField = null;
    private JComboBox myDelimitersComboBox = null;

    private AbleExportPanel() {
    }

    public AbleExportPanel(AbleObjectCustomizer ableObjectCustomizer) {
        this.myCustomizer = ableObjectCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        this.myExportObject = (AbleExport)object;
        this.myExportFileTextField.setText(this.myExportObject.getDataFileName());
        String string = this.myExportObject.getDelimiter();
        int n = AbleImport.DelimiterChars.indexOf(string == null ? " " : string);
        n = n == -1 ? 0 : n;
        this.myDelimitersComboBox.setSelectedItem(AbleImport.DelimiterNames.elementAt(n));
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myExportObject.setDataFileName(this.myExportFileTextField.getText().trim());
            this.myExportObject.setDelimiter((String)AbleImport.DelimiterChars.elementAt(this.myDelimitersComboBox.getSelectedIndex()));
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Export panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = -25;
        int n2 = 40;
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Export to File Name:");
        this.myExportFileTextField = AblePanelHelper.addTextField(this, 170, n, 230);
        this.myExportFileTextField.setToolTipText("Provide the path and name of the output data file");
        AblePanelHelper.addButton(this, 410, n, 100, "Browse...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleExportPanel.this.BrowseButton_actionPerformed(actionEvent);
            }
        }, "Select an output data file");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Delimiters:");
        this.myDelimitersComboBox = AblePanelHelper.addComboBox(this, 170, n, 100);
        for (int i = 0; i < AbleImport.DelimiterNames.size(); ++i) {
            this.myDelimitersComboBox.addItem(AbleImport.DelimiterNames.elementAt(i));
        }
        this.myDelimitersComboBox.setToolTipText("Select the delimiter to use between fields");
        AblePanelHelper.addButton(this, 70, n += n2, 120, "Open file", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleExportPanel.this.OpenButton_actionPerformed(actionEvent);
            }
        }, "Open the output data file in append mode");
        AblePanelHelper.addButton(this, 200, n, 120, "Close file", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleExportPanel.this.CloseButton_actionPerformed(actionEvent);
            }
        }, "Close the output data file");
        AblePanelHelper.addButton(this, 330, n, 120, "Erase file", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleExportPanel.this.EraseButton_actionPerformed(actionEvent);
            }
        }, "Erase all entries from the output data file and close the file");
    }

    private void BrowseButton_actionPerformed(ActionEvent actionEvent) {
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myExportFileTextField, "Export File (*.out)", "out", this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void OpenButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setDataOnBean();
            this.myExportObject.init();
            this.myCustomizer.setObject(this.myExportObject);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleExportPanel Error: openButton()", 2);
        }
    }

    void CloseButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setDataOnBean();
            this.myExportObject.close();
            this.myCustomizer.setObject(this.myExportObject);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleExportPanel Error: eraseButton()", 2);
        }
    }

    void EraseButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setDataOnBean();
            this.myExportObject.erase();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleExportPanel Error: eraseButton()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/doc-files/AbleExportHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

