/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleAgent;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleEvent;
import com.ibm.able.AbleEventListener;
import com.ibm.able.AbleException;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.AbleAbstractImport;
import com.ibm.able.data.AbleData;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.data.AbleField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class AbleDataSetPanel
extends JPanel
implements AbleEventListener,
AbleCustomizerPanel {
    static final int NUM_COLS = 4;
    static final int COL_NAMEID = 0;
    private static final String COL_NAME = "Name";
    static final int COL_TYPEID = 1;
    private static final String COL_TYPE = "Data Type";
    static final int COL_USAGEID = 2;
    private static final String COL_USAGE = "Usage";
    static final int COL_VALUEID = 3;
    private static final String COL_VALUE = "Value";
    private static NumberFormat numberFormatter = NumberFormat.getInstance();
    private AbleAbstractImport myImportObject = null;
    private Vector myFieldList = null;
    private AbleDataSetPanel myDataSetPanel = null;
    private AbleObjectCustomizer myCustomizer = null;
    private JTable myDataSetTable = null;
    private TableModel myDataSetTableModel = null;
    private JComboBox myUsageComboBox = null;
    private JButton myFirstButton = null;
    private JButton myLastButton = null;
    private JButton myPreviousButton = null;
    protected String[] columnNameList = new String[]{"Name", "Data Type", "Usage", "Value"};
    protected Object[][] data = null;
    private boolean usageChanged = false;

    private AbleDataSetPanel() {
    }

    public AbleDataSetPanel(AbleObjectCustomizer ableObjectCustomizer) {
        this.myCustomizer = ableObjectCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws AbleException {
        if (this.myImportObject == null) {
            this.myImportObject = (AbleAbstractImport)object;
            this.myDataSetPanel = this;
            this.myImportObject.addAbleEventListener((AbleEventListener)this.myDataSetPanel);
        }
        this.myFieldList = this.myImportObject.getFieldList();
        if (this.myFieldList != null) {
            this.data = this.getTableData();
            this.updateTable();
            this.setButtonStates();
        }
    }

    public void setDataOnBean() throws AbleException {
        this.setFieldUsage();
    }

    private void setFieldUsage() throws AbleException {
        if (this.myFieldList == null || !this.usageChanged) {
            return;
        }
        int n = this.myFieldList.size();
        for (int i = 0; i < n; ++i) {
            AbleField ableField = (AbleField)this.myFieldList.elementAt(i);
            ableField.setUsage((String)this.data[i][2]);
        }
        this.usageChanged = false;
    }

    private void initializePanel() {
        this.setUpTheTable();
        JScrollPane jScrollPane = new JScrollPane(this.myDataSetTable);
        jScrollPane.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        this.myFirstButton = AblePanelHelper.addButton(jPanel, "First", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDataSetPanel.this.FirstButton_actionPerformed(actionEvent);
            }
        }, "Read and display first record");
        this.myPreviousButton = AblePanelHelper.addButton(jPanel, "<-Previous", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDataSetPanel.this.PreviousButton_actionPerformed(actionEvent);
            }
        }, "Read and display previous record");
        AblePanelHelper.addButton(jPanel, "Process", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDataSetPanel.this.ProcessButton_actionPerformed(actionEvent);
            }
        }, "Process the data shown");
        AblePanelHelper.addButton(jPanel, "Next->", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDataSetPanel.this.NextButton_actionPerformed(actionEvent);
            }
        }, "Read and display next record");
        this.myLastButton = AblePanelHelper.addButton(jPanel, "Last", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDataSetPanel.this.LastButton_actionPerformed(actionEvent);
            }
        }, "Read and display last record");
        this.add((Component)jPanel, "South");
    }

    private void setButtonStates() {
        if (this.myImportObject == null) {
            return;
        }
        if (this.myImportObject.getBufferSize() != 0) {
            this.myFirstButton.setEnabled(false);
            this.myLastButton.setEnabled(false);
            this.myPreviousButton.setEnabled(false);
            return;
        }
        long l = this.myImportObject.getRecordIndex();
        this.myFirstButton.setEnabled(l != 0L);
        this.myPreviousButton.setEnabled(l > 0L);
        this.myLastButton.setEnabled(l < this.myImportObject.getNumRecords() - 1L);
    }

    public void setUpTheTable() {
        this.myDataSetTable = new JTable();
        this.data = this.getTableData();
        this.myDataSetTableModel = new AbstractTableModel(){

            public int getColumnCount() {
                return AbleDataSetPanel.this.columnNameList.length;
            }

            public int getRowCount() {
                return AbleDataSetPanel.this.data.length;
            }

            public Object getValueAt(int n, int n2) {
                return AbleDataSetPanel.this.data[n][n2];
            }

            public String getColumnName(int n) {
                return AbleDataSetPanel.this.columnNameList[n];
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                boolean bl = false;
                switch (n2) {
                    case 0: 
                    case 1: {
                        bl = false;
                        break;
                    }
                    case 2: 
                    case 3: {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                return bl;
            }

            public void setValueAt(Object object, int n, int n2) {
                Object var4_4 = null;
                String string = ((String)object).trim();
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        AbleDataSetPanel.this.usageChanged = true;
                        AbleDataSetPanel.this.data[n][n2] = string;
                        break;
                    }
                    case 3: {
                        AbleDataSetPanel.this.data[n][n2] = string;
                    }
                }
            }
        };
        this.myDataSetTable = new JTable(this.myDataSetTableModel);
        this.myDataSetTable.setSelectionMode(0);
        this.myDataSetTable.getColumn(COL_NAME).setPreferredWidth(90);
        this.myDataSetTable.getColumn(COL_USAGE).setPreferredWidth(60);
        this.myDataSetTable.getColumn(COL_VALUE).setPreferredWidth(60);
        this.myUsageComboBox = new JComboBox();
        this.myUsageComboBox.addItem(AbleData.UsageTypeString((int)0));
        this.myUsageComboBox.addItem(AbleData.UsageTypeString((int)1));
        this.myUsageComboBox.addItem(AbleData.UsageTypeString((int)2));
        this.myDataSetTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.myUsageComboBox));
        this.myDataSetTable.setCellSelectionEnabled(true);
    }

    private Object[][] getTableData() {
        Object[][] objectArray = null;
        if (this.myFieldList == null) {
            objectArray = new Object[1][4];
            objectArray[0][0] = "";
            objectArray[0][1] = "";
            objectArray[0][2] = "";
            objectArray[0][3] = "null";
            return objectArray;
        }
        int n = this.myFieldList.size();
        objectArray = new Object[n][4];
        for (int i = 0; i < n; ++i) {
            AbleField ableField = (AbleField)this.myFieldList.elementAt(i);
            try {
                objectArray[i][0] = ableField.getName();
                objectArray[i][1] = ableField.getDataTypeString();
                objectArray[i][2] = ableField.getUsageString();
                objectArray[i][3] = ableField.getStringValue();
                continue;
            }
            catch (AbleDataException ableDataException) {
                System.out.println("Exception " + ableDataException.toString());
            }
        }
        return objectArray;
    }

    private void updateTableData() throws AbleException {
        if (this.myFieldList == null || this.data.length == 0) {
            return;
        }
        String[] stringArray = this.myImportObject.getOutputBufferAsStringArray();
        if (stringArray == null) {
            int n = this.myFieldList.size();
            for (int i = 0; i < n; ++i) {
                this.data[i][3] = "null";
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                this.data[i][3] = stringArray[i];
            }
        }
    }

    private void updateTable() throws AbleException {
        this.updateTableData();
        TableModelEvent tableModelEvent = new TableModelEvent(this.myDataSetTableModel);
        this.myDataSetTable.tableChanged(tableModelEvent);
    }

    private void addPropertyListeners() {
        this.myCustomizer.addPropertyChangeMethod("dataSource", this, "refreshPanel");
    }

    void FirstButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myImportObject.getRecordIndex() == 0L) {
                this.PreviousButton_actionPerformed(actionEvent);
            } else {
                this.setFieldUsage();
                this.myImportObject.setRecordIndex(-1L);
                this.myImportObject.process();
                this.setButtonStates();
            }
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.toString());
            JOptionPane.showMessageDialog(this, "An error occurred while retrieving the first record.\n" + exception.getMessage(), "AbleDataSetPanel Error: FirstButton()", 0);
        }
    }

    void LastButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setFieldUsage();
            this.myImportObject.setRecordIndex((long)((int)this.myImportObject.numRecords - 2));
            this.myImportObject.process();
            this.updateTable();
            this.setButtonStates();
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.toString());
            JOptionPane.showMessageDialog(this, "An error occurred while retrieving the last record.\n" + exception.getMessage(), "AbleDataSetPanel Error: LastButton()", 0);
        }
    }

    void NextButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setFieldUsage();
            this.myImportObject.process();
            this.updateTable();
            this.setButtonStates();
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.toString());
            JOptionPane.showMessageDialog(this, "An error occurred while retrieving the next record.\n" + exception.getMessage(), "AbleDataSetPanel Error: NextButton()", 0);
        }
    }

    void PreviousButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setFieldUsage();
            long l = this.myImportObject.getRecordIndex();
            if (l == 0L) {
                JOptionPane.showMessageDialog(this.myCustomizer, "Already at first record.", "AbleDataSetPanel Information", 1);
            } else {
                this.myImportObject.setRecordIndex(l - 2L);
                this.myImportObject.process();
                this.updateTable();
                this.setButtonStates();
            }
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.toString());
            JOptionPane.showMessageDialog(this, "An error occurred while retrieving the previous record.\n" + exception.getMessage(), "AbleDataSetPanel Error: PreviousButton()", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void ProcessButton_actionPerformed(ActionEvent actionEvent) {
        boolean bl2;
        AbleAgent ableAgent;
        block15: {
            ableAgent = null;
            bl2 = false;
            boolean bl = false;
            try {
                try {
                    this.setFieldUsage();
                    int n = this.myFieldList.size();
                    Object object = null;
                    Object object2 = this.myImportObject.getOutputBuffer();
                    if (object2 instanceof String[]) {
                        object = ((String[])object2).clone();
                        this.myImportObject.setOutputBuffer(object);
                        for (int i = 0; i < n; ++i) {
                            this.myImportObject.setOutputBuffer(i, this.data[i][3]);
                        }
                    } else {
                        if (!(object2 instanceof double[])) throw new AbleException("Unsupported outputBuffer type <" + object2.getClass().getName() + ">");
                        object = ((double[])object2).clone();
                        this.myImportObject.setOutputBuffer(object);
                        for (int i = 0; i < n; ++i) {
                            Number number = numberFormatter.parse((String)this.data[i][3]);
                            this.myImportObject.setOutputBuffer(i, (Object)new Double(number.doubleValue()));
                        }
                    }
                    if (!(bl2 = (ableAgent = (AbleAgent)this.myImportObject.getParent()).isDataFlowEnabled())) {
                        ableAgent.setDataFlowEnabled(true);
                    }
                    this.myImportObject.dataChanged(this.myImportObject.getOutputBuffer());
                    bl = this.myImportObject.isDataFlowEnabled();
                    if (!bl) {
                        this.myImportObject.setDataFlowEnabled(true);
                    }
                    this.myImportObject.setDataFlowEnabled(false);
                    ableAgent.setInputBuffer(this.myImportObject.getOutputBuffer());
                    ableAgent.process();
                }
                catch (ParseException parseException) {
                    System.out.println("Error: " + parseException.toString());
                    JOptionPane.showMessageDialog(this, "Number format error parsing " + parseException.getLocalizedMessage(), "AbleDataSetPanel Error: ProcessButton()", 0);
                    Object var11_14 = null;
                    if (bl) {
                        this.myImportObject.setDataFlowEnabled(true);
                    }
                    if (bl2) return;
                    ableAgent.setDataFlowEnabled(false);
                    return;
                }
                catch (Exception exception) {
                    System.out.println("Error: " + exception.toString());
                    JOptionPane.showMessageDialog(this, "An error occurred while processing the record.\n" + exception.getLocalizedMessage(), "AbleDataSetPanel Error: ProcessButton()", 0);
                    Object var11_15 = null;
                    if (bl) {
                        this.myImportObject.setDataFlowEnabled(true);
                    }
                    if (bl2) return;
                    ableAgent.setDataFlowEnabled(false);
                    return;
                }
                Object var11_13 = null;
                if (!bl) break block15;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                if (bl) {
                    this.myImportObject.setDataFlowEnabled(true);
                }
                if (bl2) throw throwable;
                ableAgent.setDataFlowEnabled(false);
                throw throwable;
            }
            this.myImportObject.setDataFlowEnabled(true);
        }
        if (bl2) return;
        ableAgent.setDataFlowEnabled(false);
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.getDataFromBean(this.myImportObject);
        }
        catch (AbleException ableException) {
            JOptionPane.showMessageDialog(this.myCustomizer, "Panel values changed, but were not updated.\n" + ableException.toString(), "AbleDataSetPanel Warning: refreshPanel()", 2);
        }
    }

    public void handleAbleEvent(AbleEvent ableEvent) throws AbleException {
        Object object = ableEvent.getArgObject();
        if (this.data.length != 0) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                if (this.data.length > 0 && objectArray.length == this.data[0].length) {
                    this.updateTable();
                } else {
                    this.getDataFromBean(this.myImportObject);
                }
            } else {
                this.getDataFromBean(this.myImportObject);
            }
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/doc-files/AbleDataSetHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

