/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.AbleDBImport;
import com.ibm.able.beans.filter.AbleFilter;
import com.ibm.able.editor.AbleEditor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AbleDBImportPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleDBImport myImportObject = null;
    private AbleObjectCustomizer myCustomizer = null;
    private JComboBox myDriverComboBox = null;
    private JComboBox myProtocolComboBox = null;
    private JComboBox mySubprotocolComboBox = null;
    private JComboBox myDatabaseComboBox = null;
    private JTextField myOptionsTextField = null;
    private JTextField myUseridTextField = null;
    private JPasswordField myPasswordField = null;
    private JTextField mySchemaTextField = null;
    private JTextField myTableTextField = null;
    private JTextField mySelectionColumnsTextField = null;
    private JTextField mySelectionWhereTextField = null;
    private JComboBox myBufferSizeComboBox = null;
    private JTextField myCycleSizeTextField = null;
    private JCheckBox myCycleModeCheckBox = null;
    private JCheckBox myRandomizeCheckBox = null;
    private JCheckBox myComputeStatisticsCheckBox = null;
    private JButton myOpenButton = null;
    private JButton myGenerateButton = null;
    private TextListener myTextListener = null;

    private AbleDBImportPanel() {
    }

    public AbleDBImportPanel(AbleObjectCustomizer ableObjectCustomizer) {
        this.myCustomizer = ableObjectCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        this.myImportObject = (AbleDBImport)object;
        this.setupComboBox(this.myDriverComboBox, this.getDrivers(), this.myImportObject.getDriver());
        this.setupComboBox(this.myProtocolComboBox, AbleEditor.Preferences.getDatabaseProtocols(), this.myImportObject.getProtocol());
        this.setupComboBox(this.mySubprotocolComboBox, AbleEditor.Preferences.getDatabaseSubprotocols(), this.myImportObject.getSubprotocol());
        this.setupComboBox(this.myDatabaseComboBox, AbleEditor.Preferences.getDatabaseDatabases(), this.myImportObject.getDatabase());
        this.myOptionsTextField.setText(this.myImportObject.getConnectionOptions());
        this.myUseridTextField.setText(this.myImportObject.getUserid());
        this.mySchemaTextField.setText(this.myImportObject.getSchema());
        this.myTableTextField.setText(this.myImportObject.getTable());
        this.mySelectionColumnsTextField.setText(this.myImportObject.getSelectionColumns());
        this.mySelectionWhereTextField.setText(this.myImportObject.getSelectionWhere());
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("All");
        int n = this.myImportObject.getBufferSize();
        if (n == 0) {
            this.setupComboBox(this.myBufferSizeComboBox, treeSet, "All");
        } else {
            this.setupComboBox(this.myBufferSizeComboBox, treeSet, new Integer(n).toString());
        }
        this.myCycleSizeTextField.setText(this.myImportObject.getCycleSizeAsString());
        this.myCycleModeCheckBox.setSelected(this.myImportObject.isCycleRelative());
        this.myRandomizeCheckBox.setSelected(this.myImportObject.isRandomizeData());
        this.myComputeStatisticsCheckBox.setSelected(this.myImportObject.getComputeStatistics() || 0 == this.myImportObject.getFieldList().size());
        this.setButtonStates();
    }

    private TreeSet getDrivers() {
        TreeSet treeSet = AbleEditor.Preferences.getDatabaseDrivers();
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            Driver driver = enumeration.nextElement();
            treeSet.add(driver.getClass().getName());
        }
        return treeSet;
    }

    private void setupComboBox(JComboBox jComboBox, TreeSet treeSet, String string) {
        String string2 = string;
        if (string == null) {
            string2 = "";
        }
        treeSet.add(string2);
        jComboBox.setModel(new DefaultComboBoxModel<Object>(treeSet.toArray()));
        jComboBox.setSelectedItem(string2);
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myImportObject.setDriver(((String)this.myDriverComboBox.getSelectedItem()).trim());
            AbleEditor.Preferences.setDatabaseDrivers(this.getComboBoxContents(this.myDriverComboBox));
            this.myImportObject.setProtocol(((String)this.myProtocolComboBox.getSelectedItem()).trim());
            AbleEditor.Preferences.setDatabaseProtocols(this.getComboBoxContents(this.myProtocolComboBox));
            this.myImportObject.setSubprotocol(((String)this.mySubprotocolComboBox.getSelectedItem()).trim());
            AbleEditor.Preferences.setDatabaseSubprotocols(this.getComboBoxContents(this.mySubprotocolComboBox));
            this.myImportObject.setDatabase(((String)this.myDatabaseComboBox.getSelectedItem()).trim());
            AbleEditor.Preferences.setDatabaseDatabases(this.getComboBoxContents(this.myDatabaseComboBox));
            this.myImportObject.setConnectionOptions(this.myOptionsTextField.getText().trim());
            this.myImportObject.setUserid(this.myUseridTextField.getText().trim());
            this.myImportObject.setPassword(new String(this.myPasswordField.getPassword()));
            this.myImportObject.setSchema(this.mySchemaTextField.getText().trim());
            this.myImportObject.setTable(this.myTableTextField.getText().trim());
            this.myImportObject.setSelectionColumns(this.mySelectionColumnsTextField.getText().trim());
            this.myImportObject.setSelectionWhere(this.mySelectionWhereTextField.getText().trim());
            String string = ((String)this.myBufferSizeComboBox.getSelectedItem()).trim();
            if (string.equalsIgnoreCase("ALL")) {
                this.myImportObject.setBufferSize(0);
            } else {
                this.myImportObject.setBufferSize(Integer.parseInt(string));
            }
            this.myImportObject.setRandomizeData(this.myRandomizeCheckBox.isSelected());
            String string2 = this.myCycleSizeTextField.getText().trim();
            this.myImportObject.setCycleSize(Double.parseDouble(string2), this.myCycleModeCheckBox.isSelected());
            this.myImportObject.setComputeStatistics(this.myComputeStatisticsCheckBox.isSelected());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Import panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input or invalid definition file provided on Import panel.\n" + nullPointerException.toString());
        }
    }

    private TreeSet getComboBoxContents(JComboBox jComboBox) {
        TreeSet<String> treeSet = new TreeSet<String>();
        ComboBoxModel comboBoxModel = jComboBox.getModel();
        treeSet.add(((String)jComboBox.getSelectedItem()).trim());
        int n = comboBoxModel.getSize();
        String string = null;
        for (int i = 0; i < n; ++i) {
            string = ((String)comboBoxModel.getElementAt(i)).trim();
            if (string.length() <= 0) continue;
            treeSet.add(string);
        }
        return treeSet;
    }

    private void initializePanel() {
        int n = 20;
        int n2 = 30;
        AblePanelHelper.addLabel(this, 20, n, 150, "Driver name:");
        this.myDriverComboBox = AblePanelHelper.addComboBox(this, 170, n, 230);
        this.myDriverComboBox.setToolTipText("Provide the path and name of the driver to load");
        this.myDriverComboBox.setEditable(true);
        this.myDriverComboBox.setModel(new DefaultComboBoxModel(new Vector(AbleEditor.Preferences.getDatabaseDrivers())));
        AblePanelHelper.addLabel(this, 20, n += n2, 90, "Protocol:");
        this.myProtocolComboBox = AblePanelHelper.addComboBox(this, 110, n, 150);
        this.myProtocolComboBox.setToolTipText("Protocol");
        this.myProtocolComboBox.setEditable(true);
        AblePanelHelper.addLabel(this, 270, n, 90, "Subprotocol:");
        this.mySubprotocolComboBox = AblePanelHelper.addComboBox(this, 360, n, 150);
        this.mySubprotocolComboBox.setToolTipText("Subprotocol");
        this.mySubprotocolComboBox.setEditable(true);
        AblePanelHelper.addLabel(this, 20, n += n2, 90, "Database:");
        this.myDatabaseComboBox = AblePanelHelper.addComboBox(this, 110, n, 150);
        this.myDatabaseComboBox.setEditable(true);
        this.myDatabaseComboBox.setToolTipText("Database");
        AblePanelHelper.addLabel(this, 270, n, 90, "Options:");
        this.myOptionsTextField = AblePanelHelper.addTextField(this, 360, n, 150);
        this.myOptionsTextField.setToolTipText("Connection options; omit separator ';'");
        AblePanelHelper.addLabel(this, 20, n += n2, 90, "Userid:");
        this.myUseridTextField = AblePanelHelper.addTextField(this, 110, n, 150);
        this.myUseridTextField.setToolTipText("Userid");
        AblePanelHelper.addLabel(this, 270, n, 90, "Password:");
        this.myPasswordField = AblePanelHelper.addPasswordField(this, 360, n, 150);
        this.myPasswordField.setToolTipText("Password");
        AblePanelHelper.addLabel(this, 20, n += n2, 90, "Schema:");
        this.mySchemaTextField = AblePanelHelper.addTextField(this, 110, n, 150);
        this.mySchemaTextField.setToolTipText("Schema");
        AblePanelHelper.addLabel(this, 270, n, 90, "Table:");
        this.myTableTextField = AblePanelHelper.addTextField(this, 360, n, 150);
        this.myTableTextField.setToolTipText("Table");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Column selection:");
        this.mySelectionColumnsTextField = AblePanelHelper.addTextField(this, 170, n, 230);
        this.mySelectionColumnsTextField.setToolTipText("Column names separated by comma ','");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Row selection:");
        this.mySelectionWhereTextField = AblePanelHelper.addTextField(this, 170, n, 230);
        this.mySelectionWhereTextField.setToolTipText("SQL statements following 'where'");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Record cache count:");
        this.myBufferSizeComboBox = AblePanelHelper.addComboBox(this, 170, n, 100);
        this.myBufferSizeComboBox.setToolTipText("Number of data records to keep in memory");
        this.myBufferSizeComboBox.setEditable(true);
        this.myRandomizeCheckBox = AblePanelHelper.addCheckBox(this, 290, n, 200, "Randomize data");
        this.myRandomizeCheckBox.setToolTipText("Randomize the order of data records");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Steps per cycle:");
        this.myCycleSizeTextField = AblePanelHelper.addTextField(this, 170, n, 100);
        this.myCycleSizeTextField.setToolTipText("Number of data records to process in a cycle");
        this.myCycleModeCheckBox = AblePanelHelper.addCheckBox(this, 290, n, 200, "Relative to table size");
        this.myCycleModeCheckBox.setToolTipText("Multiply by table size or absolute");
        this.myComputeStatisticsCheckBox = AblePanelHelper.addCheckBox(this, 90, n += n2, 200, "Compute field statistics");
        this.myComputeStatisticsCheckBox.setToolTipText("Scan each field for min/max/mean or members");
        this.myOpenButton = AblePanelHelper.addButton(this, 70, n += n2, 180, "Open Table", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDBImportPanel.this.OpenButton_actionPerformed(actionEvent);
            }
        }, "Open the definition and data files for this import bean");
        this.myGenerateButton = AblePanelHelper.addButton(this, 280, n, 180, "Generate Filters", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDBImportPanel.this.GenerateButton_actionPerformed(actionEvent);
            }
        }, "Generate filter templates to use with this Import bean");
    }

    private void setButtonStates() {
    }

    private void SavePasswordButton_actionPerformed(ActionEvent actionEvent) {
        String string = this.myPasswordField.getPassword().toString().trim();
    }

    private void BrowseSchemaButton_actionPerformed(ActionEvent actionEvent) {
    }

    private void BrowseTableButton_actionPerformed(ActionEvent actionEvent) {
    }

    private void GenerateButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.myImportObject.isReady()) {
                this.setDataOnBean();
                this.myImportObject.init();
            }
            AbleFilter ableFilter = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_InputFilter"));
            AbleFilter ableFilter2 = new AbleFilter(Able.NlsMsg((String)"DFLT_NAME_OutputFilter"));
            AbleFilter.generateTranslateTemplates((AbleFilter)ableFilter, (AbleFilter)ableFilter2, (Vector)this.myImportObject.getFieldList());
            this.myImportObject.getParent().addBean((AbleBean)ableFilter);
            new AbleBufferConnection((AbleBean)this.myImportObject, (AbleBean)ableFilter);
            this.myImportObject.getParent().addBean((AbleBean)ableFilter2);
            this.getDataFromBean(this.myImportObject);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occurred while generating the filter template\n" + exception.toString(), "AbleDBImportPanel Error: generateButton()", 2);
        }
    }

    private void OpenButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myCustomizer.updateProperties();
            this.myImportObject.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myImportObject);
            if (!this.myImportObject.isReady()) {
                JOptionPane.showMessageDialog(this, "An error occurred while opening the file\n", "AbleDBImportPanel Error: openButton()", 2);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occurred while opening the definition file\n" + exception.toString(), "AbleDBImportPanel Error: openButton()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/doc-files/AbleDBImportHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class TextListener
    implements DocumentListener {
        TextListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AbleDBImportPanel.this.setButtonStates();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbleDBImportPanel.this.setButtonStates();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbleDBImportPanel.this.setButtonStates();
        }
    }
}

