/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.AbleDBExport;
import com.ibm.able.editor.AbleEditor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AbleDBExportPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleDBExport myExportObject = null;
    private AbleObjectCustomizer myCustomizer = null;
    private JComboBox myDriverComboBox = null;
    private JComboBox myProtocolComboBox = null;
    private JComboBox mySubprotocolComboBox = null;
    private JComboBox myDatabaseComboBox = null;
    private JTextField myOptionsTextField = null;
    private JTextField myUseridTextField = null;
    private JPasswordField myPasswordField = null;
    private JTextField mySchemaTextField = null;
    private JTextField myTableTextField = null;
    private JCheckBox myCreateableCheckBox = null;
    private JTextField myDeleteWhereTextField = null;
    private JButton myOpenButton = null;
    private JButton myDeleteButton = null;
    private JButton myDropButton = null;
    private TextListener myTextListener = null;

    private AbleDBExportPanel() {
    }

    public AbleDBExportPanel(AbleObjectCustomizer ableObjectCustomizer) {
        this.myCustomizer = ableObjectCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        this.myExportObject = (AbleDBExport)object;
        this.setupComboBox(this.myDriverComboBox, this.getDrivers(), this.myExportObject.getDriver());
        this.setupComboBox(this.myProtocolComboBox, AbleEditor.Preferences.getDatabaseProtocols(), this.myExportObject.getProtocol());
        this.setupComboBox(this.mySubprotocolComboBox, AbleEditor.Preferences.getDatabaseSubprotocols(), this.myExportObject.getSubprotocol());
        this.setupComboBox(this.myDatabaseComboBox, AbleEditor.Preferences.getDatabaseDatabases(), this.myExportObject.getDatabase());
        this.myOptionsTextField.setText(this.myExportObject.getConnectionOptions());
        this.myUseridTextField.setText(this.myExportObject.getUserid());
        this.mySchemaTextField.setText(this.myExportObject.getSchema());
        this.myTableTextField.setText(this.myExportObject.getTable());
        this.myCreateableCheckBox.setSelected(this.myExportObject.isCreatable());
        this.setButtonStates();
    }

    private TreeSet getDrivers() {
        TreeSet treeSet = AbleEditor.Preferences.getDatabaseDrivers();
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            Driver driver = enumeration.nextElement();
            treeSet.add(driver.getClass().getName());
        }
        return treeSet;
    }

    private void setupComboBox(JComboBox jComboBox, TreeSet treeSet, String string) {
        String string2 = string;
        if (string == null) {
            string2 = "";
        }
        treeSet.add(string2);
        jComboBox.setModel(new DefaultComboBoxModel<Object>(treeSet.toArray()));
        jComboBox.setSelectedItem(string2);
    }

    public void setDataOnBean() throws RemoteException {
        this.myExportObject.setDriver(((String)this.myDriverComboBox.getSelectedItem()).trim());
        AbleEditor.Preferences.setDatabaseDrivers(this.getComboBoxContents(this.myDriverComboBox));
        this.myExportObject.setProtocol(((String)this.myProtocolComboBox.getSelectedItem()).trim());
        AbleEditor.Preferences.setDatabaseProtocols(this.getComboBoxContents(this.myProtocolComboBox));
        this.myExportObject.setSubprotocol(((String)this.mySubprotocolComboBox.getSelectedItem()).trim());
        AbleEditor.Preferences.setDatabaseSubprotocols(this.getComboBoxContents(this.mySubprotocolComboBox));
        this.myExportObject.setDatabase(((String)this.myDatabaseComboBox.getSelectedItem()).trim());
        AbleEditor.Preferences.setDatabaseDatabases(this.getComboBoxContents(this.myDatabaseComboBox));
        this.myExportObject.setConnectionOptions(this.myOptionsTextField.getText().trim());
        this.myExportObject.setUserid(this.myUseridTextField.getText().trim());
        this.myExportObject.setPassword(new String(this.myPasswordField.getPassword()));
        this.myExportObject.setSchema(this.mySchemaTextField.getText().trim());
        this.myExportObject.setTable(this.myTableTextField.getText().trim());
        this.myExportObject.setCreatable(this.myCreateableCheckBox.isSelected());
    }

    private TreeSet getComboBoxContents(JComboBox jComboBox) {
        TreeSet<String> treeSet = new TreeSet<String>();
        ComboBoxModel comboBoxModel = jComboBox.getModel();
        treeSet.add(((String)jComboBox.getSelectedItem()).trim());
        int n = comboBoxModel.getSize();
        String string = null;
        for (int i = 0; i < n; ++i) {
            string = ((String)comboBoxModel.getElementAt(i)).trim();
            if (string.length() <= 0) continue;
            treeSet.add(string);
        }
        return treeSet;
    }

    private void initializePanel() {
        int n = 15;
        int n2 = 40;
        AblePanelHelper.addLabel(this, 20, n, 150, "Driver name:");
        this.myDriverComboBox = AblePanelHelper.addComboBox(this, 170, n, 230);
        this.myDriverComboBox.setToolTipText("Provide the path and name of the driver to load");
        this.myDriverComboBox.setEditable(true);
        this.myDriverComboBox.setModel(new DefaultComboBoxModel(new Vector(AbleEditor.Preferences.getDatabaseDrivers())));
        AblePanelHelper.addLabel(this, 20, n += n2, 90, "Protocol:");
        this.myProtocolComboBox = AblePanelHelper.addComboBox(this, 110, n, 150);
        this.myProtocolComboBox.setToolTipText("Protocol");
        this.myProtocolComboBox.setEditable(true);
        AblePanelHelper.addLabel(this, 270, n, 90, "Subprotocol:");
        this.mySubprotocolComboBox = AblePanelHelper.addComboBox(this, 360, n, 150);
        this.mySubprotocolComboBox.setToolTipText("Subprotocol");
        this.mySubprotocolComboBox.setEditable(true);
        AblePanelHelper.addLabel(this, 20, n += n2, 90, "Database:");
        this.myDatabaseComboBox = AblePanelHelper.addComboBox(this, 110, n, 150);
        this.myDatabaseComboBox.setEditable(true);
        this.myDatabaseComboBox.setToolTipText("Database");
        AblePanelHelper.addLabel(this, 270, n, 90, "Options:");
        this.myOptionsTextField = AblePanelHelper.addTextField(this, 360, n, 150);
        this.myOptionsTextField.setToolTipText("Connection options; omit separator ';'");
        AblePanelHelper.addLabel(this, 20, n += n2, 90, "Userid:");
        this.myUseridTextField = AblePanelHelper.addTextField(this, 110, n, 150);
        this.myUseridTextField.setToolTipText("Userid");
        AblePanelHelper.addLabel(this, 270, n, 90, "Password:");
        this.myPasswordField = AblePanelHelper.addPasswordField(this, 360, n, 150);
        this.myPasswordField.setToolTipText("Password");
        AblePanelHelper.addLabel(this, 20, n += n2, 90, "Schema:");
        this.mySchemaTextField = AblePanelHelper.addTextField(this, 110, n, 150);
        this.mySchemaTextField.setToolTipText("Schema");
        AblePanelHelper.addLabel(this, 270, n, 90, "Table:");
        this.myTableTextField = AblePanelHelper.addTextField(this, 360, n, 150);
        this.myTableTextField.setToolTipText("Table");
        this.myCreateableCheckBox = AblePanelHelper.addCheckBox(this, 110, n += n2, 200, "Create from input if necessary");
        this.myCreateableCheckBox.setToolTipText("Create table if needed");
        this.myOpenButton = AblePanelHelper.addButton(this, 70, n += n2, 180, "Open Table", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDBExportPanel.this.OpenButton_actionPerformed(actionEvent);
            }
        }, "Connect to the database");
        this.myDropButton = AblePanelHelper.addButton(this, 280, n, 180, "Drop Table", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDBExportPanel.this.DropButton_actionPerformed(actionEvent);
            }
        }, "Drop the table from the database");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Row selection:");
        this.myDeleteWhereTextField = AblePanelHelper.addTextField(this, 170, n, 230);
        this.myDeleteWhereTextField.setToolTipText("SQL statements following 'where'");
        this.myDeleteButton = AblePanelHelper.addButton(this, 420, n, 80, "Delete", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleDBExportPanel.this.DeleteButton_actionPerformed(actionEvent);
            }
        }, "Delete all rows matching selection (blank for all)");
    }

    private void setButtonStates() {
    }

    private void SavePasswordButton_actionPerformed(ActionEvent actionEvent) {
        String string = this.myPasswordField.getPassword().toString().trim();
    }

    private void BrowseSchemaButton_actionPerformed(ActionEvent actionEvent) {
    }

    private void BrowseTableButton_actionPerformed(ActionEvent actionEvent) {
    }

    private void DropButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.myExportObject.isReady()) {
                this.setDataOnBean();
                this.myExportObject.init();
            }
            this.myExportObject.erase();
            JOptionPane.showMessageDialog(this, this.myExportObject.getSchemaTable() + " dropped from database.", "AbleDBExportPanel Error: dropButton()", 1);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occurred while dropping " + this.myExportObject.getSchemaTable() + "\n" + exception.toString(), "AbleDBExportPanel Error: dropButton()", 2);
        }
    }

    private void OpenButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myCustomizer.updateProperties();
            this.myExportObject.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myExportObject);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occurred while connecting to the database\n" + exception.toString(), "AbleDBExportPanel Error: openButton()", 2);
        }
    }

    private void DeleteButton_actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        try {
            if (!this.myExportObject.isReady()) {
                JOptionPane.showMessageDialog(this, "Connection does not exist;  table must be opened\n", "AbleDBExportPanel Error: deleteButton()", 2);
                return;
            }
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myCustomizer.updateProperties();
            n = this.myExportObject.delete(this.myDeleteWhereTextField.getText().trim());
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myExportObject);
            JOptionPane.showMessageDialog(this, n + "records deleted from table.", "AbleDBExportPanel Error: deleteButton()", 1);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occurred while deleting records\n" + exception.toString(), "AbleDBExportPanel Error: deleteButton()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/doc-files/AbleDBExportHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class TextListener
    implements DocumentListener {
        TextListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AbleDBExportPanel.this.setButtonStates();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbleDBExportPanel.this.setButtonStates();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbleDBExportPanel.this.setButtonStates();
        }
    }
}

