/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.AbleEvent;
import com.ibm.able.AbleEventListener;
import com.ibm.able.AbleException;
import com.ibm.able.beans.AbleSelfOrganizingMap;
import com.ibm.able.editor.AbleCustomInspectorView;
import com.ibm.able.editor.AbleInspectorContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AbleClusterDiagramView
extends JPanel
implements AbleCustomInspectorView,
AbleEventListener,
PropertyChangeListener,
Serializable {
    static final long serialVersionUID = 1999100100000000001L;
    public static final int CIRCLES = 0;
    public static final int SQUARES = 1;
    public static final int USE_MEAN = 0;
    public static final int USE_THRESHOLD = 1;
    public static final int USE_COLORMAP = 2;
    static final int maxCharHeight = 15;
    static final int minFontSize = 6;
    static final Color bg = Color.white;
    static final Color fg = Color.black;
    static final Color red = Color.red;
    static final Color white = Color.white;
    static final Color blue = Color.blue;
    static final BasicStroke stroke = new BasicStroke(1.5f);
    static final BasicStroke wideStroke = new BasicStroke(8.0f);
    static final float[] dash1 = new float[]{10.0f};
    static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    Dimension totalSize;
    FontMetrics fontMetrics;
    double[] activations;
    int numRows;
    int numCols;
    int numInputs;
    int numOutputs;
    int winner;
    double maxActivation;
    double meanActivation;
    int colorMode = 0;
    Hashtable colorMap = new Hashtable();
    Hashtable colorLookup = new Hashtable();
    String[] clusterCategories;
    protected double userThreshold = 0.1;
    protected boolean showGrid = true;
    protected boolean showLabels = true;
    protected boolean showClusterIDs = true;
    protected boolean invertActivations = false;
    protected int nodeShape = 0;
    int gridWidth;
    int gridHeight;
    int rectWidth;
    int rectHeight;
    int stringY;
    int columnOffset;
    int inset;
    int[] layerXPos;
    int[] layerYPos;
    AbleSelfOrganizingMap myNeuralNetwork;
    boolean okToPaint = false;
    boolean myRefreshAllowed = true;
    int myCurrentStepCount = 0;
    int myStepsPerRefresh = 1;
    ContextData myContext = null;

    public AbleClusterDiagramView(Object object) {
        this.enableEvents(64L);
        this.setBackground(bg);
        this.setForeground(fg);
        this.initColorLookup();
        try {
            this.myNeuralNetwork = (AbleSelfOrganizingMap)object;
            this.myNeuralNetwork.addAbleEventListener((AbleEventListener)this);
            this.myNeuralNetwork.addPropertyChangeListener((PropertyChangeListener)this);
            this.initNetArchParameters();
            this.refreshView();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void initializeTestNetArchParameters() {
        this.numInputs = 3;
        this.numRows = 4;
        this.numCols = 4;
        this.numOutputs = this.numRows * this.numCols;
        this.winner = 5;
        this.activations = new double[this.numInputs + this.numRows * this.numCols];
        for (int i = 0; i < this.activations.length; ++i) {
            this.activations[i] = 1.0 - Math.random();
        }
        this.maxActivation = this.activations[this.numInputs];
        this.meanActivation = 0.0;
        double d = 0.0;
        for (int i = this.numInputs; i < this.activations.length; ++i) {
            if (this.activations[i] > this.maxActivation) {
                this.maxActivation = this.activations[i];
            }
            d += this.activations[i];
        }
        this.meanActivation = d / (double)this.numOutputs;
        this.okToPaint = true;
    }

    protected void initNetArchParameters() {
        this.okToPaint = this.myNeuralNetwork.getState() != 1026;
        this.numInputs = this.myNeuralNetwork.getNumInputs();
        this.numRows = this.myNeuralNetwork.getNumRows();
        this.numCols = this.myNeuralNetwork.getNumCols();
        this.numOutputs = this.myNeuralNetwork.getNumOutputs();
        this.activations = this.myNeuralNetwork.getActivations();
        this.clusterCategories = this.myNeuralNetwork.getClusterCategories();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("netArchitecture")) {
            this.okToPaint = false;
            this.initNetArchParameters();
            this.refreshView();
        }
    }

    public void handleAbleEvent(AbleEvent ableEvent) {
        ++this.myCurrentStepCount;
        if (this.myCurrentStepCount >= this.myStepsPerRefresh) {
            this.myCurrentStepCount = 0;
            if (this.myRefreshAllowed) {
                this.refreshView();
            }
        }
    }

    public void init() {
    }

    FontMetrics pickFont(Graphics2D graphics2D, String string, int n) {
        boolean bl = false;
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = font.getSize();
        String string2 = font.getName();
        int n3 = font.getStyle();
        while (!bl) {
            if (fontMetrics.getHeight() <= 15 && fontMetrics.stringWidth(string) <= n) {
                bl = true;
                continue;
            }
            if (n2 <= 6) {
                bl = true;
                continue;
            }
            font = new Font(string2, n3, --n2);
            graphics2D.setFont(font);
            fontMetrics = graphics2D.getFontMetrics();
        }
        return fontMetrics;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dimension = this.getSize();
        if (!this.okToPaint) {
            return;
        }
        int n2 = this.numRows * this.numCols;
        this.gridWidth = dimension.width / (this.numCols + 1);
        this.gridHeight = dimension.height / (this.numRows + 1);
        if (this.gridWidth > this.gridHeight) {
            this.gridWidth = this.gridHeight;
        } else if (this.gridWidth < this.gridHeight) {
            this.gridHeight = this.gridWidth;
        }
        this.fontMetrics = this.pickFont(graphics2D, "8888", this.gridWidth);
        graphics2D.setPaint(fg);
        this.inset = 10;
        this.rectWidth = this.gridWidth - this.inset;
        this.stringY = this.fontMetrics.getDescent();
        this.rectHeight = this.gridHeight - this.inset;
        int n3 = dimension.width - this.numCols * this.gridWidth;
        this.columnOffset = this.gridWidth + (n3 /= this.numCols);
        int n4 = n3 / 2;
        int n5 = 7;
        this.maxActivation = this.activations[this.numInputs];
        this.meanActivation = 0.0;
        double d = 0.0;
        for (n = this.numInputs; n < this.activations.length; ++n) {
            if (this.activations[n] > this.maxActivation) {
                this.maxActivation = this.activations[n];
            }
            d += this.activations[n];
        }
        this.meanActivation = d / (double)this.numOutputs;
        this.winner = this.myNeuralNetwork.getWinner();
        this.layerYPos = new int[this.numCols];
        for (n = 0; n < this.numCols; ++n) {
            this.layerYPos[n] = n5 + (dimension.height - this.numRows * this.gridHeight) / 2 + 1;
        }
        this.layerXPos = new int[this.numCols];
        this.layerXPos[0] = n4;
        for (n = 1; n < this.numCols; ++n) {
            this.layerXPos[n] = this.layerXPos[n - 1] + this.gridWidth + 1;
        }
        for (n = 0; n < this.numCols; ++n) {
            this.drawColumnOfUnits(graphics2D, n, n);
        }
    }

    protected void drawColumnOfUnits(Graphics2D graphics2D, int n, int n2) {
        int n3 = this.layerXPos[n];
        int n4 = this.layerYPos[n];
        int n5 = n2;
        for (int i = 0; i < this.numRows; ++i) {
            double d = this.activations[this.numInputs + n5];
            double d2 = 1.0;
            if (this.maxActivation > 0.0) {
                d2 = d / this.maxActivation;
            }
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            if (this.invertActivations) {
                d2 = 1.0 - d2;
            }
            double d3 = d2 * (double)this.rectWidth;
            double d4 = d2 * (double)this.rectHeight;
            double d5 = (double)(n3 + this.gridWidth / 2) - d3 / 2.0;
            double d6 = (double)(n4 + this.gridHeight / 2) - d4 / 2.0;
            if (n5 == this.winner) {
                graphics2D.setStroke(stroke);
                graphics2D.draw(new Rectangle2D.Double(n3, n4, this.gridWidth, this.gridHeight));
                if (this.nodeShape == 0) {
                    graphics2D.draw(new Ellipse2D.Double(d5, d6, d3, d4));
                } else {
                    graphics2D.draw(new Rectangle2D.Double(d5, d6, d3, d4));
                }
            } else {
                this.setColor(d, graphics2D, n5);
                if (this.showGrid) {
                    graphics2D.draw(new Rectangle2D.Double(n3, n4, this.gridWidth, this.gridHeight));
                }
                if (this.nodeShape == 0) {
                    graphics2D.fill(new Ellipse2D.Double(d5, d6, d3, d4));
                } else {
                    graphics2D.draw(new Rectangle2D.Double(d5, d6, d3, d4));
                }
            }
            graphics2D.setPaint(fg);
            if (this.showClusterIDs) {
                graphics2D.drawString(String.valueOf(n5), n3 + 1, n4 + this.gridHeight - this.stringY);
            }
            if (this.showLabels) {
                graphics2D.drawString(this.myNeuralNetwork.getClusterLabel(n5), n3 + 1, n4 + this.stringY + this.stringY + 2);
            }
            n4 += this.gridHeight;
            n5 += this.numCols;
        }
    }

    private void setColor(double d, Graphics2D graphics2D, int n) {
        switch (this.colorMode) {
            case 0: {
                if (d <= this.meanActivation) {
                    graphics2D.setPaint(red);
                    break;
                }
                graphics2D.setPaint(blue);
                break;
            }
            case 1: {
                if (d <= this.userThreshold) {
                    graphics2D.setPaint(red);
                    break;
                }
                graphics2D.setPaint(blue);
                break;
            }
            case 2: {
                String string = "black";
                String string2 = this.clusterCategories[n];
                Object v = this.colorMap.get(string2);
                if (v instanceof String) {
                    string = (String)v;
                }
                Color color = (Color)this.colorLookup.get(string);
                graphics2D.setPaint(color);
            }
        }
    }

    protected void refreshView() {
        this.invalidate();
        this.repaint();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("NeuralNetGraphicDemo");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        AbleSelfOrganizingMap ableSelfOrganizingMap = null;
        try {
            ableSelfOrganizingMap = new AbleSelfOrganizingMap();
            ableSelfOrganizingMap.setNetArchitecture("3 4 4");
        }
        catch (AbleException ableException) {
            // empty catch block
        }
        AbleClusterDiagramView ableClusterDiagramView = new AbleClusterDiagramView(ableSelfOrganizingMap);
        jFrame.getContentPane().add("Center", ableClusterDiagramView);
        ableClusterDiagramView.init();
        jFrame.pack();
        jFrame.setSize(new Dimension(400, 400));
        jFrame.setVisible(true);
    }

    private void initColorLookup() {
        this.colorLookup.put("red", Color.red);
        this.colorLookup.put("blue", Color.blue);
        this.colorLookup.put("black", Color.black);
        this.colorLookup.put("yellow", Color.yellow);
        this.colorLookup.put("green", Color.green);
        this.colorLookup.put("gray", Color.gray);
        this.colorLookup.put("darkGray", Color.darkGray);
        this.colorLookup.put("lightGray", Color.lightGray);
        this.colorLookup.put("cyan", Color.cyan);
        this.colorLookup.put("magenta", Color.magenta);
        this.colorLookup.put("pink", Color.pink);
        this.colorLookup.put("orange", Color.orange);
    }

    public double getUserThreshold() {
        return this.userThreshold;
    }

    public void setUserThreshold(double d) {
        this.userThreshold = d;
    }

    public void setNodeShape(int n) {
        this.nodeShape = n;
    }

    public int getNodeShape() {
        return this.nodeShape;
    }

    public void setShowGrid(boolean bl) {
        this.showGrid = bl;
    }

    public boolean getShowGrid() {
        return this.showGrid;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
    }

    public boolean getShowLabels() {
        return this.showLabels;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowClusterIDs(boolean bl) {
        this.showClusterIDs = bl;
    }

    public boolean getShowClusterIDs() {
        return this.showClusterIDs;
    }

    public boolean isShowClusterIDs() {
        return this.showClusterIDs;
    }

    public void setInvertActivations(boolean bl) {
        this.invertActivations = bl;
    }

    public boolean getInvertActivations() {
        return this.invertActivations;
    }

    public boolean isInvertActivations() {
        return this.invertActivations;
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(int n) {
        this.colorMode = n;
    }

    public Hashtable getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(Hashtable hashtable) {
        this.colorMap = hashtable;
    }

    public Vector getClusterCategoryValues() {
        return this.myNeuralNetwork.getClusterCategoryValues();
    }

    public Object getContext() {
        ContextData contextData = new ContextData();
        contextData.userThreshold = this.userThreshold;
        contextData.nodeShape = this.nodeShape;
        contextData.colorMode = this.colorMode;
        contextData.clusterCategoryValues = this.getClusterCategoryValues();
        contextData.categoryToColorMap = this.colorMap;
        contextData.showGrid = this.showGrid;
        contextData.showLabels = this.showLabels;
        contextData.showClusterIDs = this.showClusterIDs;
        contextData.invert = this.invertActivations;
        return contextData;
    }

    public void setContext(AbleInspectorContext ableInspectorContext) {
        if (ableInspectorContext != null && this.myContext == null && ableInspectorContext.customViewData instanceof ContextData) {
            ContextData contextData;
            this.myContext = contextData = (ContextData)ableInspectorContext.customViewData;
            this.setUserThreshold(contextData.userThreshold);
            this.setNodeShape(contextData.nodeShape);
            this.setColorMode(contextData.colorMode);
            this.setColorMap(contextData.categoryToColorMap);
            this.setShowGrid(contextData.showGrid);
            this.setShowLabels(contextData.showLabels);
            this.setShowClusterIDs(contextData.showClusterIDs);
            this.setInvertActivations(contextData.invert);
        }
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class ContextData
    implements Serializable {
        double userThreshold;
        int nodeShape;
        int colorMode;
        Vector clusterCategoryValues;
        Hashtable categoryToColorMap;
        boolean showGrid;
        boolean showLabels;
        boolean showClusterIDs;
        boolean invert;

        ContextData() {
        }
    }
}

