/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.beans;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleException;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.beans.AbleBackPropagation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AbleBackPropagationPanel
extends JPanel
implements AbleCustomizerPanel {
    private static Vector Modes = new Vector();
    public static final Vector FeedbackTypes;
    private AbleBackPropagation myBeanObject = null;
    private String myArchitecture = null;
    private JTextField myArchInputTextField = null;
    private JTextField myArchHidden1TextField = null;
    private JTextField myArchHidden2TextField = null;
    private JTextField myArchHidden3TextField = null;
    private JTextField myArchOutputTextField = null;
    private JTextField myLearnRateTextField = null;
    private JTextField myMomentumTextField = null;
    private JTextField myToleranceTextField = null;
    private JTextField myDecayFactorTextField = null;
    private JComboBox myModeComboBox = null;
    private JComboBox myFeedbackComboBox = null;
    private JCheckBox myExplicitErrorCheckBox = null;
    private JCheckBox myEpochUpdateCheckBox = null;
    private JCheckBox myAdaptiveLearningCheckBox = null;
    private JCheckBox mySymmetricActivationCheckBox = null;

    public AbleBackPropagationPanel() {
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.myArchitecture = "0 0 0 0 0 0";
        this.initializePanel();
    }

    public void getDataFromBean(Object object) throws AbleException {
        int n = 0;
        this.myBeanObject = (AbleBackPropagation)object;
        String string = this.myBeanObject.getNetArchitecture();
        if (string != null) {
            this.myArchitecture = string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.myArchitecture);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n2) {
                case 0: {
                    this.myArchInputTextField.setText(string2);
                    break;
                }
                case 1: {
                    this.myArchHidden1TextField.setText(string2);
                    break;
                }
                case 2: {
                    this.myArchHidden2TextField.setText(string2);
                    break;
                }
                case 3: {
                    this.myArchHidden3TextField.setText(string2);
                    break;
                }
                case 4: {
                    this.myArchOutputTextField.setText(string2);
                    break;
                }
                case 5: {
                    n = Integer.parseInt(string2);
                }
            }
            ++n2;
        }
        this.myFeedbackComboBox.setSelectedIndex(n);
        this.myLearnRateTextField.setText(String.valueOf(this.myBeanObject.getLearnRate()));
        this.myMomentumTextField.setText(String.valueOf(this.myBeanObject.getMomentum()));
        this.myToleranceTextField.setText(String.valueOf(this.myBeanObject.getTolerance()));
        this.myDecayFactorTextField.setText(String.valueOf(this.myBeanObject.getDecayFactor()));
        n2 = this.myBeanObject.getNetMode();
        if (n2 > Modes.size() - 1 || n2 < 0) {
            n2 = 0;
        }
        this.myModeComboBox.setSelectedIndex(n2);
        this.myExplicitErrorCheckBox.setSelected(this.myBeanObject.isExplicitErrorMode());
        this.myEpochUpdateCheckBox.setSelected(this.myBeanObject.isEpochUpdate());
        this.myAdaptiveLearningCheckBox.setSelected(this.myBeanObject.isAdaptLearnRate());
        this.mySymmetricActivationCheckBox.setSelected(this.myBeanObject.isSymmetricActFunction());
    }

    public void setDataOnBean() throws AbleException {
        try {
            this.myBeanObject.setLearnRate(Double.valueOf(this.myLearnRateTextField.getText().trim()).doubleValue());
            this.myBeanObject.setMomentum(Double.valueOf(this.myMomentumTextField.getText().trim()).doubleValue());
            this.myBeanObject.setTolerance(Double.valueOf(this.myToleranceTextField.getText().trim()).doubleValue());
            this.myBeanObject.setDecayFactor(Double.valueOf(this.myDecayFactorTextField.getText().trim()).doubleValue());
            this.myBeanObject.setNetMode(this.myModeComboBox.getSelectedIndex());
            this.myBeanObject.setExplicitErrorMode(this.myExplicitErrorCheckBox.isSelected());
            this.myBeanObject.setEpochUpdate(this.myEpochUpdateCheckBox.isSelected());
            this.myBeanObject.setAdaptLearnRate(this.myAdaptiveLearningCheckBox.isSelected());
            this.myBeanObject.setSymmetricActFunction(this.mySymmetricActivationCheckBox.isSelected());
        }
        catch (NumberFormatException numberFormatException) {
            throw new AbleException("Non-numeric input provided on Back Propagation panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new AbleException("Blank input provided on Back Propagation panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = -25;
        int n2 = 30;
        int n3 = 70;
        int n4 = 60;
        n3 = 120;
        AblePanelHelper.addLabel(this, 120, n += n2, n4, "Inputs");
        AblePanelHelper.addLabel(this, n3 += n4, n, n4, "Hidden1");
        AblePanelHelper.addLabel(this, n3 += n4, n, n4, "Hidden2");
        AblePanelHelper.addLabel(this, n3 += n4, n, n4, "Hidden3");
        AblePanelHelper.addLabel(this, n3 += n4, n, n4, "Outputs");
        AblePanelHelper.addLabel(this, n3 += n4, n, 80, "Feedback");
        AblePanelHelper.addLabel(this, 20, n += 20, 100, "Architecture:");
        n3 = 120;
        this.myArchInputTextField = AblePanelHelper.addTextField(this, 120, n, n4 - 10);
        this.myArchInputTextField.setToolTipText("Number of inputs");
        this.myArchInputTextField.setToolTipText("Number of inputs");
        this.myArchHidden1TextField = AblePanelHelper.addTextField(this, n3 += n4, n, n4 - 10);
        this.myArchHidden1TextField.setToolTipText("Nodes in hidden layer 1");
        this.myArchHidden2TextField = AblePanelHelper.addTextField(this, n3 += n4, n, n4 - 10);
        this.myArchHidden2TextField.setToolTipText("Nodes in hidden layer 2");
        this.myArchHidden3TextField = AblePanelHelper.addTextField(this, n3 += n4, n, n4 - 10);
        this.myArchHidden3TextField.setToolTipText("Nodes in hidden layer 3");
        this.myArchOutputTextField = AblePanelHelper.addTextField(this, n3 += n4, n, n4 - 10);
        this.myArchOutputTextField.setToolTipText("Number of outputs");
        this.myFeedbackComboBox = AblePanelHelper.addComboBox(this, n3 += n4, n, 100);
        this.myFeedbackComboBox.setModel(new DefaultComboBoxModel(FeedbackTypes));
        this.myFeedbackComboBox.setToolTipText("Use recurrence - feedback weights to input layer");
        AblePanelHelper.addButton(this, 150, n += n2, 150, "Set Architecture", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleBackPropagationPanel.this.SetNetArchButton_actionPerformed(actionEvent);
            }
        }, "Set the network architecture");
        AblePanelHelper.addButton(this, 320, n, 150, "Reset Weights", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleBackPropagationPanel.this.ResetButton_actionPerformed(actionEvent);
            }
        }, "Reset all network weights");
        n = (int)((double)n + 0.5 * (double)n2);
        AblePanelHelper.addLabel(this, 20, n += n2, 100, "Learn Rate:");
        this.myLearnRateTextField = AblePanelHelper.addTextField(this, 120, n, 150);
        this.myLearnRateTextField.setToolTipText("Size of change when weights are updated");
        this.myAdaptiveLearningCheckBox = AblePanelHelper.addCheckBox(this, 320, n, 200, "Adaptive learn rate");
        this.myAdaptiveLearningCheckBox.setToolTipText("Reduce learn rate as error decreases");
        AblePanelHelper.addLabel(this, 20, n += n2, 100, "Momentum:");
        this.myMomentumTextField = AblePanelHelper.addTextField(this, 120, n, 150);
        this.myMomentumTextField.setToolTipText("Size of influence of previous weight adjustments");
        AblePanelHelper.addLabel(this, 20, n += n2, 100, "Tolerance:");
        this.myToleranceTextField = AblePanelHelper.addTextField(this, 120, n, 150);
        this.myToleranceTextField.setToolTipText("Size of acceptable error");
        AblePanelHelper.addLabel(this, 20, n += n2, 100, "Decay factor:");
        this.myDecayFactorTextField = AblePanelHelper.addTextField(this, 120, n, 150);
        this.myDecayFactorTextField.setToolTipText("Amount of influence of recurrent feedback");
        AblePanelHelper.addLabel(this, 20, n += n2, 100, "Mode:");
        this.myModeComboBox = AblePanelHelper.addComboBox(this, 120, n, 100);
        this.myModeComboBox.setModel(new DefaultComboBoxModel(Modes));
        this.myModeComboBox.setToolTipText("Learn by adjusting weights, calculate error, or calculate only results");
        this.myExplicitErrorCheckBox = AblePanelHelper.addCheckBox(this, 120, n += n2, 200, "Explicit error mode");
        this.myExplicitErrorCheckBox.setToolTipText("Indicates input buffer contains actual error value for control applications");
        this.myEpochUpdateCheckBox = AblePanelHelper.addCheckBox(this, 120, n += n2, 200, "Epoch (batch) updates");
        this.myEpochUpdateCheckBox.setToolTipText("Update weights after epoch or after each record");
        this.mySymmetricActivationCheckBox = AblePanelHelper.addCheckBox(this, 120, n += n2, 200, "Symmetric activation");
        this.mySymmetricActivationCheckBox.setToolTipText("Inputs from -0.5 to +0.5 or 0.0 to 1.0");
    }

    void SetNetArchButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myBeanObject.getWeights4() != null && 1 == JOptionPane.showConfirmDialog(this, "This will erase the existing network and  \n any training will be lost.\nAre you sure you want to do this?", "Change Network Architecture", 0)) {
                return;
            }
            String string = this.myArchInputTextField.getText().trim() + " " + this.myArchHidden1TextField.getText().trim() + " " + this.myArchHidden2TextField.getText().trim() + " " + this.myArchHidden3TextField.getText().trim() + " " + this.myArchOutputTextField.getText().trim() + " " + this.myFeedbackComboBox.getSelectedIndex();
            Integer.parseInt(this.myArchInputTextField.getText().trim());
            Integer.parseInt(this.myArchHidden1TextField.getText().trim());
            Integer.parseInt(this.myArchHidden2TextField.getText().trim());
            Integer.parseInt(this.myArchHidden3TextField.getText().trim());
            Integer.parseInt(this.myArchOutputTextField.getText().trim());
            this.myBeanObject.setNetArchitecture(string);
            this.myArchitecture = string;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleBackPropagationPanel Error: SetNetArchButton()", 0);
        }
    }

    void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myBeanObject.getWeights4() != null && 1 == JOptionPane.showConfirmDialog(this, "This will reset the existing weights and  \n any training will be lost.\nAre you sure you want to do this?", "Reset Network Weights", 0)) {
                return;
            }
            this.myBeanObject.reset();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleBackPropagationPanel Error: ResetButton()", 0);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "beans/doc-files/AbleBackPropagationHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    static {
        Modes.addElement("Train");
        Modes.addElement("Test");
        Modes.addElement("Run");
        FeedbackTypes = new Vector();
        FeedbackTypes.addElement("None");
        FeedbackTypes.addElement("Hidden layer");
        FeedbackTypes.addElement("Output layer");
    }
}

