/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.autotune.AutotuneMetric;
import com.ibm.able.autotune.AutotuneServiceLevelMetric;
import com.ibm.able.autotune.AutotuneTuningControlMetric;
import com.ibm.able.autotune.Neural2WayLoadBalanceController;
import com.ibm.able.autotune.Neural2WayLoadBalanceControllerCustomizer;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Neural2WayLoadBalanceControllerPanel
extends JPanel
implements AbleCustomizerPanel {
    private boolean myFrameSizeAdjusted = false;
    private Neural2WayLoadBalanceController myAgent = null;
    private Neural2WayLoadBalanceControllerCustomizer myCustomizer = null;
    private JTextField myModelDataSetTextField = null;
    private JTextField myControllerDataSetTextField = null;
    private JComboBox myServiceLevelAComboBox = null;
    private JComboBox myServiceLevelBComboBox = null;
    private JComboBox myTuningControlComboBox = null;
    private Vector myServiceLevelVector = null;
    private Vector myTuningControlVector = null;

    private Neural2WayLoadBalanceControllerPanel() {
    }

    public Neural2WayLoadBalanceControllerPanel(Neural2WayLoadBalanceControllerCustomizer neural2WayLoadBalanceControllerCustomizer) {
        this.myCustomizer = neural2WayLoadBalanceControllerCustomizer;
        this.setLayout(new GridBagLayout());
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) {
        AutotuneTuningControlMetric autotuneTuningControlMetric;
        String string;
        if (this.myAgent == null) {
            this.myAgent = (Neural2WayLoadBalanceController)object;
        }
        if ("mq1model.dfn".equals(string = this.myAgent.getModelDataSetFileName())) {
            string = this.myCustomizer.getWorkingDirectory() + File.separator + string;
        }
        this.myModelDataSetTextField.setText(string);
        string = this.myAgent.getControllerDataSetFileName();
        if ("mq1controller.dfn".equals(string)) {
            string = this.myCustomizer.getWorkingDirectory() + File.separator + string;
        }
        this.myModelDataSetTextField.setText(string);
        this.myServiceLevelVector = this.myAgent.getSelectedMetrics().getServiceLevelMetrics();
        this.myServiceLevelAComboBox.setModel(new DefaultComboBoxModel(this.getMetricNames(this.myServiceLevelVector)));
        this.myServiceLevelBComboBox.setModel(new DefaultComboBoxModel(this.getMetricNames(this.myServiceLevelVector)));
        this.myTuningControlVector = this.myAgent.getSelectedMetrics().getTuningControlMetrics();
        this.myTuningControlComboBox.setModel(new DefaultComboBoxModel(this.getMetricNames(this.myTuningControlVector)));
        AutotuneServiceLevelMetric autotuneServiceLevelMetric = this.myAgent.getServiceLevelMetricA();
        if (autotuneServiceLevelMetric != null) {
            this.myServiceLevelAComboBox.setSelectedItem(autotuneServiceLevelMetric.getName());
        }
        if ((autotuneServiceLevelMetric = this.myAgent.getServiceLevelMetricB()) != null) {
            this.myServiceLevelBComboBox.setSelectedItem(autotuneServiceLevelMetric.getName());
        }
        if ((autotuneTuningControlMetric = this.myAgent.getLoadBalanceTuningControlMetric()) != null) {
            this.myTuningControlComboBox.setSelectedItem(autotuneTuningControlMetric.getName());
        }
    }

    public void setDataOnBean() {
        this.myAgent.setModelDataSetFileName(this.myModelDataSetTextField.getText().trim());
        this.myAgent.setControllerDataSetFileName(this.myControllerDataSetTextField.getText().trim());
        if (this.myServiceLevelVector.size() > 0) {
            this.myAgent.setServiceLevelMetricA((AutotuneServiceLevelMetric)this.myServiceLevelVector.elementAt(this.myServiceLevelAComboBox.getSelectedIndex()));
            this.myAgent.setServiceLevelMetricB((AutotuneServiceLevelMetric)this.myServiceLevelVector.elementAt(this.myServiceLevelBComboBox.getSelectedIndex()));
        }
        if (this.myTuningControlVector.size() > 0) {
            this.myAgent.setLoadBalanceTuningControlMetric((AutotuneTuningControlMetric)this.myTuningControlVector.elementAt(this.myTuningControlComboBox.getSelectedIndex()));
        }
    }

    private Vector getMetricNames(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(((AutotuneMetric)vector.elementAt(i)).getName());
        }
        return vector2;
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.myFrameSizeAdjusted) {
            return;
        }
        this.myFrameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    private void initializePanel() {
        int n = 0;
        this.add((Component)new JLabel("Model Data Set:"), new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.myModelDataSetTextField = new JTextField();
        this.myModelDataSetTextField.setToolTipText("File containing model data");
        this.add((Component)this.myModelDataSetTextField, new AbleGridBagConstraints(1, n, 3, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        JButton jButton = new JButton("Browse...");
        jButton.setToolTipText("Select the model data file");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Neural2WayLoadBalanceControllerPanel.this.BrowseModelFileButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)jButton, new AbleGridBagConstraints(4, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)new JLabel("Controller Data Set:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.myControllerDataSetTextField = new JTextField();
        this.myControllerDataSetTextField.setToolTipText("File containing controller data");
        this.add((Component)this.myControllerDataSetTextField, new AbleGridBagConstraints(1, n, 3, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        jButton = new JButton("Browse...");
        jButton.setToolTipText("Select the controller data file");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Neural2WayLoadBalanceControllerPanel.this.BrowseControllerFileButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)jButton, new AbleGridBagConstraints(4, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)new JLabel("System1 Service Level"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)new JLabel("System2 Service Level"), new AbleGridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myServiceLevelAComboBox = new JComboBox();
        this.add((Component)this.myServiceLevelAComboBox, new AbleGridBagConstraints(0, ++n, 2, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 10, 10), 0, 0));
        this.myServiceLevelBComboBox = new JComboBox();
        this.add((Component)this.myServiceLevelBComboBox, new AbleGridBagConstraints(2, n, 2, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)new JLabel("Tuning Control"), new AbleGridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myTuningControlComboBox = new JComboBox();
        this.add((Component)this.myTuningControlComboBox, new AbleGridBagConstraints(0, ++n, 2, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 10, 10), 0, 0));
        JButton jButton2 = new JButton("Initialize");
        jButton2.setToolTipText("Initialize the neural controller and set the metrics");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Neural2WayLoadBalanceControllerPanel.this.InitializeRuleSetButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)jButton2, new AbleGridBagConstraints(1, ++n, 3, 1, 0.5, 0.0, 10, 2, new Insets(10, 10, 10, 10), 80, 0));
    }

    private void addPropertyListeners() {
    }

    private void BrowseModelFileButton_actionPerformed(ActionEvent actionEvent) {
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myModelDataSetTextField, "Model DataSet File (*.dfn)", "dfn", this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void BrowseControllerFileButton_actionPerformed(ActionEvent actionEvent) {
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myControllerDataSetTextField, "Model DataSet File (*.dfn)", "dfn", this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void InitializeRuleSetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setDataOnBean();
            this.myAgent.init();
            this.getDataFromBean(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "NeuralControllerPanel Error: InitializeRuleSet()", 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "autotune/doc-files/Neural2WayLoadBalanceControllerHelp.html";
    }

    public URL getHelpContext() {
        URL uRL = null;
        try {
            uRL = new URL("\\...\\autotune");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }
}

