/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleGui;
import com.ibm.able.AbleHelp;
import com.ibm.able.autotune.AutotuneMetric;
import com.ibm.able.autotune.AutotuneMetricCollection;
import com.ibm.able.autotune.AutotuneTuningControlMetric;
import com.ibm.able.autotune.BaseAutotuneAdaptor;
import com.ibm.able.autotune.BaseAutotuneAdaptorCustomizer;
import com.ibm.able.data.AbleDataException;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class BaseAutotuneAdaptorTuningPanel
extends JPanel
implements AbleCustomizerPanel {
    static final String COL_NAME = "Tuning parameter";
    static final int COL_NAME_ID = 0;
    static final int COL_NAME_WID = 75;
    static final String COL_VALUE = "Value";
    static final int COL_VALUE_ID = 1;
    static final int COL_VALUE_WID = 75;
    private static Vector myColumnNameVector = new Vector();
    private boolean myFrameSizeAdjusted = false;
    private BaseAutotuneAdaptor myAdaptor = null;
    private BaseAutotuneAdaptorCustomizer myCustomizer = null;
    private BaseAutotuneAdaptorTuningPanel myPanel = null;
    private JTable myMetricTable = null;
    private MetricTableModel myMetricTableModel = null;
    private Vector myDataVector = null;

    private BaseAutotuneAdaptorTuningPanel() {
    }

    public BaseAutotuneAdaptorTuningPanel(BaseAutotuneAdaptorCustomizer baseAutotuneAdaptorCustomizer) {
        this.myCustomizer = baseAutotuneAdaptorCustomizer;
        this.setLayout(new GridBagLayout());
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myAdaptor == null) {
            this.myAdaptor = (BaseAutotuneAdaptor)object;
        }
        this.myDataVector.removeAllElements();
        AutotuneMetricCollection autotuneMetricCollection = this.myAdaptor.getMetrics();
        this.addRows(AbleGui.NlsMsg("Autotune_TuningParameterMetricsLabel"), autotuneMetricCollection.getTuningControlMetrics());
    }

    private void addRows(String string, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Vector<String> vector2 = new Vector<String>(2);
            AutotuneTuningControlMetric autotuneTuningControlMetric = (AutotuneTuningControlMetric)vector.elementAt(i);
            vector2.addElement(autotuneTuningControlMetric.getName());
            try {
                vector2.addElement(autotuneTuningControlMetric.getStringValue());
            }
            catch (AbleDataException ableDataException) {
                System.out.println("Exception " + ableDataException.toString());
            }
            this.myDataVector.addElement(vector2);
        }
    }

    public void setDataOnBean() throws RemoteException {
        try {
            AutotuneMetricCollection autotuneMetricCollection = this.myAdaptor.getMetrics();
            boolean bl = false;
            int n = this.myDataVector.size();
            Vector vector = new Vector(2);
            for (int i = 0; i < n; ++i) {
                vector = (Vector)this.myDataVector.elementAt(i);
                String string = (String)vector.elementAt(0);
                double d = Double.valueOf((String)vector.elementAt(1));
                AutotuneMetric autotuneMetric = autotuneMetricCollection.getMetric(string);
                if (autotuneMetric == null || autotuneMetric.getNumericValue() == d) continue;
                autotuneMetric.setNumericValue(d);
                bl = true;
            }
            if (bl) {
                this.myAdaptor.dataChanged((Object)this.myAdaptor.getMetrics().getServiceLevelMetrics());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Base Autotune Adaptor Tuning panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Base Autotune Adaptor Tuning panel.\n" + nullPointerException.toString());
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.myFrameSizeAdjusted) {
            return;
        }
        this.myFrameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    private void initializePanel() {
        int n = 0;
        this.myDataVector = new Vector();
        this.myMetricTableModel = new MetricTableModel(this.myDataVector, myColumnNameVector);
        this.myMetricTable = new JTable(this.myMetricTableModel);
        this.myMetricTable.setSelectionMode(0);
        this.myMetricTable.setCellSelectionEnabled(true);
        this.setColumnFormat(0, 75);
        this.setColumnFormat(1, 75);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setAutoscrolls(true);
        jScrollPane.getViewport().add(this.myMetricTable);
        jScrollPane.setPreferredSize(new Dimension(262, 270));
        this.add(jScrollPane);
        this.add((Component)jScrollPane, new AbleGridBagConstraints(0, n, 3, 1, 0.5, 0.5, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        JButton jButton = new JButton("Refresh parameters");
        jButton.setToolTipText("Refresh the adaptor's tuning parameters");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseAutotuneAdaptorTuningPanel.this.RefreshButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)jButton, new AbleGridBagConstraints(0, ++n, 1, 1, 0.5, 0.0, 11, 2, new Insets(10, 20, 10, 20), 0, 0));
        JButton jButton2 = new JButton("Set parameters");
        jButton2.setToolTipText("Update the adaptor's tuning parameters with values shown");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BaseAutotuneAdaptorTuningPanel.this.SetButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)jButton2, new AbleGridBagConstraints(2, n, 1, 1, 0.5, 0.0, 11, 2, new Insets(10, 20, 10, 20), 0, 0));
    }

    private void setColumnFormat(int n, int n2) {
        String string = (String)myColumnNameVector.elementAt(n);
        TableColumn tableColumn = this.myMetricTable.getColumn(string);
        if (n2 > 0) {
            tableColumn.setPreferredWidth(n2);
        }
        if (n2 > 0) {
            tableColumn.setMinWidth(n2);
        }
        switch (n) {
            default: 
        }
    }

    private void addPropertyListeners() {
    }

    private void RefreshButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.getDataFromBean(this.myAdaptor);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(null, remoteException.toString(), "BaseAutotuneAdaptorTuningPanel()", 0);
        }
    }

    private void SetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setDataOnBean();
            this.getDataFromBean(this.myAdaptor);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.toString(), "BaseAutotuneAdaptorTuningPanel()", 0);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "autotune/doc-files/BaseAutotuneAdaptorTuningHelp.html";
    }

    public URL getHelpContext() {
        URL uRL = null;
        try {
            uRL = new URL("\\...\\autotune");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }

    static {
        myColumnNameVector.addElement(COL_NAME);
        myColumnNameVector.addElement(COL_VALUE);
    }

    class MetricTableModel
    extends DefaultTableModel {
        public MetricTableModel(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        public Object getValueAt(int n, int n2) {
            Vector vector = (Vector)BaseAutotuneAdaptorTuningPanel.this.myDataVector.elementAt(n);
            return vector.elementAt(n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = ((String)object).trim();
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    Vector vector = (Vector)BaseAutotuneAdaptorTuningPanel.this.myDataVector.elementAt(n);
                    vector.setElementAt(object, n2);
                    break;
                }
            }
        }
    }
}

