/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleGui;
import com.ibm.able.AbleHelp;
import com.ibm.able.autotune.AutotuneMetric;
import com.ibm.able.autotune.AutotuneMetricCollection;
import com.ibm.able.autotune.BaseAutotuneAdaptor;
import com.ibm.able.autotune.BaseAutotuneAdaptorCustomizer;
import com.ibm.able.data.AbleDataException;
import java.awt.Dimension;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class BaseAutotuneAdaptorMetricPanel
extends JPanel
implements AbleCustomizerPanel {
    static final String COL_CATEGORY = "Metric category";
    static final int COL_CATEGORY_ID = 0;
    static final int COL_CATEGORY_WID = -1;
    static final String COL_NAME = "Name";
    static final int COL_NAME_ID = 1;
    static final int COL_NAME_WID = 75;
    static final String COL_VALUE = "Value";
    static final int COL_VALUE_ID = 2;
    static final int COL_VALUE_WID = 75;
    private static Vector myColumnNameVector = new Vector();
    private boolean myFrameSizeAdjusted = false;
    private BaseAutotuneAdaptor myAdaptor = null;
    private BaseAutotuneAdaptorCustomizer myCustomizer = null;
    private BaseAutotuneAdaptorMetricPanel myPanel = null;
    private JTable myMetricTable = null;
    private MetricTableModel myMetricTableModel = null;
    private Vector myDataVector = null;

    private BaseAutotuneAdaptorMetricPanel() {
    }

    public BaseAutotuneAdaptorMetricPanel(BaseAutotuneAdaptorCustomizer baseAutotuneAdaptorCustomizer) {
        this.myCustomizer = baseAutotuneAdaptorCustomizer;
        this.setLayout(new BoxLayout(this, 1));
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myAdaptor == null) {
            this.myAdaptor = (BaseAutotuneAdaptor)object;
        }
        this.myDataVector.removeAllElements();
        AutotuneMetricCollection autotuneMetricCollection = this.myAdaptor.getMetrics();
        this.addRows(AbleGui.NlsMsg("Autotune_WorkloadMetricsLabel"), autotuneMetricCollection.getWorkloadMetrics());
        this.addRows(AbleGui.NlsMsg("Autotune_ServiceLevelMetricsLabel"), autotuneMetricCollection.getServiceLevelMetrics());
        this.addRows(AbleGui.NlsMsg("Autotune_ConfigurationParameterMetricsLabel"), autotuneMetricCollection.getConfigurationMetrics());
        this.addRows(AbleGui.NlsMsg("Autotune_TuningParameterMetricsLabel"), autotuneMetricCollection.getTuningControlMetrics());
    }

    private void addRows(String string, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Vector<String> vector2 = new Vector<String>(3);
            vector2.addElement(string);
            AutotuneMetric autotuneMetric = (AutotuneMetric)vector.elementAt(i);
            vector2.addElement(autotuneMetric.getName());
            try {
                vector2.addElement(autotuneMetric.getStringValue());
            }
            catch (AbleDataException ableDataException) {
                System.out.println("Exception " + ableDataException.toString());
            }
            this.myDataVector.addElement(vector2);
        }
    }

    public void setDataOnBean() {
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.myFrameSizeAdjusted) {
            return;
        }
        this.myFrameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    private void initializePanel() {
        this.myDataVector = new Vector();
        this.myMetricTableModel = new MetricTableModel(this.myDataVector, myColumnNameVector);
        this.myMetricTable = new JTable(this.myMetricTableModel);
        this.myMetricTable.setSelectionMode(0);
        this.setColumnFormat(0, -1);
        this.setColumnFormat(1, 75);
        this.setColumnFormat(2, 75);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setAutoscrolls(true);
        jScrollPane.getViewport().add(this.myMetricTable);
        jScrollPane.setPreferredSize(new Dimension(262, 175));
        this.add(jScrollPane);
    }

    private void setColumnFormat(int n, int n2) {
        String string = (String)myColumnNameVector.elementAt(n);
        TableColumn tableColumn = this.myMetricTable.getColumn(string);
        if (n2 > 0) {
            tableColumn.setPreferredWidth(n2);
        }
        if (n2 > 0) {
            tableColumn.setMinWidth(n2);
        }
        switch (n) {
            default: 
        }
    }

    private void addPropertyListeners() {
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "autotune/doc-files/BaseAutotuneAdaptorMetricHelp.html";
    }

    public URL getHelpContext() {
        URL uRL = null;
        try {
            uRL = new URL("\\...\\autotune");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }

    static {
        myColumnNameVector.addElement(COL_CATEGORY);
        myColumnNameVector.addElement(COL_NAME);
        myColumnNameVector.addElement(COL_VALUE);
    }

    class MetricTableModel
    extends DefaultTableModel {
        public MetricTableModel(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

