/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleEventListener;
import com.ibm.able.autotune.AutotuneAgentCustomizer;
import com.ibm.able.autotune.AutotuneAgentIf;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AutotuneRemotePanel
extends JPanel
implements AbleCustomizerPanel {
    private AutotuneAgentIf myAgent = null;
    private AutotuneAgentCustomizer myCustomizer = null;
    private String myHostName = null;
    private String myPort = null;
    private TreeSet myAgentNames = null;
    private Registry myRegistry = null;
    private boolean myCancelledFlag = true;
    private JTextField myHostNameTextField = null;
    private JTextField myPortTextField = null;
    private JComboBox myAgentNamesComboBox = null;

    private AutotuneRemotePanel() {
    }

    public AutotuneRemotePanel(AutotuneAgentCustomizer autotuneAgentCustomizer) {
        this.myCustomizer = autotuneAgentCustomizer;
        this.setLayout(new GridBagLayout());
        this.initializePanel();
    }

    public void getDataFromBean(Object object) {
        if (this.myAgent == null) {
            this.myAgent = (AutotuneAgentIf)object;
        }
        this.myHostNameTextField.setText("");
        String string = Able.Preferences.getCommPort();
        if (string.startsWith(":")) {
            string = string.substring(1);
        }
        this.myPortTextField.setText(string);
        Vector vector = new Vector();
        this.myAgentNamesComboBox.setModel(new DefaultComboBoxModel(vector));
        if (vector.size() > 0) {
            this.myAgentNamesComboBox.setSelectedItem(vector.elementAt(0));
        }
    }

    public void setDataOnBean() throws RemoteException {
        this.myHostName = this.myHostNameTextField.getText().trim();
        this.myPort = this.myPortTextField.getText().trim();
        if (this.myPort.startsWith(":")) {
            this.myPort.substring(1);
        }
        Able.Preferences.setCommPort(":" + this.myPort);
    }

    private void importRemoteAgent(AbleBean ableBean) {
        try {
            this.myAgent.setRemoteAgent((AutotuneAgentIf)ableBean);
            ableBean.addAbleEventListener((AbleEventListener)this.myAgent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, exception.toString(), "Editor Error: createInstance_actionPerformed() ", 0);
        }
    }

    private void initializePanel() {
        AutotuneRemotePanel autotuneRemotePanel = this;
        autotuneRemotePanel.setLayout(new GridBagLayout());
        int n = -1;
        autotuneRemotePanel.add((Component)new JLabel("Host:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.myHostNameTextField = new JTextField();
        this.myHostNameTextField.setToolTipText("Host where agent is registered");
        autotuneRemotePanel.add((Component)this.myHostNameTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        autotuneRemotePanel.add((Component)new JLabel("Port:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.myPortTextField = new JTextField();
        this.myPortTextField.setToolTipText("Port where agent is registered");
        autotuneRemotePanel.add((Component)this.myPortTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        autotuneRemotePanel.add((Component)new JLabel("Registered agents:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.myAgentNamesComboBox = new JComboBox();
        this.myAgentNamesComboBox.setToolTipText("Preferred look and feel name");
        autotuneRemotePanel.add((Component)this.myAgentNamesComboBox, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        JButton jButton = new JButton("List");
        jButton.setSize(90, 24);
        jButton.setToolTipText("Find the registered agents");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutotuneRemotePanel.this.BrowseButton_actionPerformed(actionEvent);
            }
        });
        autotuneRemotePanel.add((Component)jButton, new AbleGridBagConstraints(5, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 10), 0, 0));
        JButton jButton2 = new JButton("Apply");
        jButton2.setSize(180, 24);
        jButton2.setToolTipText("Import remote agents");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutotuneRemotePanel.this.applyButton_actionPerformed(actionEvent);
            }
        });
        autotuneRemotePanel.add((Component)jButton2, new AbleGridBagConstraints(1, ++n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 30, 0, 30), 0, 0));
    }

    private void BrowseButton_actionPerformed(ActionEvent actionEvent) {
        this.myHostName = this.myHostNameTextField.getText().trim();
        this.myPort = this.myPortTextField.getText().trim();
        if (this.myPort.startsWith(":")) {
            this.myPort = this.myPort.substring(1);
        }
        try {
            Registry registry = LocateRegistry.getRegistry(this.myHostName, new Integer(this.myPort));
            String[] stringArray = registry.list();
            this.myAgentNames = new TreeSet();
            for (int i = 0; i < stringArray.length; ++i) {
                this.myAgentNames.add(stringArray[i]);
            }
            this.myAgentNamesComboBox.setModel(new DefaultComboBoxModel<Object>(this.myAgentNames.toArray()));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "Editor Error: AbleImportRemoteAgentDialog()", 0);
        }
    }

    private void applyButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setDataOnBean();
            Object[] objectArray = this.myAgentNamesComboBox.getSelectedObjects();
            for (int i = 0; i < objectArray.length; ++i) {
                Remote remote = null;
                Registry registry = LocateRegistry.getRegistry(this.myHostName, new Integer(this.myPort));
                try {
                    remote = registry.lookup(objectArray[i].toString());
                    this.importRemoteAgent((AbleBean)remote);
                    continue;
                }
                catch (AccessException accessException) {
                    continue;
                }
                catch (RemoteException remoteException) {
                    continue;
                }
                catch (NotBoundException notBoundException) {
                    // empty catch block
                }
            }
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, remoteException.getLocalizedMessage(), "Editor Error: AbleImportRemoteAgentDialog()", 0);
        }
    }

    public String getHelpFileName() {
        return "doc-files/AutotuneRemoteHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

