/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.autotune.AutotuneAgent;
import com.ibm.able.autotune.AutotuneAgentCustomizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class AutotuneAgentTargetPanel
extends JPanel
implements AbleCustomizerPanel {
    private static Vector myOperatorVector = new Vector();
    static final String COL_SERVICELEVEL = "Service level";
    static final int COL_SERVICELEVEL_ID = 0;
    static final int COL_SERVICELEVEL_WID = -1;
    static final String COL_OPERATOR = "Operator";
    static final int COL_OPERATOR_ID = 1;
    static final int COL_OPERATOR_WID = 75;
    static final String COL_TARGET_VALUE = "Target value";
    static final int COL_TARGET_VALUE_ID = 2;
    static final int COL_TARGET_VALUE_WID = 75;
    static final String COL_CURRENT_VALUE = "Current value";
    static final int COL_CURRENT_VALUE_ID = 3;
    static final int COL_CURRENT_VALUE_WID = 75;
    static final String COL_DELTA_VALUE = "Delta";
    static final int COL_DELTA_VALUE_ID = 4;
    static final int COL_DELTA_VALUE_WID = 75;
    private static Vector myColumnNameVector;
    private boolean myFrameSizeAdjusted = false;
    private AutotuneAgent myAgent = null;
    private AutotuneAgentCustomizer myCustomizer = null;
    private JTable myTargetTable = null;
    private TargetTableModel myTargetTableModel = null;
    private JComboBox myOperatorComboBox = null;
    private Vector myDataVector = null;

    private AutotuneAgentTargetPanel() {
    }

    public AutotuneAgentTargetPanel(AutotuneAgentCustomizer autotuneAgentCustomizer) {
        this.myCustomizer = autotuneAgentCustomizer;
        this.setLayout(new BoxLayout(this, 1));
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) {
        if (this.myAgent == null) {
            this.myAgent = (AutotuneAgent)object;
        }
        this.myDataVector.removeAllElements();
    }

    public void setDataOnBean() {
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.myFrameSizeAdjusted) {
            return;
        }
        this.myFrameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    private void initializePanel() {
        this.myOperatorComboBox = new JComboBox();
        this.myOperatorComboBox.setModel(new DefaultComboBoxModel(myOperatorVector));
        this.myDataVector = new Vector();
        this.myTargetTableModel = new TargetTableModel(this.myDataVector, myColumnNameVector);
        this.myTargetTable = new JTable(this.myTargetTableModel);
        this.myTargetTable.setSelectionMode(0);
        this.setColumnFormat(0, -1);
        this.setColumnFormat(1, 75);
        this.setColumnFormat(2, 75);
        this.setColumnFormat(3, 75);
        this.setColumnFormat(4, 75);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setAutoscrolls(true);
        jScrollPane.getViewport().add(this.myTargetTable);
        jScrollPane.setPreferredSize(new Dimension(262, 175));
        this.add(jScrollPane);
    }

    private void setColumnFormat(int n, int n2) {
        String string = (String)myColumnNameVector.elementAt(n);
        TableColumn tableColumn = this.myTargetTable.getColumn(string);
        if (n2 > 0) {
            tableColumn.setPreferredWidth(n2);
        }
        if (n2 > 0) {
            tableColumn.setMinWidth(n2);
        }
        switch (n) {
            case 0: 
            case 1: {
                this.myTargetTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.myOperatorComboBox));
                if (n2 <= 0) break;
                tableColumn.setMaxWidth(n2);
                break;
            }
        }
    }

    private void addPropertyListeners() {
    }

    private void RefreshAdaptorButton_actionPerformed(ActionEvent actionEvent) {
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "autotune/doc-files/AutotuneAgentTargetHelp.html";
    }

    public URL getHelpContext() {
        URL uRL = null;
        try {
            uRL = new URL("\\...\\autotune");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }

    static {
        myOperatorVector.addElement("<none>");
        myOperatorVector.addElement(">");
        myOperatorVector.addElement(">=");
        myOperatorVector.addElement("<");
        myOperatorVector.addElement("<=");
        myOperatorVector.addElement("=");
        myOperatorVector.addElement("<>");
        myOperatorVector.addElement("in");
        myOperatorVector.addElement("not in");
        myColumnNameVector = new Vector();
        myColumnNameVector.addElement(COL_SERVICELEVEL);
        myColumnNameVector.addElement(COL_OPERATOR);
        myColumnNameVector.addElement(COL_TARGET_VALUE);
        myColumnNameVector.addElement(COL_CURRENT_VALUE);
        myColumnNameVector.addElement(COL_DELTA_VALUE);
    }

    class TargetTableModel
    extends DefaultTableModel {
        Component myDeltaCellRenderer = null;

        TargetTableModel(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = true;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        public void setValueAt(Object object, int n, int n2) {
            Vector vector = (Vector)AutotuneAgentTargetPanel.this.myDataVector.elementAt(n);
            if (this.myDeltaCellRenderer == null) {
                this.myDeltaCellRenderer = AutotuneAgentTargetPanel.this.myTargetTable.getDefaultRenderer(AutotuneAgentTargetPanel.this.myTargetTableModel.getColumnClass(4)).getTableCellRendererComponent(AutotuneAgentTargetPanel.this.myTargetTable, null, false, false, 0, 4);
            }
            boolean bl = false;
            if (object instanceof String) {
                try {
                    bl = this.setValueAt(Integer.valueOf((String)object), vector, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        bl = this.setValueAt(Double.valueOf((String)object), vector, n2);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        bl = this.setValueAt((String)object, vector, n2);
                    }
                }
            } else if (object instanceof Integer) {
                bl = this.setValueAt((Integer)object, vector, n2);
            } else if (object instanceof Double) {
                bl = this.setValueAt((Double)object, vector, n2);
            }
            if (bl) {
                AutotuneAgentTargetPanel.this.myTargetTableModel.fireTableCellUpdated(n, n2);
            }
        }

        private boolean setValueAt(String string, Vector vector, int n) {
            Object e = vector.elementAt(n);
            boolean bl = true;
            Object var6_6 = null;
            switch (n) {
                case 0: {
                    vector.setElementAt(string, 0);
                    break;
                }
                case 1: {
                    if (e instanceof JComboBox) {
                        ((JComboBox)e).setSelectedItem(string);
                        break;
                    }
                    vector.setElementAt(string, 1);
                    break;
                }
                case 2: {
                    vector.setElementAt(string, 2);
                    var6_6 = vector.elementAt(3);
                    break;
                }
                case 3: {
                    vector.setElementAt(string, 3);
                    var6_6 = vector.elementAt(2);
                    break;
                }
                case 4: {
                    vector.setElementAt(string, 4);
                    boolean bl2 = false;
                    Color color = Color.white;
                    Object e2 = vector.elementAt(2);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        private boolean setValueAt(Integer n, Vector vector, int n2) {
            Object e = vector.elementAt(n2);
            boolean bl = true;
            int n3 = 0;
            switch (n2) {
                case 0: {
                    vector.setElementAt(n, 0);
                    break;
                }
                case 1: {
                    if (e instanceof JComboBox) {
                        ((JComboBox)e).setSelectedItem(n);
                        break;
                    }
                    vector.setElementAt(n, 1);
                    break;
                }
                case 2: {
                    vector.setElementAt(n, 2);
                    n3 = (Integer)vector.elementAt(3);
                    n3 = n - n3;
                    this.setValueAt(new Integer(n3), vector, 4);
                    break;
                }
                case 3: {
                    vector.setElementAt(n, 3);
                    n3 = (Integer)vector.elementAt(2);
                    this.setValueAt(new Integer(n3 -= n.intValue()), vector, 4);
                    break;
                }
                case 4: {
                    int n4 = (Integer)vector.elementAt(4);
                    int n5 = (Integer)vector.elementAt(2);
                    int n6 = n;
                    vector.setElementAt(n, 4);
                    boolean bl2 = false;
                    Color color = Color.white;
                    if (n6 > 0 && n4 > 0 || n6 < 0 && n4 < 0) break;
                    float f = n6 / n5;
                    float f2 = n4 / n5;
                    if ((double)f < -0.2 && (double)f2 < -0.2) break;
                    bl2 = true;
                    color = (double)f < -0.2 ? Color.yellow : (n6 < 0 ? Color.red : Color.green);
                    if (!bl2) break;
                    AutotuneAgentTargetPanel.this.myTargetTable.setRowSelectionInterval(-1, -1);
                    this.myDeltaCellRenderer.setBackground(color);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        private boolean setValueAt(Double d, Vector vector, int n) {
            Object e = vector.elementAt(n);
            boolean bl = true;
            double d2 = 0.0;
            switch (n) {
                case 0: {
                    vector.setElementAt(d, 0);
                    break;
                }
                case 1: {
                    if (e instanceof JComboBox) {
                        ((JComboBox)e).setSelectedItem(d);
                        break;
                    }
                    vector.setElementAt(d, 1);
                    break;
                }
                case 2: {
                    vector.setElementAt(d, 2);
                    d2 = (Double)vector.elementAt(3);
                    d2 = (double)d.intValue() - d2;
                    this.setValueAt(new Double(d2), vector, 4);
                    break;
                }
                case 3: {
                    vector.setElementAt(d, 3);
                    d2 = (Double)vector.elementAt(2);
                    this.setValueAt(new Double(d2 -= (double)d.intValue()), vector, 4);
                    break;
                }
                case 4: {
                    double d3 = (Double)vector.elementAt(4);
                    double d4 = (Double)vector.elementAt(2);
                    double d5 = d;
                    vector.setElementAt(d, 4);
                    boolean bl2 = false;
                    Color color = Color.white;
                    if (d5 > d4 && d3 > d4) break;
                    double d6 = (d4 - d5) / d4;
                    double d7 = (d4 - d5) / d4;
                    if (d6 < -0.2 && d7 < -0.2) break;
                    bl2 = true;
                    color = d6 < -0.2 ? Color.yellow : (d5 >= d4 ? Color.red : Color.green);
                    if (!bl2) break;
                    this.myDeltaCellRenderer.setBackground(color);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    }
}

