/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.AbleBean;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.autotune.AutotuneAgentCustomizer;
import com.ibm.able.autotune.AutotuneAgentIf;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AutotuneAgentPanel
extends JPanel
implements AbleCustomizerPanel {
    private boolean myFrameSizeAdjusted = false;
    private AutotuneAgentIf myAgent = null;
    private AutotuneAgentCustomizer myCustomizer = null;
    private JComboBox myMasterControllerComboBox = null;
    private JTextField myControllerActionRateTextField = null;
    private JRadioButton mySynchronousAdaptorRadioButton = null;
    private JRadioButton myAsynchronousAdaptorRadioButton = null;
    private JTextField myAdaptorActionRateTextField = null;
    private JLabel myAdaptorActionRateLabel = null;
    private JTextField myDataRepositoryPathTextField = null;

    private AutotuneAgentPanel() {
    }

    public AutotuneAgentPanel(AutotuneAgentCustomizer autotuneAgentCustomizer) {
        this.myCustomizer = autotuneAgentCustomizer;
        this.setLayout(new GridBagLayout());
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        AbleBean ableBean;
        Object object2;
        Vector vector;
        if (this.myAgent == null) {
            this.myAgent = (AutotuneAgentIf)object;
        }
        if (this.myMasterControllerComboBox.getItemCount() > 0) {
            this.myMasterControllerComboBox.removeAllItems();
        }
        if ((vector = this.myAgent.getControllers()) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                object2 = (AbleBean)vector.elementAt(i);
                this.myMasterControllerComboBox.addItem(object2.getName());
            }
        }
        if ((ableBean = (AbleBean)this.myAgent.getMasterController()) != null) {
            this.myMasterControllerComboBox.setSelectedItem(ableBean.getName());
        }
        this.myControllerActionRateTextField.setText(String.valueOf(this.myAgent.getControllerRate()));
        this.mySynchronousAdaptorRadioButton.setSelected(this.myAgent.isSynchronousAdaptorMode());
        this.myAdaptorActionRateTextField.setText(String.valueOf(this.myAgent.getDefaultAdaptorRate()));
        object2 = this.myAgent.getDataRepositoryPath();
        if (object2 != null) {
            this.myDataRepositoryPathTextField.setText((String)object2);
        }
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myAgent.setMasterController((String)this.myMasterControllerComboBox.getSelectedItem());
            this.myAgent.setControllerRate(Integer.parseInt(this.myControllerActionRateTextField.getText().trim()));
            this.myAgent.setSynchronousAdaptorMode(this.mySynchronousAdaptorRadioButton.isSelected());
            this.myAgent.setDefaultAdaptorRate(Integer.parseInt(this.myAdaptorActionRateTextField.getText().trim()));
            this.setDataRepositoryPath();
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Autotune Agent panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Autotune Agent panel.\n" + nullPointerException.toString());
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.myFrameSizeAdjusted) {
            return;
        }
        this.myFrameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    private void initializePanel() {
        int n = 0;
        this.add((Component)new JLabel("Master Controller:"), new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.myMasterControllerComboBox = new JComboBox();
        this.myMasterControllerComboBox.setEditable(true);
        this.myMasterControllerComboBox.setToolTipText("Enter the name of the master controller bean");
        this.add((Component)this.myMasterControllerComboBox, new AbleGridBagConstraints(1, n, 3, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)new JLabel("Controller Action Interval:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.myControllerActionRateTextField = new JTextField();
        this.myControllerActionRateTextField.setToolTipText("Interval between controller actions");
        this.add((Component)this.myControllerActionRateTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)new JLabel("milliseconds"), new AbleGridBagConstraints(2, n, 1, 1, 0.5, 0.0, 13, 2, new Insets(10, 0, 10, 10), 0, 0));
        this.add((Component)new JLabel("Adaptor Collection Mode:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.mySynchronousAdaptorRadioButton = new JRadioButton("Synchronous");
        this.add((Component)this.mySynchronousAdaptorRadioButton, new AbleGridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.myAsynchronousAdaptorRadioButton = new JRadioButton("Asynchronous");
        this.add((Component)this.myAsynchronousAdaptorRadioButton, new AbleGridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 0), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mySynchronousAdaptorRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AutotuneAgentPanel.this.setAdaptorActionRateEnabled(itemEvent);
            }
        });
        this.myAsynchronousAdaptorRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AutotuneAgentPanel.this.setAdaptorActionRateEnabled(itemEvent);
            }
        });
        buttonGroup.add(this.mySynchronousAdaptorRadioButton);
        buttonGroup.add(this.myAsynchronousAdaptorRadioButton);
        this.myAdaptorActionRateTextField = new JTextField();
        this.myAdaptorActionRateTextField.setToolTipText("Default interval between adaptor data collections");
        this.add((Component)this.myAdaptorActionRateTextField, new AbleGridBagConstraints(2, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 10, 10), 0, 0));
        this.myAdaptorActionRateLabel = new JLabel("Interval, milliseconds");
        this.add((Component)this.myAdaptorActionRateLabel, new AbleGridBagConstraints(3, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)new JLabel("Data Repository Path:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.myDataRepositoryPathTextField = new JTextField();
        this.myDataRepositoryPathTextField.setToolTipText("Default directory for logging adaptor data");
        this.add((Component)this.myDataRepositoryPathTextField, new AbleGridBagConstraints(1, n, 2, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        JButton jButton = new JButton("Browse...");
        jButton.setToolTipText("Select the default data logging directory");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutotuneAgentPanel.this.BrowseButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)jButton, new AbleGridBagConstraints(3, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 10, 10), 0, 0));
        JButton jButton2 = new JButton("Initialize");
        jButton2.setToolTipText("Initialize the agent controller and adaptors");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutotuneAgentPanel.this.InitializeButton_actionPerformed(actionEvent);
            }
        });
        this.add((Component)jButton2, new AbleGridBagConstraints(1, ++n, 2, 1, 0.5, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
    }

    private void addPropertyListeners() {
        this.myDataRepositoryPathTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutotuneAgentPanel.this.setDataRepositoryPath();
            }
        });
        this.myDataRepositoryPathTextField.getDocument().addDocumentListener(new PathListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void InitializeButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myCustomizer.updateProperties();
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myAgent.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AutotuneAgentPanel Error: Initialize()", 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void BrowseButton_actionPerformed(ActionEvent actionEvent) {
        File file;
        Container container;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        String string = this.myDataRepositoryPathTextField.getText();
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        for (container = this.getTopLevelAncestor(); container != null && !(container instanceof Window); container = container.getParent()) {
        }
        if (jFileChooser.showOpenDialog(container) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.myDataRepositoryPathTextField.setText(file.getPath());
        }
    }

    private void setAdaptorActionRateEnabled(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            boolean bl = this.myAsynchronousAdaptorRadioButton.isSelected();
            this.myAdaptorActionRateTextField.setEnabled(bl);
            this.myAdaptorActionRateLabel.setEnabled(bl);
        }
    }

    private void setDataRepositoryPath() {
        try {
            if (this.myAgent != null) {
                this.myAgent.setDataRepositoryPath(this.myDataRepositoryPathTextField.getText());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "autotune/doc-files/AutotuneAgentHelp.html";
    }

    public URL getHelpContext() {
        URL uRL = null;
        try {
            uRL = new URL("\\...\\autotune");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }

    class PathListener
    implements DocumentListener {
        PathListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AutotuneAgentPanel.this.setDataRepositoryPath();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AutotuneAgentPanel.this.setDataRepositoryPath();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AutotuneAgentPanel.this.setDataRepositoryPath();
        }
    }
}

