/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.autotune;

import com.ibm.able.AbleCheckBoxTreeCellRenderer;
import com.ibm.able.AbleCheckBoxTreeNode;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleGui;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.autotune.AutotuneAgentIf;
import com.ibm.able.autotune.AutotuneMetric;
import com.ibm.able.autotune.AutotuneMetricCollection;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AutotuneAgentMetricPanel
extends JPanel
implements AbleCustomizerPanel {
    private boolean myFrameSizeAdjusted = false;
    private AutotuneAgentIf myAgent = null;
    private AbleObjectCustomizer myCustomizer = null;
    private Hashtable myLoggingMetricsHashtable = null;
    private AutotuneMetricCollection myLoggingMetrics = null;
    private JTree myMetricsTree = null;
    private DefaultTreeModel myMetricsTreeModel = null;
    private AbleCheckBoxTreeNode myRootTreeNode = null;
    private JTextField myLogDataFileNameTextField = null;
    private JCheckBox myLogDataCheckBox = null;

    private AutotuneAgentMetricPanel() {
    }

    public AutotuneAgentMetricPanel(AbleObjectCustomizer ableObjectCustomizer) {
        this.myCustomizer = ableObjectCustomizer;
        this.setLayout(new GridBagLayout());
        this.setBounds(5, 25, 525, 350);
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myAgent == null) {
            this.myAgent = (AutotuneAgentIf)object;
        }
        AutotuneMetricCollection autotuneMetricCollection = this.myAgent.getMetrics();
        this.myLoggingMetrics = this.myAgent.getLoggingMetrics();
        this.myLoggingMetricsHashtable = this.myLoggingMetrics.getMetrics();
        AbleCheckBoxTreeNode ableCheckBoxTreeNode = new AbleCheckBoxTreeNode("Loggable metrics", true, false);
        this.addToNode(ableCheckBoxTreeNode, AbleGui.NlsMsg("Autotune_WorkloadMetricsLabel"), autotuneMetricCollection.getWorkloadMetrics());
        this.addToNode(ableCheckBoxTreeNode, AbleGui.NlsMsg("Autotune_ServiceLevelMetricsLabel"), autotuneMetricCollection.getServiceLevelMetrics());
        this.addToNode(ableCheckBoxTreeNode, AbleGui.NlsMsg("Autotune_ConfigurationParameterMetricsLabel"), autotuneMetricCollection.getConfigurationMetrics());
        this.addToNode(ableCheckBoxTreeNode, AbleGui.NlsMsg("Autotune_TuningParameterMetricsLabel"), autotuneMetricCollection.getTuningControlMetrics());
        this.myMetricsTree.setModel(new DefaultTreeModel(ableCheckBoxTreeNode));
        this.myMetricsTree.setRowHeight(0);
        this.myLogDataCheckBox.setSelected(this.myAgent.isLogData());
        String string = this.myAgent.getLogDataFileName();
        String string2 = this.myAgent.getDataRepositoryPath();
        if (string.equals("autotune.log") && string2 != null) {
            string = string2 + string;
        }
        this.myLogDataFileNameTextField.setText(string);
    }

    private void addToNode(AbleCheckBoxTreeNode ableCheckBoxTreeNode, String string, Vector vector) {
        AbleCheckBoxTreeNode ableCheckBoxTreeNode2 = new AbleCheckBoxTreeNode(string, true, false);
        ableCheckBoxTreeNode2.setAllowsChildren(true);
        int n = vector.size();
        int n2 = 0;
        AutotuneMetric autotuneMetric = null;
        AbleCheckBoxTreeNode ableCheckBoxTreeNode3 = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            autotuneMetric = (AutotuneMetric)vector.elementAt(i);
            bl = this.myLoggingMetricsHashtable.containsKey(autotuneMetric.getName());
            if (bl) {
                ++n2;
            }
            ableCheckBoxTreeNode3 = new AbleCheckBoxTreeNode(autotuneMetric, false, bl);
            ableCheckBoxTreeNode2.add(ableCheckBoxTreeNode3);
        }
        ableCheckBoxTreeNode2.setSelected(n == n2 && n > 0);
        ableCheckBoxTreeNode.add(ableCheckBoxTreeNode2);
    }

    public void setDataOnBean() throws RemoteException {
        this.myLoggingMetrics.removeAll();
        Enumeration<TreeNode> enumeration = ((AbleCheckBoxTreeNode)this.myMetricsTree.getModel().getRoot()).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            AbleCheckBoxTreeNode ableCheckBoxTreeNode = (AbleCheckBoxTreeNode)enumeration.nextElement();
            if (ableCheckBoxTreeNode.getAllowsChildren() || !ableCheckBoxTreeNode.isSelected()) continue;
            this.myLoggingMetrics.addMetric((AutotuneMetric)ableCheckBoxTreeNode.getUserObject());
        }
        this.myAgent.setLogData(this.myLogDataCheckBox.isSelected());
        this.myAgent.setLogDataFileName(this.myLogDataFileNameTextField.getText().trim());
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.myFrameSizeAdjusted) {
            return;
        }
        this.myFrameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    private void initializePanel() {
        this.myMetricsTree = new JTree();
        this.myMetricsTree.setRootVisible(true);
        this.myMetricsTree.getSelectionModel().setSelectionMode(1);
        this.myMetricsTree.setCellRenderer(new AbleCheckBoxTreeCellRenderer());
        this.myMetricsTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AutotuneAgentMetricPanel.this.MouseClick_actionPerformed(mouseEvent);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.myMetricsTree);
        jScrollPane.setAutoscrolls(true);
        jScrollPane.setPreferredSize(new Dimension(200, 100));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)jScrollPane, new AbleGridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 17, 1, new Insets(5, 2, 2, 2), 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Metric logging options"));
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBounds(5, 25, 525, 116);
        this.add((Component)jPanel, new AbleGridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        int n = 0;
        this.myLogDataCheckBox = new JCheckBox("Write data to");
        jPanel.add((Component)this.myLogDataCheckBox, new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.myLogDataFileNameTextField = new JTextField();
        this.myLogDataFileNameTextField.setToolTipText("A file used to store metrics obtained by an adaptor");
        jPanel.add((Component)this.myLogDataFileNameTextField, new AbleGridBagConstraints(1, n, 3, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        JButton jButton = new JButton("Browse...");
        jButton.setToolTipText("Choose data file");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutotuneAgentMetricPanel.this.BrowseLogButton_actionPerformed(actionEvent);
            }
        });
        jPanel.add((Component)jButton, new AbleGridBagConstraints(4, n, 1, 1, 0.5, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        JButton jButton2 = new JButton("Open");
        jButton2.setToolTipText("Open file");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutotuneAgentMetricPanel.this.OpenLogButton_actionPerformed(actionEvent);
            }
        });
        jPanel.add((Component)jButton2, new AbleGridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        JButton jButton3 = new JButton("Close");
        jButton3.setToolTipText("Close file");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutotuneAgentMetricPanel.this.CloseLogButton_actionPerformed(actionEvent);
            }
        });
        jPanel.add((Component)jButton3, new AbleGridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        JButton jButton4 = new JButton("Erase");
        jButton4.setToolTipText("Erase all file entries");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AutotuneAgentMetricPanel.this.EraseLogButton_actionPerformed(actionEvent);
            }
        });
        jPanel.add((Component)jButton4, new AbleGridBagConstraints(3, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
    }

    private void addPropertyListeners() {
    }

    private void MouseClick_actionPerformed(MouseEvent mouseEvent) {
        int n = this.myMetricsTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        TreePath treePath = this.myMetricsTree.getPathForRow(n);
        if (treePath != null) {
            AbleCheckBoxTreeNode ableCheckBoxTreeNode = (AbleCheckBoxTreeNode)treePath.getLastPathComponent();
            boolean bl = !ableCheckBoxTreeNode.isSelected();
            ableCheckBoxTreeNode.setSelected(bl);
            if (bl) {
                // empty if block
            }
            ((DefaultTreeModel)this.myMetricsTree.getModel()).nodeChanged(ableCheckBoxTreeNode);
            if (n == 0) {
                this.myMetricsTree.revalidate();
                this.myMetricsTree.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void BrowseLogButton_actionPerformed(ActionEvent actionEvent) {
        try {
            String string = AblePanelHelper.setTextFieldFromFileDialog(this.myLogDataFileNameTextField, "Log File (*.log)", "log", this.myAgent.getDataRepositoryPath());
            if (string == null) return;
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AutotuneAgentPanel Error: BrowseLog()", 0);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OpenLogButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myLoggingMetrics.openLogDataFile();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AutotuneAgentPanel Error: OpenLog()", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CloseLogButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myLoggingMetrics.closeLogDataFile();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AutotuneAgentPanel Error: CloseLog()", 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void EraseLogButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myLoggingMetrics.eraseLogDataFile();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AutotuneAgentPanel Error: ClearLog()", 0);
        }
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.getDataFromBean(this.myAgent);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this.myCustomizer, "Panel values for training changed, but were not updated.\n" + remoteException.toString(), "AutotuneAgentMetricPanel Warning: refreshPanel()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "autotune/doc-files/AutotuneAgentMetricHelp.html";
    }

    public URL getHelpContext() {
        URL uRL = null;
        try {
            uRL = new URL("\\...\\autotune");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2003.";
    }
}

