/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.agents;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.agents.AbleScriptAgent;
import com.ibm.able.agents.AbleScriptAgentCustomizer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AbleScriptAgentPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleScriptAgent myAgent = null;
    private AbleScriptAgentCustomizer myCustomizer = null;
    private JTextField myInitScriptFileNameTextField = null;
    private JTextField myProcessScriptFileNameTextField = null;
    private JTextField myProcessTimerScriptFileNameTextField = null;
    private JButton myGenerateButton = null;
    private JTextField myMinimumPercentCorrectTextField = null;
    private JTextField myClassErrorToleranceTextField = null;
    private JTextField myTrainToleranceTextField = null;
    private JTextField myMaximumPassesTextField = null;
    private TextListener myTextListener = null;

    private AbleScriptAgentPanel() {
    }

    public AbleScriptAgentPanel(AbleScriptAgentCustomizer ableScriptAgentCustomizer) {
        this.myCustomizer = ableScriptAgentCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myAgent == null) {
            this.myAgent = (AbleScriptAgent)object;
        }
        String string = this.myAgent.getInitScriptFileName();
        if (!this.myInitScriptFileNameTextField.getText().equals(string)) {
            this.myInitScriptFileNameTextField.setText(string);
        }
        string = this.myAgent.getProcessScriptFileName();
        if (!this.myProcessScriptFileNameTextField.getText().equals(string)) {
            this.myProcessScriptFileNameTextField.setText(string);
        }
        string = this.myAgent.getProcessTimerScriptFileName();
        if (!this.myProcessTimerScriptFileNameTextField.getText().equals(string)) {
            this.myProcessTimerScriptFileNameTextField.setText(string);
        }
        this.setButtonStates();
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myAgent.setInitScriptFileName(this.myInitScriptFileNameTextField.getText().trim());
            this.myAgent.setProcessScriptFileName(this.myProcessScriptFileNameTextField.getText().trim());
            this.myAgent.setProcessTimerScriptFileName(this.myProcessTimerScriptFileNameTextField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Script Agent panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Script Agent panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = -25;
        int n2 = 35;
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Init Rule Set:");
        this.myInitScriptFileNameTextField = AblePanelHelper.addTextField(this, 170, n, 220);
        this.myInitScriptFileNameTextField.setToolTipText("Ruleset called on bean init()");
        this.myTextListener = new TextListener();
        this.myInitScriptFileNameTextField.getDocument().addDocumentListener(this.myTextListener);
        AblePanelHelper.addButton(this, 400, n, 100, "Browse...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleScriptAgentPanel.this.BrowseInitScriptButton_actionPerformed(actionEvent);
            }
        }, "Select a rule set file for init processing");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Process Rule Set:");
        this.myProcessScriptFileNameTextField = AblePanelHelper.addTextField(this, 170, n, 220);
        this.myProcessScriptFileNameTextField.setToolTipText("Ruleset called on bean process()");
        this.myProcessScriptFileNameTextField.getDocument().addDocumentListener(this.myTextListener);
        AblePanelHelper.addButton(this, 400, n, 100, "Browse...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleScriptAgentPanel.this.BrowseProcessScriptButton_actionPerformed(actionEvent);
            }
        }, "Select a ruleset file for process logic");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "ProcessTimer Rule Set:");
        this.myProcessTimerScriptFileNameTextField = AblePanelHelper.addTextField(this, 170, n, 220);
        this.myProcessTimerScriptFileNameTextField.setToolTipText("RuleSet called on bean processTimerEvent()");
        this.myProcessTimerScriptFileNameTextField.getDocument().addDocumentListener(this.myTextListener);
        AblePanelHelper.addButton(this, 400, n, 100, "Browse...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleScriptAgentPanel.this.BrowseProcessTimerScriptButton_actionPerformed(actionEvent);
            }
        }, "Select a ruleset file for process timer logic");
        this.myGenerateButton = AblePanelHelper.addButton(this, 190, n += n2, 180, "Generate Beans", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleScriptAgentPanel.this.GenerateButton_actionPerformed(actionEvent);
            }
        }, "Create ruleset beans from external files");
    }

    private void addPropertyListeners() {
        this.myCustomizer.addPropertyChangeMethod("training", this, "refreshPanel");
    }

    private void setButtonStates() {
    }

    private void BrowseInitScriptButton_actionPerformed(ActionEvent actionEvent) {
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myInitScriptFileNameTextField, "RuleSet File (*.arl)", "arl", this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void BrowseProcessScriptButton_actionPerformed(ActionEvent actionEvent) {
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myProcessScriptFileNameTextField, "RuleSet File (*.arl)", "arl", this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void BrowseProcessTimerScriptButton_actionPerformed(ActionEvent actionEvent) {
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myProcessTimerScriptFileNameTextField, "RuleSet File (*.arl)", "arl", this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void GenerateButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myAgent.getBeans() != null && this.myAgent.getBeans().size() > 0 && 1 == JOptionPane.showConfirmDialog(this, "This will erase existing beans and regenerate them.\nInspector property changes and inspectors themselves will need to be recreated.\n\nAre you sure you want to do this?", "Regenerate Beans", 0)) {
                return;
            }
            this.myCustomizer.updateProperties();
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myAgent.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleScriptAgentPanel Error: GenerateButton()", 0);
        }
    }

    private void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.updateProperties();
            this.myAgent.reset();
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleScriptAgentPanel Error: ResetButton()", 0);
        }
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.getDataFromBean(this.myAgent);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this.myCustomizer, "Panel values for training changed, but were not updated.\n" + remoteException.toString(), "AbleScriptAgentPanel Warning: refreshPanel()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "agents/doc-files/AbleScriptAgentHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class TextListener
    implements DocumentListener {
        TextListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AbleScriptAgentPanel.this.setButtonStates();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbleScriptAgentPanel.this.setButtonStates();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbleScriptAgentPanel.this.setButtonStates();
        }
    }
}

