/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.agents;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.agents.AbleRuleAgent;
import com.ibm.able.agents.AbleRuleAgentCustomizer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AbleRuleAgentPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleRuleAgent myAgent = null;
    private AbleRuleAgentCustomizer myCustomizer = null;
    private JTextField myBehaviorRuleSetFileNameTextField = null;
    private JButton myGenerateButton = null;
    private JTextField myMinimumPercentCorrectTextField = null;
    private JTextField myClassErrorToleranceTextField = null;
    private JTextField myTrainToleranceTextField = null;
    private JTextField myMaximumPassesTextField = null;
    private TextListener myTextListener = null;

    private AbleRuleAgentPanel() {
    }

    public AbleRuleAgentPanel(AbleRuleAgentCustomizer ableRuleAgentCustomizer) {
        this.myCustomizer = ableRuleAgentCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myAgent == null) {
            this.myAgent = (AbleRuleAgent)object;
        }
        String string = this.myAgent.getBehaviorRuleSetFileName();
        if (!this.myBehaviorRuleSetFileNameTextField.getText().equals(string)) {
            this.myBehaviorRuleSetFileNameTextField.setText(string);
        }
        this.setButtonStates();
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myAgent.setBehaviorRuleSetFileName(this.myBehaviorRuleSetFileNameTextField.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Rule Agent panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Rule Agent panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = -25;
        int n2 = 35;
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Init Rule Set:");
        this.myBehaviorRuleSetFileNameTextField = AblePanelHelper.addTextField(this, 170, n, 220);
        this.myBehaviorRuleSetFileNameTextField.setToolTipText("Ruleset used to process agent behavior.");
        this.myTextListener = new TextListener();
        this.myBehaviorRuleSetFileNameTextField.getDocument().addDocumentListener(this.myTextListener);
        AblePanelHelper.addButton(this, 400, n, 100, "Browse...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleAgentPanel.this.BrowseBehaviorRuleSetButton_actionPerformed(actionEvent);
            }
        }, "Select a rule set file for agent behavior");
        this.myGenerateButton = AblePanelHelper.addButton(this, 190, n += n2, 180, "Generate Bean", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleRuleAgentPanel.this.GenerateButton_actionPerformed(actionEvent);
            }
        }, "Create the ruleset bean from an external file");
    }

    private void addPropertyListeners() {
        this.myCustomizer.addPropertyChangeMethod("training", this, "refreshPanel");
    }

    private void setButtonStates() {
    }

    private void BrowseBehaviorRuleSetButton_actionPerformed(ActionEvent actionEvent) {
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myBehaviorRuleSetFileNameTextField, "RuleSet File (*.arl)", "arl", this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void GenerateButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myAgent.getBeans() != null && this.myAgent.getBeans().size() > 0 && 1 == JOptionPane.showConfirmDialog(this, "This will erase the existing ruleset bean and regenerate it.\nInspector property changes and inspectors themselves will need to be recreated.\n\nAre you sure you want to do this?", "Regenerate Beans", 0)) {
                return;
            }
            this.myCustomizer.updateProperties();
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myAgent.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, remoteException.toString(), "AbleRuleAgentPanel Error: GenerateButton()", 0);
        }
    }

    private void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.updateProperties();
            this.myAgent.reset();
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, remoteException.toString(), "AbleRuleAgentPanel Error: ResetButton()", 0);
        }
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.getDataFromBean(this.myAgent);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this.myCustomizer, "Panel values for training changed, but were not updated.\n" + remoteException.toString(), "AbleRuleAgentPanel Warning: refreshPanel()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "agents/doc-files/AbleRuleAgentHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class TextListener
    implements DocumentListener {
        TextListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AbleRuleAgentPanel.this.setButtonStates();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbleRuleAgentPanel.this.setButtonStates();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbleRuleAgentPanel.this.setButtonStates();
        }
    }
}

