/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.agents;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.agents.AbleNeuralClusteringAgent;
import com.ibm.able.agents.AbleNeuralClusteringAgentCustomizer;
import com.ibm.able.beans.AbleNetwork;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AbleNeuralClusteringAgentPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleNeuralClusteringAgent myAgent = null;
    private AbleNeuralClusteringAgentCustomizer myCustomizer = null;
    private String myArchitecture = null;
    private JTextField myTrainFileTextField = null;
    private JTextField myTestFileTextField = null;
    private JTextField myArchInputTextField = null;
    private JTextField myArchOutput1TextField = null;
    private JTextField myArchOutput2TextField = null;
    private JButton myGenerateButton = null;
    private JComboBox myAgentModeComboBox = null;
    private JButton myTrainStopButton = null;
    private JButton myResetBeansButton = null;
    private JTextField myMaximumPassesTextField = null;
    private TextListener myTextListener = null;

    private AbleNeuralClusteringAgentPanel() {
    }

    public AbleNeuralClusteringAgentPanel(AbleNeuralClusteringAgentCustomizer ableNeuralClusteringAgentCustomizer) {
        this.myCustomizer = ableNeuralClusteringAgentCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.myArchitecture = "";
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myAgent == null) {
            this.myAgent = (AbleNeuralClusteringAgent)object;
        }
        String string = this.myAgent.getDataFileName();
        if (!this.myTrainFileTextField.getText().equals(string)) {
            this.myTrainFileTextField.setText(string);
        }
        string = this.myAgent.getTestDataFileName();
        if (!this.myTestFileTextField.getText().equals(string)) {
            this.myTestFileTextField.setText(string);
        }
        this.getArchitecture(this.myAgent.getNetArchitecture());
        int n = this.myAgent.getMode();
        if (this.myAgentModeComboBox.getSelectedIndex() != n) {
            this.myAgentModeComboBox.setSelectedIndex(n);
        }
        this.myMaximumPassesTextField.setText(String.valueOf(this.myAgent.getMaxNumPasses()));
        this.setButtonStates();
    }

    private void getArchitecture(String string) {
        if (string != null) {
            this.myArchitecture = string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.myArchitecture);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    this.myArchInputTextField.setText(string2);
                    break;
                }
                case 1: {
                    this.myArchOutput1TextField.setText(string2);
                    break;
                }
                case 2: {
                    this.myArchOutput2TextField.setText(string2);
                    break;
                }
            }
            ++n;
        }
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myAgent.setDataFileName(this.myTrainFileTextField.getText().trim());
            this.myAgent.setTestDataFileName(this.myTestFileTextField.getText().trim());
            String string = this.readArchitecture();
            if (!string.equals(this.myArchitecture)) {
                this.myAgent.setNumRows(Integer.parseInt(this.myArchOutput1TextField.getText().trim()));
                this.myAgent.setNumCols(Integer.parseInt(this.myArchOutput2TextField.getText().trim()));
                this.myArchitecture = string;
            }
            this.myAgent.setMode(this.myAgentModeComboBox.getSelectedIndex());
            this.myAgent.setMaxNumPasses(Integer.parseInt(this.myMaximumPassesTextField.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Neural Clustering panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Neural Clustering panel.\n" + nullPointerException.toString());
        }
    }

    private String readArchitecture() throws NumberFormatException {
        String string = null;
        Integer.parseInt(this.myArchOutput1TextField.getText().trim());
        Integer.parseInt(this.myArchOutput2TextField.getText().trim());
        string = this.myArchInputTextField.getText().trim() + " " + this.myArchOutput1TextField.getText().trim() + " " + this.myArchOutput2TextField.getText().trim();
        return string;
    }

    private void initializePanel() {
        int n = 10;
        int n2 = 40;
        int n3 = 50;
        int n4 = 100;
        AblePanelHelper.addLabel(this, 20, n, 150, "Training File Name:");
        this.myTrainFileTextField = AblePanelHelper.addTextField(this, 170, n, 220);
        this.myTrainFileTextField.setToolTipText("Definition file which provides the record layout and data type");
        this.myTextListener = new TextListener();
        this.myTrainFileTextField.getDocument().addDocumentListener(this.myTextListener);
        AblePanelHelper.addButton(this, 400, n, 100, "Browse...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = AblePanelHelper.setTextFieldFromFileDialog(AbleNeuralClusteringAgentPanel.this.myTrainFileTextField, "Definition File (*.dfn)", "dfn", AbleNeuralClusteringAgentPanel.this.myCustomizer.getWorkingDirectory());
                if (string != null) {
                    AbleNeuralClusteringAgentPanel.this.myCustomizer.setWorkingDirectory(string);
                }
            }
        }, "Select a definition file for constructing beans and training");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Testing File Name:");
        this.myTestFileTextField = AblePanelHelper.addTextField(this, 170, n, 220);
        this.myTestFileTextField.setToolTipText("Definition file which provides the record layout and data type");
        this.myTestFileTextField.getDocument().addDocumentListener(this.myTextListener);
        AblePanelHelper.addButton(this, 400, n, 100, "Browse...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = AblePanelHelper.setTextFieldFromFileDialog(AbleNeuralClusteringAgentPanel.this.myTestFileTextField, "Definition File (*.dfn)", "dfn", AbleNeuralClusteringAgentPanel.this.myCustomizer.getWorkingDirectory());
                if (string != null) {
                    AbleNeuralClusteringAgentPanel.this.myCustomizer.setWorkingDirectory(string);
                }
            }
        }, "Select a definition file to test a trained network");
        AblePanelHelper.addLabel(this, 20, n += n2, 150, "Agent Mode:");
        this.myAgentModeComboBox = AblePanelHelper.addComboBox(this, 170, n, 100);
        for (int i = 0; i < AbleNetwork.MODE_NAMES.length; ++i) {
            this.myAgentModeComboBox.addItem(AbleNetwork.MODE_NAMES[i]);
        }
        this.myAgentModeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AbleNeuralClusteringAgentPanel.this.setButtonStates();
            }
        });
        n3 = 170;
        AblePanelHelper.addLabel(this, 170, n += n2, n4, "Inputs");
        AblePanelHelper.addLabel(this, n3 += n4, n, n4, "Output Rows");
        AblePanelHelper.addLabel(this, n3 += n4, n, n4, "Columns");
        AblePanelHelper.addLabel(this, 20, n += 20, 150, "Network Architecture:");
        n3 = 170;
        this.myArchInputTextField = AblePanelHelper.addTextField(this, 170, n, n4 - 10);
        this.myArchInputTextField.setEnabled(false);
        this.myArchInputTextField.setToolTipText("Number of inputs");
        this.myArchOutput1TextField = AblePanelHelper.addTextField(this, n3 += n4, n, n4 - 10);
        this.myArchOutput1TextField.setToolTipText("Number of row outputs");
        this.myArchOutput2TextField = AblePanelHelper.addTextField(this, n3 += n4, n, n4 - 10);
        this.myArchOutput2TextField.setToolTipText("Number of column outputs");
        this.myGenerateButton = AblePanelHelper.addButton(this, 190, n += n2, 180, "Generate Beans", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleNeuralClusteringAgentPanel.this.GenerateButton_actionPerformed(actionEvent);
            }
        }, "Create beans from training data");
        AblePanelHelper.addLabel(this, 20, n += n2, 170, "Maximum Passes:");
        this.myMaximumPassesTextField = AblePanelHelper.addTextField(this, 200, n, 50);
        this.myTrainStopButton = AblePanelHelper.addButton(this, 100, n += n2, 140, "Start", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleNeuralClusteringAgentPanel.this.TrainButton_actionPerformed(actionEvent);
            }
        }, "Train/Test/Run the agent");
        this.myResetBeansButton = AblePanelHelper.addButton(this, 290, n, 140, "Reset Beans", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleNeuralClusteringAgentPanel.this.ResetButton_actionPerformed(actionEvent);
            }
        }, "Reset all agent beans");
    }

    private void addPropertyListeners() {
        this.myCustomizer.addPropertyChangeMethod("training", this, "refreshPanel");
    }

    private void setButtonStates() {
        try {
            boolean bl = this.myAgent.isTraining();
            this.setTrainingStopButton(bl);
            boolean bl2 = this.myTrainFileTextField.getText().trim().length() > 0;
            boolean bl3 = this.myTestFileTextField.getText().trim().length() > 0;
            boolean bl4 = this.isGenerated();
            this.myGenerateButton.setEnabled(bl2);
            if (this.myAgentModeComboBox.getSelectedIndex() == 0) {
                this.myTrainStopButton.setEnabled(bl2 && bl4);
            } else if (this.myAgentModeComboBox.getSelectedIndex() == 1) {
                this.myTrainStopButton.setEnabled(bl3 && bl4);
            } else {
                this.myTrainStopButton.setEnabled(false);
            }
            this.myResetBeansButton.setEnabled(!bl && bl4);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setTrainingStopButton(boolean bl) {
        if (bl) {
            this.myTrainStopButton.setText("Stop");
            this.myTrainStopButton.setToolTipText("Stop processing data from the agent's import bean");
        } else {
            this.myTrainStopButton.setText("Start");
            this.myTrainStopButton.setToolTipText("Start processing data from the agent's import bean");
        }
    }

    private boolean isGenerated() throws RemoteException {
        return this.myAgent != null && this.myAgent.getBeans() != null && this.myAgent.getBeans().size() >= 4;
    }

    void GenerateButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myAgent.getBeans() != null && this.myAgent.getBeans().size() > 0 && 1 == JOptionPane.showConfirmDialog(this, "This will erase existing beans and regenerate them.\nInspector property changes and inspectors themselves will need to be recreated.\n\nAre you sure you want to do this?", "Regenerate Beans", 0)) {
                return;
            }
            this.myCustomizer.updateProperties();
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myAgent.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleNeuralClusteringAgentPanel Error: GenerateButton()", 0);
        }
    }

    void TrainButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myTrainStopButton.getText().startsWith("Stop")) {
                this.myAgent.stopTraining();
            } else {
                this.myCustomizer.updateProperties();
                this.myAgent.startTraining();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleNeuralClusteringAgentPanel Error: TrainButton()", 2);
        }
    }

    void ResetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.updateProperties();
            this.myAgent.reset();
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleNeuralClusteringAgentPanel Error: ResetButton()", 0);
        }
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.getDataFromBean(this.myAgent);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this.myCustomizer, "Panel values for training changed, but were not updated.\n" + remoteException.toString(), "AbleNeuralClusteringAgentPanel Warning: refreshPanel()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "agents/doc-files/AbleNeuralClusteringAgentHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class TextListener
    implements DocumentListener {
        TextListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AbleNeuralClusteringAgentPanel.this.setButtonStates();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbleNeuralClusteringAgentPanel.this.setButtonStates();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbleNeuralClusteringAgentPanel.this.setButtonStates();
        }
    }
}

