/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able.agents;

import com.ibm.able.Able;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleHelp;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.agents.AbleGeneticOperatorsDialog;
import com.ibm.able.agents.AbleGeneticSearchAgent;
import com.ibm.able.agents.AbleGeneticSearchAgentCustomizer;
import com.ibm.able.beans.AbleGeneticObject;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AbleGeneticSearchAgentPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleGeneticSearchAgent myAgent = null;
    private AbleGeneticSearchAgentCustomizer myCustomizer = null;
    private Hashtable operatorFitness = null;
    private JTextField myClassNameTextField = null;
    private JTextField myPopulationSizeTextField = null;
    private JTextField myReplacementSizeTextField = null;
    private JCheckBox myNoDuplicatesCheckBox = null;
    private JTextField myMaximumPassesTextField = null;
    private JTextField myFitnessThresholdTextField = null;
    private JCheckBox myNormalizedFitnessCheckBox = null;
    private JList myGeneticOperatorsList = null;
    private JTextField myCrossoverRateTextField = null;
    private JTextField myMutationRateTextField = null;
    private JButton myInitializeButton = null;
    private JButton myEvolveStopButton = null;
    private JButton myResetBeansButton = null;
    private TextListener myTextListener = null;

    private AbleGeneticSearchAgentPanel() {
    }

    public AbleGeneticSearchAgentPanel(AbleGeneticSearchAgentCustomizer ableGeneticSearchAgentCustomizer) {
        this.myCustomizer = ableGeneticSearchAgentCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myAgent == null) {
            this.myAgent = (AbleGeneticSearchAgent)object;
        }
        String string = new String(this.myAgent.getGeneticObjectClassName());
        if (!this.myClassNameTextField.getText().equals(string)) {
            this.myClassNameTextField.setText(string);
        }
        this.myPopulationSizeTextField.setText(String.valueOf(this.myAgent.getPopulationSize()));
        this.myNoDuplicatesCheckBox.setSelected(this.myAgent.isNoDuplicatesAllowed());
        this.myReplacementSizeTextField.setText(String.valueOf(this.myAgent.getReplacementSize()));
        this.myNormalizedFitnessCheckBox.setSelected(this.myAgent.isUseNormalizedFitness());
        this.myMaximumPassesTextField.setText(String.valueOf(this.myAgent.getMaxNumPasses()));
        this.myFitnessThresholdTextField.setText(String.valueOf(this.myAgent.getFitnessThreshold()));
        this.myCrossoverRateTextField.setText(String.valueOf(this.myAgent.getCrossoverRate()));
        this.myMutationRateTextField.setText(String.valueOf(this.myAgent.getMutationRate()));
        this.getOperatorFitness();
        this.setButtonStates();
    }

    private void getOperatorFitness() throws RemoteException {
        try {
            String string = this.myClassNameTextField.getText().trim();
            this.operatorFitness = this.myAgent.getOperatorFitness();
            if (string.length() > 0 && this.operatorFitness == null) {
                Class<?> clazz = Class.forName(string);
                AbleGeneticObject ableGeneticObject = (AbleGeneticObject)clazz.newInstance();
                this.operatorFitness = ableGeneticObject.getOperatorFitness();
                this.myAgent.setOperatorFitness(this.operatorFitness);
            }
            this.refreshList(this.operatorFitness);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RemoteException(classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new RemoteException(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RemoteException(illegalAccessException.toString());
        }
    }

    private void refreshList(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Double d = (Double)hashtable.get(string);
            String string2 = string + " :" + d;
            vector.addElement(string2);
        }
        this.myGeneticOperatorsList.setListData(vector);
    }

    public void setDataOnBean() throws RemoteException {
        try {
            this.myAgent.setGeneticObjectClassName(this.myClassNameTextField.getText().trim());
            this.myAgent.setPopulationSize(Integer.parseInt(this.myPopulationSizeTextField.getText().trim()));
            this.myAgent.setReplacementSize(Integer.parseInt(this.myReplacementSizeTextField.getText().trim()));
            this.myAgent.setNoDuplicatesAllowed(this.myNoDuplicatesCheckBox.isSelected());
            Double d = new Double(this.myFitnessThresholdTextField.getText().trim());
            this.myAgent.setFitnessThreshold(d.doubleValue());
            this.myAgent.setUseNormalizedFitness(this.myNormalizedFitnessCheckBox.isSelected());
            this.myAgent.setMaxNumPasses(Integer.parseInt(this.myMaximumPassesTextField.getText().trim()));
            this.myAgent.setOperatorFitness(this.operatorFitness);
            d = new Double(this.myCrossoverRateTextField.getText().trim());
            this.myAgent.setCrossoverRate(d.doubleValue());
            d = new Double(this.myMutationRateTextField.getText().trim());
            this.myAgent.setMutationRate(d.doubleValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on Genetic panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on Genetic panel.\n" + nullPointerException.toString());
        }
    }

    private void initializePanel() {
        int n = -25;
        int n2 = 30;
        AblePanelHelper.addLabel(this, 20, n += n2, 130, "Class Name:");
        this.myClassNameTextField = AblePanelHelper.addTextField(this, 160, n, 250);
        this.myClassNameTextField.setText("");
        this.myClassNameTextField.setToolTipText("AbleGeneticObject extension in com.company.application.package.class format");
        this.myTextListener = new TextListener();
        this.myClassNameTextField.getDocument().addDocumentListener(this.myTextListener);
        AblePanelHelper.addLabel(this, 20, n += n2, 130, "Population Size:");
        this.myPopulationSizeTextField = AblePanelHelper.addTextField(this, 160, n, 75);
        this.myNoDuplicatesCheckBox = AblePanelHelper.addCheckBox(this, 260, n, "No duplicates");
        AblePanelHelper.addLabel(this, 20, n += n2, 130, "Replacement Size:");
        this.myReplacementSizeTextField = AblePanelHelper.addTextField(this, 160, n, 75);
        this.myNormalizedFitnessCheckBox = AblePanelHelper.addCheckBox(this, 260, n, "Normalized fitness");
        AblePanelHelper.addLabel(this, 20, n += n2, 130, "Maximum Passes:");
        this.myMaximumPassesTextField = AblePanelHelper.addTextField(this, 160, n, 75);
        AblePanelHelper.addLabel(this, 20, n += n2, 130, "Fitness Threshold:");
        this.myFitnessThresholdTextField = AblePanelHelper.addTextField(this, 160, n, 75);
        this.myInitializeButton = AblePanelHelper.addButton(this, 260, n, 140, "Initialize", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleGeneticSearchAgentPanel.this.initializeButton_actionPerformed(actionEvent);
            }
        }, "Initialize the population");
        AblePanelHelper.addLabel(this, 20, n += n2, 300, "Genetic Operators and Fitness Values:");
        this.myGeneticOperatorsList = AblePanelHelper.addList(this, 20, n += 20, 390, 100, 0);
        this.myGeneticOperatorsList.setToolTipText("Operator fitness should total 100.0");
        AblePanelHelper.addButton(this, 420, n + 40, 90, "Edit...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleGeneticSearchAgentPanel.this.operatorsButton_actionPerformed(actionEvent);
            }
        }, "Edit the genetic operators list");
        JLabel jLabel = AblePanelHelper.addLabel(this, 20, n += 110, 130, "Crossover Rate:");
        jLabel.setHorizontalAlignment(4);
        this.myCrossoverRateTextField = AblePanelHelper.addTextField(this, 155, n, 75);
        JLabel jLabel2 = AblePanelHelper.addLabel(this, 235, n, 130, "Mutation Rate:");
        jLabel2.setHorizontalAlignment(4);
        this.myMutationRateTextField = AblePanelHelper.addTextField(this, 370, n, 75);
        this.myEvolveStopButton = AblePanelHelper.addButton(this, 100, n += n2, 140, "Start Evolving", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleGeneticSearchAgentPanel.this.evolveButton_actionPerformed(actionEvent);
            }
        }, "Start evolving the population");
        this.myResetBeansButton = AblePanelHelper.addButton(this, 290, n, 140, "Reset Beans", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleGeneticSearchAgentPanel.this.resetButton_actionPerformed(actionEvent);
            }
        }, "Reset all agent beans");
    }

    private void addPropertyListeners() {
        this.myCustomizer.addPropertyChangeMethod("training", this, "refreshPanel");
    }

    private void setButtonStates() {
        try {
            boolean bl = this.myAgent.isEvolving();
            this.setEvolvingStopButton(bl);
            boolean bl2 = this.myClassNameTextField.getText().trim().length() > 0;
            boolean bl3 = this.isInitialized();
            this.myInitializeButton.setEnabled(bl2);
            this.myEvolveStopButton.setEnabled(bl2 && bl3);
            this.myResetBeansButton.setEnabled(!bl && bl3);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setEvolvingStopButton(boolean bl) {
        if (bl) {
            this.myEvolveStopButton.setText("Stop Evolving");
            this.myEvolveStopButton.setToolTipText("Stop evolving the population");
        } else {
            this.myEvolveStopButton.setText("Start Evolving");
            this.myEvolveStopButton.setToolTipText("Start evolving the population");
        }
    }

    private boolean isInitialized() throws RemoteException {
        return this.myAgent != null && this.myAgent.getPopulation() != null;
    }

    private void initializeButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myEvolveStopButton.getText().startsWith("Stop")) {
                this.myAgent.stopEvolving();
            }
            if (this.myAgent.getBeans() != null && this.myAgent.getBeans().size() > 0 && 1 == JOptionPane.showConfirmDialog(this, "This will erase existing beans and regenerate them.\nInspector property changes and inspectors themselves will need to be recreated.\n\nAre you sure you want to do this?", "Regenerate Beans", 0)) {
                return;
            }
            this.myCustomizer.updateProperties();
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            this.myAgent.init();
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleGeneticSearchAgentPanel Error: initializeButton()", 2);
        }
    }

    void evolveButton_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.myEvolveStopButton.getText().startsWith("Stop")) {
                this.myAgent.stopEvolving();
            } else {
                this.myCustomizer.updateProperties();
                this.myAgent.startEvolving();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleGeneticSearchAgentPanel Error: evolveButton()", 2);
        }
    }

    private void resetButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.updateProperties();
            this.myAgent.reset();
            this.myCustomizer.setObject(this.myAgent);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleGeneticSearchAgentPanel Error: ResetButton()", 0);
        }
    }

    void operatorsButton_actionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = new JFrame();
        AbleGeneticOperatorsDialog ableGeneticOperatorsDialog = new AbleGeneticOperatorsDialog(jFrame, "Select Genetic Operators", true, this.operatorFitness);
        Point point = this.getLocation();
        ableGeneticOperatorsDialog.setLocation(point.x + 100, point.y + 100);
        ableGeneticOperatorsDialog.setVisible(true);
        if (!ableGeneticOperatorsDialog.userCancelled()) {
            this.operatorFitness = ableGeneticOperatorsDialog.getData();
            this.refreshList(this.operatorFitness);
        }
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.getDataFromBean(this.myAgent);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this.myCustomizer, "Panel values for evolving changed, but were not updated.\n" + remoteException.toString(), "AbleGeneticSearchAgentPanel Warning: refreshPanel()", 2);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "agents/doc-files/AbleGeneticSearchAgentHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class TextListener
    implements DocumentListener {
        TextListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            AbleGeneticSearchAgentPanel.this.setButtonStates();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AbleGeneticSearchAgentPanel.this.setButtonStates();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AbleGeneticSearchAgentPanel.this.setButtonStates();
        }
    }
}

