/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBeanContainer;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleDefaultAgentCustomizer;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObject;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.AbleUserDefinedFunction;
import com.ibm.able.AbleUserDefinedFunctionManager;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AbleUserDefinedFunctionPanel
extends JPanel
implements AbleCustomizerPanel {
    private static final String NoneSelected = "<none selected>";
    private Hashtable myBeanMethodHashtable = new Hashtable();
    private AbleObject myAbleObject = null;
    private AbleDefaultAgentCustomizer myCustomizer = null;
    private JTextField myNameTextField = null;
    private JComboBox myBeanComboBox = null;
    private JComboBox myMethodComboBox = null;
    private JList myUDFList = null;
    private JButton myAddButton = null;
    private JButton myChangeButton = null;
    private JButton myRemoveButton = null;
    private Hashtable myMethodHashTable = null;
    private Hashtable myUDFHashTable = null;
    private Vector myBeanVector = null;
    private boolean myListenersEnabled = false;

    private AbleUserDefinedFunctionPanel() {
    }

    public AbleUserDefinedFunctionPanel(AbleDefaultAgentCustomizer ableDefaultAgentCustomizer) {
        this.myCustomizer = ableDefaultAgentCustomizer;
        this.myBeanVector = new Vector();
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
        this.addPropertyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDataFromBean(Object object) throws RemoteException {
        if (this.myAbleObject == null) {
            this.myAbleObject = (AbleObject)object;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setListenersEnabled(false);
        try {
            this.myNameTextField.setText(" ");
            this.myUDFHashTable = new Hashtable();
            this.myBeanComboBox.removeAllItems();
            this.myMethodComboBox.removeAllItems();
            Vector vector = ((AbleBeanContainer)this.myAbleObject).getBeans();
            vector.insertElementAt(NoneSelected, 0);
            vector.insertElementAt(this.myAbleObject, 1);
            this.setBeans(vector);
            this.myUDFHashTable = ((AbleUserDefinedFunctionManager)this.myAbleObject).getUserDefinedFunctions();
            this.setList();
        }
        finally {
            this.setListenersEnabled(true);
            this.setButtonStates();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setDataOnBean() throws RemoteException {
        ((AbleUserDefinedFunctionManager)this.myAbleObject).setUserDefinedFunctions(this.myUDFHashTable);
    }

    private void initializePanel() {
        int n = 15;
        int n2 = 40;
        AblePanelHelper.addLabel(this, 20, n, 75, "Name:");
        this.myNameTextField = AblePanelHelper.addTextField(this, 100, n, 250);
        this.myNameTextField.getDocument().addDocumentListener(new TextListener());
        this.myNameTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleUserDefinedFunctionPanel.this.nameTextField_actionPerformed(actionEvent);
            }
        });
        this.myNameTextField.setToolTipText("Enter a unique name to assign to the function");
        AblePanelHelper.addLabel(this, 20, n += n2, 75, "Bean:");
        this.myBeanComboBox = AblePanelHelper.addComboBox(this, 100, n, 250);
        this.myBeanComboBox.setEnabled(false);
        this.myBeanComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AbleUserDefinedFunctionPanel.this.beanComboBox_itemStateChanged(itemEvent);
            }
        });
        AblePanelHelper.addLabel(this, 20, n += n2, 75, "Method:");
        this.myMethodComboBox = AblePanelHelper.addComboBox(this, 100, n, 400);
        this.myMethodComboBox.setEnabled(this.myBeanComboBox.isEnabled());
        this.myMethodComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AbleUserDefinedFunctionPanel.this.methodComboBox_itemStateChanged(itemEvent);
            }
        });
        AblePanelHelper.addLabel(this, 20, n += n2, 500, "Select an existing Name, Bean, and Method to change or remove.");
        this.myUDFList = AblePanelHelper.addList(this, 20, n += 20, 370, 350 - n - 10, 0);
        this.myAddButton = AblePanelHelper.addButton(this, 410, n, 100, "Add", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleUserDefinedFunctionPanel.this.addButton_actionPerformed(actionEvent);
            }
        }, "Add a new function");
        this.myChangeButton = AblePanelHelper.addButton(this, 410, n += 40, 100, "Change", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleUserDefinedFunctionPanel.this.changeButton_actionPerformed(actionEvent);
            }
        }, "Change the selected function");
        this.myRemoveButton = AblePanelHelper.addButton(this, 410, n += 40, 100, "Remove", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleUserDefinedFunctionPanel.this.removeButton_actionPerformed(actionEvent);
            }
        }, "Remove the selected function");
        this.myUDFList.getSelectionModel().addListSelectionListener(new ListSelectionHandler());
    }

    private void addPropertyListeners() {
        if (this.myCustomizer != null) {
            this.myCustomizer.addPropertyChangeMethod("beans", this, "refreshPanel");
            this.myCustomizer.addPropertyChangeMethod("userDefinedFunction", this, "refreshPanel");
        }
    }

    public void refreshPanel(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        this.setListenersEnabled(false);
        if (propertyChangeEvent.getPropertyName().equals("beans")) {
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if (object2 == null && object instanceof AbleBean) {
                this.setBean((AbleBean)object);
            } else if (object2 instanceof AbleBean && object == null) {
                this.removeBean((AbleBean)object2);
            } else {
                this.getDataFromBean(this.myAbleObject);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("userDefinedFunction")) {
            this.getDataFromBean(this.myAbleObject);
        }
        this.setButtonStates();
        this.setListenersEnabled(true);
    }

    private void setBeans(Vector vector) {
        this.myBeanVector = vector;
        try {
            for (int i = 0; i < this.myBeanVector.size(); ++i) {
                Object e = this.myBeanVector.elementAt(i);
                if (e instanceof AbleBean) {
                    this.myBeanComboBox.addItem(((AbleBean)e).getName());
                    continue;
                }
                this.myBeanComboBox.addItem(e);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "AbleUserDefinedFunctionPanel Error: setBeans()", 0);
        }
    }

    private void setBean(AbleBean ableBean) throws RemoteException {
        this.myBeanVector.addElement(ableBean);
        this.myBeanComboBox.addItem(ableBean.getName());
    }

    private void setMethods(Object object) {
        String string = "";
        if (!(object instanceof AbleBean)) {
            this.myMethodComboBox.removeAllItems();
            return;
        }
        AbleBean ableBean = (AbleBean)object;
        string = ableBean.getName();
        if (!this.myBeanMethodHashtable.containsKey(string)) {
            Method[] methodArray = object.getClass().getMethods();
            String[] stringArray = new String[methodArray.length];
            Hashtable<String, Method> hashtable = new Hashtable<String, Method>();
            for (int i = 0; i < methodArray.length; ++i) {
                stringArray[i] = this.cleanupMethod(methodArray[i].toString());
                hashtable.put(stringArray[i], methodArray[i]);
            }
            this.myBeanMethodHashtable.put(string, hashtable);
            this.setMethodComboBox(hashtable);
        } else {
            Hashtable hashtable = (Hashtable)this.myBeanMethodHashtable.get(string);
            this.setMethodComboBox(hashtable);
        }
    }

    private void setMethodComboBox(Hashtable hashtable) {
        this.myMethodHashTable = hashtable;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.myMethodHashTable.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        this.myMethodComboBox.setModel(new DefaultComboBoxModel(vector));
    }

    private void setList() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.myUDFHashTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.myUDFHashTable.get(string);
            vector.addElement(v.toString());
        }
        this.myUDFList.setListData(vector);
        this.myUDFList.repaint();
    }

    private void removeBean(AbleBean ableBean) throws RemoteException {
        String string = ableBean.getName();
        for (int i = 0; i < this.myBeanVector.size(); ++i) {
            Object e = this.myBeanVector.elementAt(i);
            if (!(e instanceof AbleBean) || !((AbleBean)e).getName().equals(string)) continue;
            this.myBeanVector.removeElementAt(i);
            boolean bl = this.myBeanComboBox.getSelectedItem().equals(string);
            this.myBeanComboBox.removeItem(string);
            if (!bl) continue;
            if (this.myBeanVector.size() >= 1) {
                this.setMethods(this.myBeanVector.elementAt(0));
                continue;
            }
            this.myMethodComboBox.removeAllItems();
        }
    }

    private void nameTextField_actionPerformed(ActionEvent actionEvent) {
        this.setButtonStates();
    }

    private void addButton_actionPerformed(ActionEvent actionEvent) {
        String string = this.myNameTextField.getText().trim();
        AbleBean ableBean = (AbleBean)this.myBeanVector.elementAt(this.myBeanComboBox.getSelectedIndex());
        String string2 = (String)this.myMethodComboBox.getSelectedItem();
        AbleUserDefinedFunction ableUserDefinedFunction = new AbleUserDefinedFunction(string, (Object)ableBean, (Method)this.myMethodHashTable.get(string2));
        this.myUDFHashTable.put(string, ableUserDefinedFunction);
        this.setListenersEnabled(false);
        this.setList();
        this.myUDFList.setSelectedValue(ableUserDefinedFunction.toString(), true);
        this.setButtonStates();
        this.setListenersEnabled(true);
    }

    private void changeButton_actionPerformed(ActionEvent actionEvent) {
        String string = this.myNameTextField.getText().trim();
        if (this.myUDFHashTable.containsKey(string)) {
            this.myUDFHashTable.remove(string);
            this.addButton_actionPerformed(actionEvent);
            this.myChangeButton.requestFocus();
        }
    }

    private void removeButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.myUDFList.getSelectedIndex();
        if (n != -1) {
            String string = (String)this.myUDFList.getSelectedValue();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.myUDFHashTable.remove(stringTokenizer.nextToken());
            this.setListenersEnabled(false);
            this.setList();
            this.setListenersEnabled(true);
            int n2 = this.myUDFList.getModel().getSize();
            if (n2 != 0) {
                this.myUDFList.setSelectedIndex(n <= n2 - 1 ? n : n2 - 1);
            }
            this.setButtonStates();
            if (this.myRemoveButton.isEnabled()) {
                this.myRemoveButton.requestFocus();
            }
        }
    }

    private void beanComboBox_itemStateChanged(ItemEvent itemEvent) {
        if (!this.myListenersEnabled) {
            return;
        }
        if (itemEvent.getStateChange() == 1 && this.myBeanComboBox.isEnabled()) {
            int n = this.myBeanComboBox.getSelectedIndex();
            if (n != -1) {
                this.setMethods(this.myBeanVector.elementAt(n));
            }
            this.setButtonStates();
        }
    }

    private void methodComboBox_itemStateChanged(ItemEvent itemEvent) {
        if (!this.myListenersEnabled) {
            return;
        }
        if (itemEvent.getStateChange() == 1 && this.myMethodComboBox.isEnabled()) {
            this.setButtonStates();
        }
    }

    private void methodComboBox_actionPerformed(ActionEvent actionEvent) {
        if (!this.myListenersEnabled) {
            return;
        }
        this.setButtonStates();
    }

    private void setButtonStates() {
        boolean bl = this.myUDFList.getSelectedIndex() != -1;
        boolean bl2 = this.myBeanComboBox.getSelectedIndex() > 0;
        boolean bl3 = this.myMethodComboBox.getSelectedIndex() != -1;
        String string = this.myNameTextField.getText().trim();
        this.myBeanComboBox.setEnabled(string.length() > 0);
        this.myMethodComboBox.setEnabled(this.myBeanComboBox.isEnabled());
        this.myRemoveButton.setEnabled(bl);
        this.myChangeButton.setEnabled(bl && bl2 && bl3 && string.length() > 0 && this.myUDFHashTable.containsKey(string));
        if (string.length() == 0) {
            this.myAddButton.setEnabled(false);
        } else if (this.myUDFHashTable.containsKey(string)) {
            this.myAddButton.setEnabled(false);
        } else {
            this.myAddButton.setEnabled(bl2 && bl3);
        }
    }

    private String cleanupMethod(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer("");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            int n = string2.indexOf(40);
            if (n != -1) {
                String string3 = string2.substring(0, n + 1);
                String string4 = string2.substring(n + 1);
                n = string3.lastIndexOf(46);
                if (n == -1) {
                    stringBuffer.append(string3);
                } else {
                    stringBuffer.append(string3.substring(n + 1));
                }
                n = string4.lastIndexOf(46);
                if (n == -1) {
                    stringBuffer.append(string4);
                } else {
                    stringBuffer.append(string4.substring(n + 1));
                }
                stringBuffer.append(" ");
                continue;
            }
            n = string2.lastIndexOf(46);
            if (n == -1) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string2.substring(n + 1));
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString().trim();
    }

    private void setListenersEnabled(boolean bl) {
        this.myListenersEnabled = bl;
        this.myBeanComboBox.setEnabled(bl);
        this.myMethodComboBox.setEnabled(bl);
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "doc-files/AbleUserDefinedFunctionHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }

    class TextListener
    implements DocumentListener {
        TextListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (!AbleUserDefinedFunctionPanel.this.myListenersEnabled) {
                return;
            }
            AbleUserDefinedFunctionPanel.this.setButtonStates();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (!AbleUserDefinedFunctionPanel.this.myListenersEnabled) {
                return;
            }
            AbleUserDefinedFunctionPanel.this.setButtonStates();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (!AbleUserDefinedFunctionPanel.this.myListenersEnabled) {
                return;
            }
            AbleUserDefinedFunctionPanel.this.setButtonStates();
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!AbleUserDefinedFunctionPanel.this.myListenersEnabled) {
                return;
            }
            if (AbleUserDefinedFunctionPanel.this.myUDFList.getSelectedIndex() != -1 && !listSelectionEvent.getValueIsAdjusting()) {
                Object e = AbleUserDefinedFunctionPanel.this.myUDFList.getSelectedValue();
                StringTokenizer stringTokenizer = new StringTokenizer((String)e);
                AbleUserDefinedFunctionPanel.this.myNameTextField.setText(stringTokenizer.nextToken());
                AbleUserDefinedFunctionPanel.this.myBeanComboBox.setSelectedItem(stringTokenizer.nextToken());
                String string = stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    string = string + " " + stringTokenizer.nextToken();
                }
                AbleUserDefinedFunctionPanel.this.myMethodComboBox.setSelectedItem(string);
                AbleUserDefinedFunctionPanel.this.setButtonStates();
            }
        }
    }
}

