/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleDefaultAgent;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleLogger;
import com.ibm.able.AbleObject;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.AbleState;
import com.ibm.able.AbleTraceLogger;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

class AbleObjectPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleObject myAbleObject = null;
    private AbleObjectCustomizer myCustomizer = null;
    private JTextField myNameTextField = null;
    private JTextArea myCommentTextArea = null;
    private JTextField myFileNameTextField = null;
    private JLabel myStateLabel = null;
    private JCheckBox myDataFlowEnabledCheckBox = null;
    private JCheckBox myTimerEventsEnabledCheckBox = null;
    private JSpinner mySleepTimeSpinner = null;
    private JCheckBox myPostingEnabledCheckBox = null;
    private JCheckBox myProcessingEnabledCheckBox = null;
    private static Vector myTraceLogLevelLabelsVector = AbleTraceLogger.TraceLogLevelLabelsVector;
    private static Vector myTraceLogLevelValuesVector = AbleTraceLogger.TraceLogLevelValuesVector;
    private JComboBox myTraceLogConsoleLevelComboBox = null;
    private JComboBox myTraceLogFileLevelComboBox = null;
    private JTextField myTraceLogFileNameTextField = null;
    private JCheckBox myTraceLogConsoleCheckBox = null;
    private JCheckBox myTraceLogFileCheckBox = null;

    private AbleObjectPanel() {
    }

    public AbleObjectPanel(AbleObjectCustomizer ableObjectCustomizer) {
        this.myCustomizer = ableObjectCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(AbleObject ableObject) throws RemoteException {
        if (this.myAbleObject == null) {
            this.myAbleObject = ableObject;
        }
        this.setNameTextField(null);
        this.setCommentTextArea(null);
        this.setStateTextField(null);
        this.setFileNameTextField(null);
        this.setDataFlowEnabledCheckBox(null);
        this.setTimerEventProcessingEnabledCheckBox(null);
        this.setSleepTimeTextField(null);
        this.setAbleEventProcessingCheckBoxes(null);
        AbleLogger ableLogger = this.myAbleObject.getTraceLogger();
        boolean bl = false;
        long l = 0L;
        bl = false;
        if (ableLogger.isBeanLogger() && (bl = AbleTraceLogger.hasConsoleHandler((AbleLogger)ableLogger))) {
            l = ableLogger.getConsoleLogLevel();
        }
        this.myTraceLogConsoleCheckBox.setSelected(bl);
        int n = myTraceLogLevelValuesVector.indexOf(new Long(l));
        if (n >= 0) {
            this.myTraceLogConsoleLevelComboBox.setSelectedIndex(n);
        }
        bl = false;
        l = 0L;
        if (ableLogger.isBeanLogger() && (bl = AbleTraceLogger.hasFileHandler((AbleLogger)ableLogger))) {
            l = ableLogger.getFileLogLevel();
            String string = ableLogger.getFileLogFileName();
            if (string != null) {
                this.myTraceLogFileNameTextField.setText(string);
            }
        }
        this.myTraceLogFileCheckBox.setSelected(bl);
        n = myTraceLogLevelValuesVector.indexOf(new Long(l));
        if (n >= 0) {
            this.myTraceLogFileLevelComboBox.setSelectedIndex(n);
        }
    }

    public void setDataOnBean() throws RemoteException {
        boolean bl;
        String string;
        try {
            String string2;
            string = this.myNameTextField.getText().trim();
            if (string.length() == 0) {
                throw new RemoteException("Blank name provided on General panel.");
            }
            this.myAbleObject.setName(string);
            this.myAbleObject.setComment(this.myCommentTextArea.getText().trim());
            this.myAbleObject.setFileName(this.myFileNameTextField.getText());
            this.myAbleObject.setDataFlowEnabled(this.myDataFlowEnabledCheckBox.isSelected());
            this.myAbleObject.setTimerEventProcessingEnabled(this.myTimerEventsEnabledCheckBox.isSelected());
            Object object = this.mySleepTimeSpinner.getValue();
            if (object instanceof Long) {
                this.myAbleObject.setSleepTime(((Long)object).longValue());
            } else if (object instanceof Integer) {
                this.myAbleObject.setSleepTime((long)((Integer)object).intValue());
            }
            boolean bl2 = this.myPostingEnabledCheckBox.isSelected();
            bl = this.myProcessingEnabledCheckBox.isSelected();
            int n = 3;
            if (!bl && bl2) {
                n = 1;
            } else if (bl && !bl2) {
                n = 2;
            } else if (!bl && !bl2) {
                n = 0;
            }
            this.myAbleObject.setAbleEventProcessingEnabled(n);
            if (this.myTraceLogFileCheckBox.isSelected() && (string2 = this.myTraceLogFileNameTextField.getText().trim()).length() == 0) {
                throw new RemoteException("Blank trace filename provided on General panel.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("Non-numeric input provided on General panel.\n" + numberFormatException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new RemoteException("Blank input provided on General panel.\n" + nullPointerException.toString());
        }
        if (this.myTraceLogFileCheckBox.isSelected() && (string = this.myTraceLogFileNameTextField.getText().trim()).length() == 0) {
            throw new RemoteException("Blank trace filename provided on General panel.");
        }
        string = this.myAbleObject.getTraceLogger();
        if (string.isBeanLogger() && !this.myTraceLogConsoleCheckBox.isSelected() && !this.myTraceLogFileCheckBox.isSelected()) {
            Able.stopBeanTraceLogging((AbleBean)this.myAbleObject);
        } else if (this.myTraceLogConsoleCheckBox.isSelected() || this.myTraceLogFileCheckBox.isSelected()) {
            if (!string.isBeanLogger()) {
                Able.startBeanTraceLogging((AbleBean)this.myAbleObject);
                string = this.myAbleObject.getTraceLogger();
            }
            bl = this.myTraceLogConsoleCheckBox.isSelected();
            long l = (Long)myTraceLogLevelValuesVector.elementAt(this.myTraceLogConsoleLevelComboBox.getSelectedIndex());
            if (bl) {
                if (l != string.getConsoleLogLevel()) {
                    Able.addTraceConsoleHandler((AbleBean)this.myAbleObject, (long)l);
                }
            } else {
                Able.removeTraceConsoleHandler((AbleBean)this.myAbleObject);
            }
            bl = this.myTraceLogFileCheckBox.isSelected();
            l = (Long)myTraceLogLevelValuesVector.elementAt(this.myTraceLogFileLevelComboBox.getSelectedIndex());
            String string3 = this.myTraceLogFileNameTextField.getText().trim();
            if (bl) {
                if (string3.length() == 0) {
                    throw new RemoteException("Blank trace log filename provided on General panel.");
                }
                Able.addTraceFileHandler((AbleBean)this.myAbleObject, (long)l, (String)string3);
            } else {
                Able.removeTraceFileHandler((AbleBean)this.myAbleObject);
            }
        }
    }

    private void initializePanel() {
        int n = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getNamePanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 5, 10), 0, 0));
        this.add(this.getProcessingOptionsPanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 5, 10), 0, 0));
        this.add(this.getProcessingActionsPanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 5, 10), 0, 0));
        this.add(this.getLoggingOptionsPanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 10, 10), 0, 0));
    }

    private Component getLoggingOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Bean tracing values"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        this.myTraceLogFileCheckBox = new JCheckBox("File");
        jPanel.add((Component)this.myTraceLogFileCheckBox, new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 2, 0), 0, 0));
        this.myTraceLogFileLevelComboBox = new JComboBox(myTraceLogLevelLabelsVector);
        this.myTraceLogFileLevelComboBox.setToolTipText("Trace log file level");
        jPanel.add((Component)this.myTraceLogFileLevelComboBox, new AbleGridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 2, 0), 0, 0));
        this.myTraceLogFileNameTextField = new JTextField();
        jPanel.add((Component)this.myTraceLogFileNameTextField, new AbleGridBagConstraints(2, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 2, 0), 0, 0));
        JButton jButton = new JButton("Browse...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleObjectPanel.this.BrowseButton2_actionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText("Select a file to store trace output");
        jPanel.add((Component)jButton, new AbleGridBagConstraints(3, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 2, 10), 0, 0));
        this.myTraceLogConsoleCheckBox = new JCheckBox("Console");
        jPanel.add((Component)this.myTraceLogConsoleCheckBox, new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 2, 0), 0, 0));
        this.myTraceLogConsoleLevelComboBox = new JComboBox(myTraceLogLevelLabelsVector);
        this.myTraceLogConsoleLevelComboBox.setToolTipText("Trace log console level");
        jPanel.add((Component)this.myTraceLogConsoleLevelComboBox, new AbleGridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 2, 0), 0, 0));
        return jPanel;
    }

    private Component getProcessingActionsPanel() {
        JPanel jPanel = new JPanel();
        int n = 0;
        this.myStateLabel = new JLabel("State: " + AbleState.State((int)1020));
        jPanel.add((Component)this.myStateLabel, new AbleGridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        JButton jButton = new JButton("Init");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleObjectPanel.this.initButton_actionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText("Call the init() method");
        jPanel.add((Component)jButton, new AbleGridBagConstraints(0, n++, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleObjectPanel.this.button_actionPerformed(actionEvent);
            }
        };
        JButton jButton2 = new JButton("Reset");
        jButton2.addActionListener(actionListener);
        jButton2.setToolTipText("Call the reset() method");
        jPanel.add((Component)jButton2, new AbleGridBagConstraints(0, n++, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        JButton jButton3 = new JButton("Suspend");
        jButton3.addActionListener(actionListener);
        jButton3.setToolTipText("Call the suspendAll() method");
        jPanel.add((Component)jButton3, new AbleGridBagConstraints(0, n++, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        JButton jButton4 = new JButton("Resume");
        jButton4.addActionListener(actionListener);
        jButton4.setToolTipText("Call the resumeAll() method");
        jPanel.add((Component)jButton4, new AbleGridBagConstraints(0, n++, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        JButton jButton5 = new JButton("Quit...");
        jButton5.addActionListener(actionListener);
        jButton5.setToolTipText("Call the quitAll() method");
        jPanel.add((Component)jButton5, new AbleGridBagConstraints(0, n++, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        return jPanel;
    }

    private Component getProcessingOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Bean processing settings"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        this.myDataFlowEnabledCheckBox = new JCheckBox("Data flow");
        jPanel.add((Component)this.myDataFlowEnabledCheckBox, new AbleGridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.myTimerEventsEnabledCheckBox = new JCheckBox("Timer events");
        jPanel.add((Component)this.myTimerEventsEnabledCheckBox, new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setStepSize(new Long(500L));
        spinnerNumberModel.setMinimum(new Integer(0));
        this.mySleepTimeSpinner = new JSpinner(spinnerNumberModel);
        jPanel.add((Component)this.mySleepTimeSpinner, new AbleGridBagConstraints(1, n, 1, 1, 0.2, 0.0, 17, 2, new Insets(0, 0, 5, 10), 0, 0));
        jPanel.add((Component)new JLabel("interval, milliseconds"), new AbleGridBagConstraints(2, n++, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.myPostingEnabledCheckBox = new JCheckBox("Asynchronous event posting");
        jPanel.add((Component)this.myPostingEnabledCheckBox, new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.myProcessingEnabledCheckBox = new JCheckBox("Asynchronous event processing");
        jPanel.add((Component)this.myProcessingEnabledCheckBox, new AbleGridBagConstraints(1, n, 2, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        return jPanel;
    }

    private Component getNamePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        this.myNameTextField = new JTextField();
        jPanel.add((Component)new JLabel("Name:"), new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel.add((Component)this.myNameTextField, new AbleGridBagConstraints(1, n, 2, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 10, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        this.myCommentTextArea = AblePanelHelper.addTextArea(jPanel2, -1, 2, null);
        jPanel.add((Component)new JLabel("Comment:"), new AbleGridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel.add((Component)jPanel2, new AbleGridBagConstraints(1, n, 2, 2, 0.5, 0.5, 17, 1, new Insets(0, 10, 10, 0), 0, 0));
        this.myFileNameTextField = new JTextField();
        jPanel.add((Component)new JLabel("Serialized file name:"), new AbleGridBagConstraints(0, n += 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        jPanel.add((Component)this.myFileNameTextField, new AbleGridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 10, 10, 0), 0, 0));
        JButton jButton = new JButton("Browse...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleObjectPanel.this.BrowseButton_actionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText("Select a file for saving the agent");
        jPanel.add((Component)jButton, new AbleGridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 0), 0, 0));
        return jPanel;
    }

    public void setNameTextField(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        this.myNameTextField.setText(this.myAbleObject.getName().trim());
    }

    public void setCommentTextArea(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        this.myCommentTextArea.setText(this.myAbleObject.getComment().trim());
    }

    public void setStateTextField(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        int n = this.myAbleObject.getState();
        if (this.myAbleObject instanceof AbleDefaultAgent) {
            this.myNameTextField.setEnabled(n == 1026 || n == 1020);
        }
        this.myStateLabel.setText("State: " + AbleState.State((int)n));
    }

    public void setFileNameTextField(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        this.myFileNameTextField.setText(this.myAbleObject.getFileName());
    }

    public void setDataFlowEnabledCheckBox(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        this.myDataFlowEnabledCheckBox.setSelected(this.myAbleObject.isDataFlowEnabled());
    }

    public void setTimerEventProcessingEnabledCheckBox(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        this.myTimerEventsEnabledCheckBox.setSelected(this.myAbleObject.isTimerEventProcessingEnabled());
    }

    public void setSleepTimeTextField(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        this.mySleepTimeSpinner.setValue(new Long(this.myAbleObject.getSleepTime()));
    }

    public void setAbleEventProcessingCheckBoxes(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        this.myPostingEnabledCheckBox.setSelected(this.myAbleObject.isAbleEventPostingEnabled());
        this.myProcessingEnabledCheckBox.setSelected(this.myAbleObject.isAbleEventProcessingEnabled());
    }

    private void addPropertyListeners() {
        this.myCustomizer.addPropertyChangeMethod("processingState", this, "setStateTextField");
        this.myCustomizer.addPropertyChangeMethod("name", this, "setNameTextField");
        this.myCustomizer.addPropertyChangeMethod("comment", this, "setCommentTextArea");
        this.myCustomizer.addPropertyChangeMethod("dataFlowEnabled", this, "setDataFlowEnabledCheckBox");
        this.myCustomizer.addPropertyChangeMethod("timerEventProcessingEnabled", this, "setTimerEventProcessingEnabledCheckBox");
        this.myCustomizer.addPropertyChangeMethod("sleepTime", this, "setSleepTimeTextField");
        this.myCustomizer.addPropertyChangeMethod("ableEventProcessingEnabled", this, "setAbleEventProcessingCheckBoxes");
    }

    private void BrowseButton_actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = new String[]{"ser", "xlt"};
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myFileNameTextField, "Serialized files (*.ser, *.xlt)", stringArray, this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void BrowseButton2_actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = new String[]{"log"};
        String string = AblePanelHelper.setTextFieldFromFileDialog(this.myTraceLogFileNameTextField, "Log files (*.log)", stringArray, this.myCustomizer.getWorkingDirectory());
        if (string != null) {
            this.myCustomizer.setWorkingDirectory(string);
        }
    }

    private void initButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            boolean bl = this.myAbleObject.isAbleEventProcessingEnabled() || this.myAbleObject.isTimerEventProcessingEnabled();
            this.myCustomizer.updateObject();
            if (bl && !this.myAbleObject.isAbleEventProcessingEnabled() && !this.myAbleObject.isTimerEventProcessingEnabled()) {
                this.myAbleObject.quitEnabledEventProcessing();
            }
            this.myAbleObject.init();
            this.myCustomizer.setObject(this.myAbleObject);
            this.myCustomizer.setIgnoreAnyPropertyChanges(false);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occurred while initializing the object\n" + exception.toString(), "AbleObjectPanel Error: InitButton()", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void button_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            int n;
            this.myCustomizer.setIgnoreAnyPropertyChanges(true);
            if ("reset".equalsIgnoreCase(string)) {
                this.myAbleObject.reset();
            } else if ("suspend".equalsIgnoreCase(string)) {
                this.myAbleObject.suspendAll();
            } else if ("resume".equalsIgnoreCase(string)) {
                this.myAbleObject.resumeAll();
            } else if ("quit...".equalsIgnoreCase(string) && (n = JOptionPane.showConfirmDialog(this, "Are you sure?  Some beans may implement quit as destroy.", "Confirm quit", 0, 2)) == 0) {
                this.myAbleObject.quitAll();
            }
            this.myCustomizer.setObject(this.myAbleObject);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "An error occurred while handling the " + string + " button\n" + exception.toString(), "AbleObjectPanel Error", 2);
        }
        finally {
            try {
                this.myCustomizer.setIgnoreAnyPropertyChanges(false);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "doc-files/AbleObjectHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

