/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AbleJSliderWithField
extends JSlider
implements ChangeListener,
PropertyChangeListener {
    private String name = "Slider value";
    private JTextField textField;
    private boolean ignoreTextUpdates = false;

    private AbleJSliderWithField() {
    }

    public AbleJSliderWithField(String string, JTextField jTextField, int n, int n2, int n3, int n4) {
        super(n2, n3, n4);
        this.name = string;
        this.textField = jTextField;
        jTextField.setText(Integer.toString(n4));
        jTextField.addPropertyChangeListener(this);
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        jTextField.getActionMap().put("check", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleJSliderWithField.this.ignoreTextUpdates = true;
                try {
                    AbleJSliderWithField.this.updateSliderFromTextField();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.getLocalizedMessage(), "Invalid numeric input", 0);
                }
            }
        });
        this.setOrientation(n);
        this.addChangeListener(this);
        this.setMajorTickSpacing(10);
        this.setMinorTickSpacing(1);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = jSlider.getValue();
        if (!jSlider.getValueIsAdjusting()) {
            if (!this.ignoreTextUpdates) {
                this.textField.setText("" + n);
            }
            this.ignoreTextUpdates = false;
        } else {
            this.textField.setText(String.valueOf(n));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("value".equals(propertyChangeEvent.getPropertyName())) {
            this.updateSliderFromTextField();
        }
    }

    private void updateSliderFromTextField() {
        int n = (int)(0.5 + Double.parseDouble(this.textField.getText()));
        if (n < this.getMinimum()) {
            throw new IllegalArgumentException("Value '" + n + "' for '" + this.name + "' is less than the allowed minimum of '" + this.getMinimum() + "'.");
        }
        if (n > this.getMaximum()) {
            throw new IllegalArgumentException("Value '" + n + "' for '" + this.name + "' is greater than the allowed maximum of '" + this.getMaximum() + "'.");
        }
        this.setValue(n);
    }

    public void setValue(int n) {
        super.setValue(n);
        this.textField.setText(Integer.toString(n));
    }

    public void setValue(double d) {
        super.setValue((int)d);
        this.textField.setText(Double.toString(d));
    }

    public int getValue() {
        if (this.textField != null) {
            this.updateSliderFromTextField();
        }
        int n = super.getValue();
        return n;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanel jPanel = new JPanel();
                JFrame jFrame = new JFrame("SliderDemo");
                jFrame.setDefaultCloseOperation(3);
                jPanel.setLayout(new BorderLayout());
                JLabel jLabel = new JLabel("Rate");
                JTextField jTextField = new JTextField();
                jTextField.setText("15");
                jTextField.setColumns(5);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BorderLayout());
                AbleJSliderWithField ableJSliderWithField = new AbleJSliderWithField("testSlider", jTextField, 5, 50, 15, 5);
                boolean bl = false;
                if (!bl) {
                    jPanel.add((Component)jPanel2, "West");
                    jLabel.setAlignmentX(1.0f);
                    jTextField.setAlignmentX(0.0f);
                    jPanel2.add((Component)jLabel, "West");
                    jPanel2.add((Component)jTextField, "East");
                    jPanel.add((Component)ableJSliderWithField, "East");
                } else {
                    jPanel.add((Component)jPanel2, "North");
                    jLabel.setAlignmentX(0.5f);
                    jTextField.setAlignmentX(0.5f);
                    ableJSliderWithField.setOrientation(1);
                    jPanel2.add((Component)jLabel, "North");
                    jPanel2.add((Component)jTextField, "South");
                    jPanel.add((Component)ableJSliderWithField, "South");
                }
                jPanel.add(ableJSliderWithField);
                jPanel.setOpaque(true);
                jFrame.setContentPane(jPanel);
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }
}

