/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.able.Able;
import com.ibm.able.AbleBean;
import com.ibm.able.AbleBufferConnection;
import com.ibm.able.AbleCustomizerPanel;
import com.ibm.able.AbleEventListener;
import com.ibm.able.AbleHelp;
import com.ibm.able.AbleObject;
import com.ibm.able.AbleObjectCustomizer;
import com.ibm.able.AblePanelHelper;
import com.ibm.able.AblePropertyConnection;
import com.ibm.able.editor.AbleGridBagConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class AbleConnectionsPanel
extends JPanel
implements AbleCustomizerPanel {
    private AbleObject myAbleObject = null;
    private AbleObjectCustomizer myCustomizer = null;
    private boolean isSourceChanged = false;
    private boolean isDestChanged = false;
    private boolean isEventListenerChanged = false;
    private boolean isPropertyConnectionChanged = false;
    private JList myDataInputList = null;
    private DefaultListModel myDataInputListModel = null;
    private Hashtable myDataInputHash = new Hashtable();
    private JList myDataOutputList = null;
    private DefaultListModel myDataOutputListModel = null;
    private Hashtable myDataOutputHash = new Hashtable();
    private JList myEventListenerList = null;
    private DefaultListModel myEventListenerListModel = null;
    private Hashtable myEventListenerHash = new Hashtable();
    private JList myPropertyConnectionList = null;
    private DefaultListModel myPropertyConnectionListModel = null;
    private Hashtable myPropertyConnectionHash = new Hashtable();

    private AbleConnectionsPanel() {
    }

    public AbleConnectionsPanel(AbleObjectCustomizer ableObjectCustomizer) {
        this.myCustomizer = ableObjectCustomizer;
        this.setLayout(null);
        this.setBounds(5, 25, 525, 350);
        this.setPreferredSize(new Dimension(525, 350));
        this.initializePanel();
        this.addPropertyListeners();
    }

    public void getDataFromBean(AbleObject ableObject) throws RemoteException {
        if (this.myAbleObject == null) {
            this.myAbleObject = ableObject;
        }
        this.refreshDataInputList(null);
        this.refreshDataOutputList(null);
        this.refreshEventListenerList(null);
        this.refreshPropertyConnectionList(null);
    }

    public void refreshDataInputList(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        if (propertyChangeEvent == null) {
            this.myDataInputListModel.removeAllElements();
            this.myDataInputHash.clear();
            Enumeration enumeration = this.myAbleObject.getSourceBufferConnections().elements();
            while (enumeration.hasMoreElements()) {
                AbleBufferConnection ableBufferConnection = (AbleBufferConnection)enumeration.nextElement();
                this.add(this.myDataInputListModel, this.myDataInputHash, ableBufferConnection.toString(), ableBufferConnection);
            }
        } else {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object == null && object2 != null && object2 instanceof AbleBufferConnection) {
                this.add(this.myDataInputListModel, this.myDataInputHash, ((AbleBufferConnection)object2).toString(), object2);
            } else if (object != null && object2 == null && object instanceof AbleBufferConnection) {
                this.remove(this.myDataInputListModel, this.myDataInputHash, ((AbleBufferConnection)object).toString());
            } else {
                this.refreshDataInputList(null);
            }
        }
    }

    public void refreshDataOutputList(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        if (propertyChangeEvent == null) {
            this.myDataOutputListModel.removeAllElements();
            this.myDataOutputHash.clear();
            Enumeration enumeration = this.myAbleObject.getDestBufferConnections().elements();
            while (enumeration.hasMoreElements()) {
                AbleBufferConnection ableBufferConnection = (AbleBufferConnection)enumeration.nextElement();
                this.add(this.myDataOutputListModel, this.myDataOutputHash, ableBufferConnection.toString(), ableBufferConnection);
            }
        } else {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object == null && object2 != null && object2 instanceof AbleBufferConnection) {
                this.add(this.myDataOutputListModel, this.myDataOutputHash, ((AbleBufferConnection)object2).toString(), object2);
            } else if (object != null && object2 == null && object instanceof AbleBufferConnection) {
                this.remove(this.myDataOutputListModel, this.myDataOutputHash, ((AbleBufferConnection)object).toString());
            } else {
                this.refreshDataOutputList(null);
            }
        }
    }

    public void refreshEventListenerList(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        if (propertyChangeEvent == null) {
            this.myEventListenerListModel.removeAllElements();
            this.myEventListenerHash.clear();
            Enumeration enumeration = this.myAbleObject.getAbleEventListeners().elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof AbleBean)) continue;
                this.add(this.myEventListenerListModel, this.myEventListenerHash, ((AbleBean)e).getName(), e);
            }
        } else {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object == null && object2 != null && object2 instanceof AbleBean) {
                AbleBean ableBean = (AbleBean)object2;
                this.add(this.myEventListenerListModel, this.myEventListenerHash, ableBean.getName(), ableBean);
            } else if (object != null && object2 == null && object instanceof AbleBean) {
                this.remove(this.myEventListenerListModel, this.myEventListenerHash, ((AbleBean)object).getName());
            } else {
                this.refreshEventListenerList(null);
            }
        }
    }

    public void refreshPropertyConnectionList(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        if (propertyChangeEvent == null) {
            this.myPropertyConnectionListModel.removeAllElements();
            this.myPropertyConnectionHash.clear();
            Enumeration enumeration = this.myAbleObject.getPropertyConnectionManager().getConnectionsByPropertyName().elements();
            while (enumeration.hasMoreElements()) {
                Vector vector = (Vector)enumeration.nextElement();
                for (int i = 0; i < vector.size(); ++i) {
                    AblePropertyConnection ablePropertyConnection = (AblePropertyConnection)vector.elementAt(i);
                    this.add(this.myPropertyConnectionListModel, this.myPropertyConnectionHash, ablePropertyConnection.toString(), ablePropertyConnection);
                }
            }
        } else {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object == null && object2 != null && object2 instanceof AblePropertyConnection) {
                AblePropertyConnection ablePropertyConnection = (AblePropertyConnection)object2;
                this.add(this.myPropertyConnectionListModel, this.myPropertyConnectionHash, ablePropertyConnection.toString(), ablePropertyConnection);
            } else if (object != null && object2 == null && object instanceof AblePropertyConnection) {
                this.remove(this.myPropertyConnectionListModel, this.myPropertyConnectionHash, ((AblePropertyConnection)object).toString());
            } else {
                this.refreshPropertyConnectionList(null);
            }
        }
    }

    public void refreshName(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        if (propertyChangeEvent != null) {
            String string = (String)propertyChangeEvent.getOldValue();
            String string2 = (String)propertyChangeEvent.getNewValue();
            if (string == null) {
                return;
            }
            if (string2 == null) {
                return;
            }
            this.getDataFromBean(this.myAbleObject);
        }
    }

    public void refreshBeans(PropertyChangeEvent propertyChangeEvent) throws RemoteException {
        if (propertyChangeEvent != null) {
            this.getDataFromBean(this.myAbleObject);
        }
    }

    public void setDataOnBean() throws RemoteException {
        AbleBufferConnection ableBufferConnection;
        String string;
        int n;
        if (this.isSourceChanged || this.isDestChanged) {
            this.myAbleObject.removeAllBufferConnections();
            for (n = 0; n < this.myDataInputListModel.getSize(); ++n) {
                string = (String)this.myDataInputListModel.getElementAt(n);
                ableBufferConnection = (AbleBufferConnection)this.myDataInputHash.get(string);
                this.myAbleObject.addSourceBufferConnection(ableBufferConnection);
            }
            for (n = 0; n < this.myDataOutputListModel.getSize(); ++n) {
                string = (String)this.myDataOutputListModel.getElementAt(n);
                ableBufferConnection = (AbleBufferConnection)this.myDataOutputHash.get(string);
                this.myAbleObject.addDestBufferConnection(ableBufferConnection);
            }
        }
        if (this.isEventListenerChanged) {
            this.myAbleObject.removeAllAbleEventListeners();
            for (n = 0; n < this.myEventListenerListModel.getSize(); ++n) {
                string = (String)this.myEventListenerListModel.getElementAt(n);
                ableBufferConnection = (AbleEventListener)this.myEventListenerHash.get(string);
                this.myAbleObject.addAbleEventListener((AbleEventListener)ableBufferConnection);
            }
        }
        if (this.isPropertyConnectionChanged) {
            this.myAbleObject.removeAllPropertyConnections();
            for (n = 0; n < this.myPropertyConnectionListModel.getSize(); ++n) {
                string = (String)this.myPropertyConnectionListModel.getElementAt(n);
                ableBufferConnection = (AblePropertyConnection)this.myPropertyConnectionHash.get(string);
                this.myAbleObject.addPropertyConnection((AblePropertyConnection)ableBufferConnection);
            }
        }
    }

    private void initializePanel() {
        int n = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getDataBufferPanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 5, 10), 0, 0));
        this.add(this.getEventListenersPanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 5, 10), 0, 0));
        this.add(this.getPropertyConnectionsPanel(), new AbleGridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
    }

    private Component getDataBufferPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Data buffer connections"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)new JLabel("Source beans:"), new AbleGridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        JButton jButton = new JButton("Remove");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleConnectionsPanel.this.RemoveInputButton_actionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText("Remove the selected input data sources");
        jPanel.add((Component)jButton, new AbleGridBagConstraints(0, n + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.myDataInputListModel = new DefaultListModel();
        JPanel jPanel2 = new JPanel();
        this.myDataInputList = AblePanelHelper.addList(jPanel2, null, 2);
        this.myDataInputList.setModel(this.myDataInputListModel);
        jPanel.add((Component)jPanel2, new AbleGridBagConstraints(1, n, 1, 2, 0.5, 0.5, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
        jPanel.add((Component)new JLabel("Destinations:"), new AbleGridBagConstraints(0, n += 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        JButton jButton2 = new JButton("Remove");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleConnectionsPanel.this.RemoveOutputButton_actionPerformed(actionEvent);
            }
        });
        jButton2.setToolTipText("Remove the selected output data sources");
        jPanel.add((Component)jButton2, new AbleGridBagConstraints(0, n + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        this.myDataOutputListModel = new DefaultListModel();
        JPanel jPanel3 = new JPanel();
        this.myDataOutputList = AblePanelHelper.addList(jPanel3, null, 2);
        this.myDataOutputList.setModel(this.myDataOutputListModel);
        jPanel.add((Component)jPanel3, new AbleGridBagConstraints(1, n, 1, 2, 0.5, 0.5, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
        return jPanel;
    }

    private Component getEventListenersPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Event listeners and connections"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        JButton jButton = new JButton("Remove");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleConnectionsPanel.this.RemoveEventListenerButton_actionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText("Remove the selected event listeners");
        jPanel.add((Component)jButton, new AbleGridBagConstraints(0, n, 1, 2, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.myEventListenerListModel = new DefaultListModel();
        JPanel jPanel2 = new JPanel();
        this.myEventListenerList = AblePanelHelper.addList(jPanel2, null, 2);
        this.myEventListenerList.setModel(this.myEventListenerListModel);
        jPanel.add((Component)jPanel2, new AbleGridBagConstraints(1, n, 1, 2, 0.5, 0.5, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
        return jPanel;
    }

    private Component getPropertyConnectionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Property change connections"));
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        JButton jButton = new JButton("Remove");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbleConnectionsPanel.this.RemovePropertyConnectionButton_actionPerformed(actionEvent);
            }
        });
        jButton.setToolTipText("Remove the selected property change connections");
        jPanel.add((Component)jButton, new AbleGridBagConstraints(0, n, 1, 2, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.myPropertyConnectionListModel = new DefaultListModel();
        JPanel jPanel2 = new JPanel();
        this.myPropertyConnectionList = AblePanelHelper.addList(jPanel2, null, 2);
        this.myPropertyConnectionList.setModel(this.myPropertyConnectionListModel);
        jPanel.add((Component)jPanel2, new AbleGridBagConstraints(1, n, 1, 2, 0.5, 0.5, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
        return jPanel;
    }

    private void addPropertyListeners() {
        if (this.myCustomizer != null) {
            this.myCustomizer.addPropertyChangeMethod("sourceBufferConnections", this, "refreshDataInputList");
            this.myCustomizer.addPropertyChangeMethod("destBufferConnections", this, "refreshDataOutputList");
            this.myCustomizer.addPropertyChangeMethod("listeners", this, "refreshEventListenerList");
            this.myCustomizer.addPropertyChangeMethod("propertyConnectionMgr", this, "refreshPropertyConnectionList");
            this.myCustomizer.addPropertyChangeMethod("beans", this, "refreshBeans");
        }
    }

    private void RemoveInputButton_actionPerformed(ActionEvent actionEvent) {
        this.remove(this.myDataInputListModel, this.myDataInputHash, this.myDataInputList.getSelectedValues());
        this.isSourceChanged = true;
    }

    private void RemoveOutputButton_actionPerformed(ActionEvent actionEvent) {
        this.remove(this.myDataOutputListModel, this.myDataOutputHash, this.myDataOutputList.getSelectedValues());
        this.isDestChanged = true;
    }

    private void RemoveEventListenerButton_actionPerformed(ActionEvent actionEvent) {
        this.remove(this.myEventListenerListModel, this.myEventListenerHash, this.myEventListenerList.getSelectedValues());
        this.isEventListenerChanged = true;
    }

    private void RemovePropertyConnectionButton_actionPerformed(ActionEvent actionEvent) {
        this.remove(this.myPropertyConnectionListModel, this.myPropertyConnectionHash, this.myPropertyConnectionList.getSelectedValues());
        this.isPropertyConnectionChanged = true;
    }

    private void add(DefaultListModel defaultListModel, Hashtable hashtable, String string, Object object) {
        if (!hashtable.containsKey(string)) {
            hashtable.put(string, object);
            defaultListModel.addElement(string);
        }
    }

    private void remove(DefaultListModel defaultListModel, Hashtable hashtable, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.remove(defaultListModel, hashtable, (String)objectArray[i]);
        }
    }

    private void remove(DefaultListModel defaultListModel, Hashtable hashtable, String string) {
        if (hashtable.containsKey(string)) {
            hashtable.remove(string);
            defaultListModel.removeElement(string);
        }
    }

    public String getHelpFileName() {
        return AbleHelp.helpFilesPath + "doc-files/AbleConnectionsHelp.html";
    }

    public URL getHelpContext() {
        return Able.HomeUrl;
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

