/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.able;

import com.ibm.able.AbleCheckBoxTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class AbleCheckBoxTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private JCheckBox myCheckBox = null;
    private JLabel myLabel = null;
    private static Color myBackgroundColor = UIManager.getColor("Tree.textBackground");

    public AbleCheckBoxTreeCellRenderer() {
        this.setBackground(myBackgroundColor);
        this.myCheckBox = new JCheckBox();
        this.myCheckBox.setBackground(myBackgroundColor);
        this.add(this.myCheckBox);
        this.myLabel = new JLabel();
        this.add(this.myLabel);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof AbleCheckBoxTreeNode) {
            this.myCheckBox.setSelected(((AbleCheckBoxTreeNode)object).isSelected());
        }
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.myLabel.setText(string);
        this.myLabel.setFont(jTree.getFont());
        if (!bl3) {
            if (bl2) {
                this.myLabel.setIcon(UIManager.getIcon("Tree.openIcon"));
            } else {
                this.myLabel.setIcon(UIManager.getIcon("Tree.closedIcon"));
            }
        } else {
            this.myLabel.setIcon(null);
        }
        return this;
    }

    public void doLayout() {
        Dimension dimension = this.myCheckBox.getPreferredSize();
        Dimension dimension2 = this.myLabel.getPreferredSize();
        int n = (dimension2.height - dimension.height) / 2;
        int n2 = Math.max(0, n);
        int n3 = Math.max(0, -1 * n);
        this.myCheckBox.setBounds(0, n2, dimension.width, dimension.height);
        this.myLabel.setBounds(dimension.width, n3, dimension2.width, dimension2.height);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.myCheckBox.getPreferredSize();
        Dimension dimension2 = this.myLabel.getPreferredSize();
        return new Dimension(dimension.width + dimension2.width, Math.max(dimension.height, dimension2.height));
    }

    private static String Copyright() {
        return "(C) Copyright IBM Corporation 1999, 2005.";
    }
}

