/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import java.util.Vector;
import jclass.util.JCHeapSort;
import jclass.util.JCSortAlgorithm;
import jclass.util.JCSortable;

public class JCVector
extends Vector {
    JCSortAlgorithm sort_algorithm;

    public JCVector() {
        super(1, 10);
    }

    public JCVector(int n) {
        super(n, 10);
    }

    public JCVector(int n, int n2) {
        super(n, n2);
    }

    public JCVector(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e != null && e instanceof Vector && !e.getClass().getName().equals("jclass.util.JCString")) {
                JCVector jCVector = new JCVector((Vector)e);
                this.addElement(jCVector);
            } else {
                this.addElement(vector.elementAt(n));
            }
            ++n;
        }
    }

    public JCVector(Object[] objectArray) {
        this.copyFrom(objectArray);
    }

    public void setCapacityIncrement(int n) {
        this.capacityIncrement = n;
    }

    public final void addUnique(Object object) {
        if (!this.contains(object)) {
            this.addElement(object);
        }
    }

    public final Object at(int n) {
        return this.elementAt(n);
    }

    private boolean equals(JCVector jCVector) {
        if (jCVector == null || this.elementCount != jCVector.size()) {
            return false;
        }
        int n = 0;
        while (n < this.elementCount) {
            if (this.elementData[n] == null ? jCVector.elementData[n] != null : !this.elementData[n].equals(jCVector.elementData[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final synchronized void removeElementsAt(int n, int n2) {
        int n3 = n;
        while (n3 < n + n2 && n < this.elementCount) {
            this.removeElementAt(n);
            ++n3;
        }
    }

    public synchronized void setElementAt(int n, Object object) {
        if (object != null) {
            if (this.elementCount < n + 1) {
                this.setSize(n + 1);
            }
            this.elementData[n] = object;
            return;
        }
        if (n < this.elementCount) {
            this.elementData[n] = null;
        }
    }

    public final synchronized void setMinSize(int n) {
        if (n > this.elementCount) {
            this.ensureCapacity(n);
            this.elementCount = n;
        }
    }

    public final synchronized void strip() {
        int n = this.elementCount - 1;
        while (n >= 0) {
            if (this.elementData[n] != null) break;
            --n;
        }
        this.elementCount = n + 1;
        this.trimToSize();
    }

    public final synchronized Object[] getArrayCopy() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public final synchronized void copyFrom(Object[] objectArray) {
        if (objectArray == null) {
            this.removeAllElements();
            return;
        }
        this.ensureCapacity(objectArray.length);
        this.elementCount = objectArray.length;
        System.arraycopy(objectArray, 0, this.elementData, 0, objectArray.length);
    }

    public final synchronized Object getFirst() {
        if (this.elementCount > 0) {
            return this.elementData[0];
        }
        return null;
    }

    public final synchronized Object getLast() {
        if (this.elementCount > 0) {
            return this.elementData[this.elementCount - 1];
        }
        return null;
    }

    public synchronized void sort(int n, int n2, JCSortable jCSortable, int[] nArray) {
        if (this.sort_algorithm == null) {
            this.sort_algorithm = new JCHeapSort();
        }
        this.sort_algorithm.sort(this.elementData, n, n2, this.elementCount, jCSortable, nArray);
    }

    public synchronized void sort(int n, int n2, JCSortable jCSortable) {
        this.sort(n, n2, jCSortable, null);
    }

    public synchronized void sort(JCSortable jCSortable) {
        this.sort(0, this.size() - 1, jCSortable);
    }

    public void setSortAlgorithm(JCSortAlgorithm jCSortAlgorithm) {
        this.sort_algorithm = jCSortAlgorithm;
    }

    public JCSortAlgorithm getSortAlgorithm() {
        return this.sort_algorithm;
    }
}

