/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import jclass.util.JCSortAlgorithm;

public class JCHeapSort
extends JCSortAlgorithm {
    private static final int INVALID = -1;
    int heap_size;
    int start;
    int end;

    void sort(int n, int n2) {
        this.start = n;
        this.end = n2;
        this.build_heap();
        int n3 = n2;
        while (n3 > n) {
            this.swap(n, n3);
            --this.heap_size;
            this.heapify(n);
            --n3;
        }
    }

    private final void build_heap() {
        this.heap_size = this.end - this.start + 1;
        int n = this.parent(this.end);
        while (n >= 0) {
            this.heapify(n);
            --n;
        }
    }

    private final void heapify(int n) {
        int n2 = this.left(n);
        int n3 = this.right(n);
        if (n2 == -1 || n3 == -1) {
            return;
        }
        int n4 = n;
        if (n2 < this.start + this.heap_size && this.do_compare(n2, n) > 0L) {
            n4 = n2;
        }
        if (n3 < this.start + this.heap_size && this.do_compare(n3, n4) > 0L) {
            n4 = n3;
        }
        if (n4 != n) {
            this.swap(n4, n);
            this.heapify(n4);
        }
    }

    private final int parent(int n) {
        if (n < this.start) {
            return this.start;
        }
        return this.start + (n - this.start >> 1);
    }

    private final int left(int n) {
        if (n < this.start) {
            return -1;
        }
        return this.start + (n - this.start << 1);
    }

    private final int right(int n) {
        if (n < this.start) {
            return -1;
        }
        return this.start + (n - this.start << 1) + 1;
    }

    void printList() {
        System.out.print("List:     ");
        int n = this.start;
        while (n <= this.end) {
            int n2 = n;
            if (this.indexes != null) {
                n2 = this.indexes[n];
            }
            System.out.print(this.list[n2] + ", ");
            ++n;
        }
        System.out.println();
    }

    void checkHeap() {
        int n = this.start;
        while (n <= this.end) {
            int n2 = n;
            if (this.indexes != null) {
                n2 = this.indexes[n];
            }
            if (this.do_compare(n2, this.parent(n2)) > 0L) {
                System.out.println("It is NOT a heap!!!");
                return;
            }
            ++n;
        }
        System.out.println("It is a heap!");
    }
}

