/*
 * Decompiled with CFR 0.152.
 */
package jclass.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Date;
import jclass.util.ExpiryDialogComponent;
import jclass.util.JCAlignLayout;
import jclass.util.JCEnvironment;
import jclass.util.JCString;
import jclass.util.JCStringComponent;
import jclass.util.JCVersion;
import jclass.util.JClassInfo;
import jclass.util.RegistryListener;

final class ExpiryDialog
extends Frame
implements Runnable,
RegistryListener {
    private Thread timerThread = new Thread(this);
    private Panel expiryBox;
    private static final String evalNotice = "[VERT_SPACE=10][FONT=arial-plain-12]You are using time-limited, evaluation copies of the following [COLOR=red]J[COLOR=blue]Class[DEFAULT_COLOR] products:[/ALIGN]";

    public ExpiryDialog(String string) {
        super(string);
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.expiryBox = new Panel();
        this.expiryBox.setLayout(new JCAlignLayout(3, 5, 5));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        panel.add(this.expiryBox);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        ExpiryDialogComponent expiryDialogComponent = new ExpiryDialogComponent(evalNotice, 0, new Rectangle(10, 1, 10, 1));
        panel2.add("North", expiryDialogComponent);
        panel2.add("Center", panel);
        expiryDialogComponent = new ExpiryDialogComponent(JClassInfo.getEvalMessage("<product>", "<product>", "<install dir>"), 0, new Rectangle(10, 1, 10, 1));
        panel2.add("South", expiryDialogComponent);
        this.add("Center", panel2);
        expiryDialogComponent = new ExpiryDialogComponent(new JCString("www.klg.com", JClassInfo.makeKLImage(this), 3), 1, new Rectangle(1, 10, 1, 1));
        this.add("North", expiryDialogComponent);
        panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        panel.add(new Button("OK"));
        this.add("South", panel);
        this.timerThread.start();
    }

    public final boolean action(Event event, Object object) {
        ((Component)this).hide();
        ExpiryDialog expiryDialog = this;
        synchronized (expiryDialog) {
            this.notifyAll();
        }
        return true;
    }

    public final boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.action(event, this);
            return true;
        }
        return super.handleEvent(event);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        while (true) {
            this.updateMessage();
            if (JCEnvironment.isVisualCafe()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.pack();
            this.show();
            ExpiryDialog expiryDialog = this;
            synchronized (expiryDialog) {
                while (this.isVisible()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                Thread.sleep(3600000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private final void updateMessage() {
        String[] stringArray = JClassInfo.getEvalPackageNames();
        this.expiryBox.removeAll();
        this.expiryBox.add(new JCStringComponent("[FONT=arial-bold-12]Product"));
        this.expiryBox.add(new JCStringComponent("[FONT=arial-bold-12]Expired"));
        this.expiryBox.add(new JCStringComponent("[FONT=arial-bold-12]Expiry Date"));
        int n = 0;
        while (n < stringArray.length) {
            if (JCVersion.isEval(stringArray[n])) {
                this.expiryBox.add(new JCStringComponent("[FONT=arial-plain-12][COLOR=blue]" + JCVersion.getProductName(stringArray[n])));
                this.expiryBox.add(new JCStringComponent("[FONT=arial-plain-12]" + (JCVersion.isExpired(stringArray[n]) ? "[COLOR=red]Yes" : "[COLOR=green]No")));
                Date date = JCVersion.getEvalExpiryDate(JCVersion.getProductName(stringArray[n]));
                if (date == null) {
                    this.expiryBox.add(new JCStringComponent("[FONT=arial-plain-12][COLOR=red]Unknown"));
                } else {
                    this.expiryBox.add(new JCStringComponent("[FONT=arial-plain-12]" + date.toLocaleString()));
                }
            }
            ++n;
        }
    }

    public void expiryNotify(String string) {
    }
}

