/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.db;

import java.io.Serializable;
import java.util.Vector;
import jclass.chart.db.DataBindableObject;

public class DataBindingMetaData
implements Serializable {
    private Vector columnNames;
    private String pointLabelsColumn;
    private String[] seriesColumns;
    private int startPoint = 0;
    private int endPoint = 100;
    private DataBindableObject dbObject;
    private Vector numericCols;
    private Vector string_dateCols;
    private boolean allRows = false;

    public DataBindingMetaData() {
    }

    public DataBindingMetaData(DataBindableObject dataBindableObject) {
        this.dbObject = dataBindableObject;
        this.fillObject();
    }

    public DataBindingMetaData(String string, String[] stringArray, int n, int n2, boolean bl) {
        this.pointLabelsColumn = string;
        this.seriesColumns = stringArray;
        this.startPoint = n;
        this.endPoint = n2;
        this.allRows = bl;
    }

    public DataBindingMetaData(DataBindingMetaData dataBindingMetaData) {
        this.columnNames = dataBindingMetaData.columnNames;
        this.pointLabelsColumn = dataBindingMetaData.pointLabelsColumn;
        this.seriesColumns = dataBindingMetaData.seriesColumns;
        this.startPoint = dataBindingMetaData.startPoint;
        this.endPoint = dataBindingMetaData.endPoint;
        this.dbObject = dataBindingMetaData.dbObject;
        this.numericCols = dataBindingMetaData.numericCols;
        this.string_dateCols = dataBindingMetaData.string_dateCols;
        this.allRows = dataBindingMetaData.allRows;
    }

    public synchronized void setDBObject(DataBindableObject dataBindableObject) {
        this.dbObject = dataBindableObject;
        this.fillObject();
    }

    public DataBindableObject getDBObject() {
        return this.dbObject;
    }

    public synchronized void setColumnNames(Vector vector) {
        this.columnNames = vector;
    }

    public Vector getColumnNames() {
        return this.columnNames;
    }

    public synchronized void setPointLabelsColumn(String string) {
        this.pointLabelsColumn = string;
    }

    public String getPointLabelsColumn() {
        return this.pointLabelsColumn;
    }

    public synchronized void setSeriesColumns(String[] stringArray) {
        this.seriesColumns = stringArray;
    }

    public String[] getSeriesColumns() {
        return this.seriesColumns;
    }

    public synchronized void setStartPoint(int n) {
        this.startPoint = n;
    }

    public int getStartPoint() {
        return this.startPoint;
    }

    public synchronized void setEndPoint(int n) {
        this.endPoint = n;
    }

    public int getEndPoint() {
        return this.endPoint;
    }

    public void setAllRows(boolean bl) {
        this.allRows = bl;
    }

    public boolean getAllRows() {
        return this.allRows;
    }

    public String[] getPotentialPointLabelsColumns() {
        if (this.string_dateCols == null || this.string_dateCols.size() <= 0) {
            return null;
        }
        int n = this.string_dateCols.size();
        Object[] objectArray = new String[n];
        this.string_dateCols.copyInto(objectArray);
        return objectArray;
    }

    public String[] getPotentialSeriesColumns() {
        if (this.numericCols == null || this.numericCols.size() <= 0) {
            return null;
        }
        int n = this.numericCols.size();
        Object[] objectArray = new String[n];
        this.numericCols.copyInto(objectArray);
        return objectArray;
    }

    private void fillColumnsVectors() {
        if (this.columnNames == null) {
            return;
        }
        int n = this.columnNames.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.columnNames.elementAt(n2);
            int n3 = this.dbObject.getColumnType("", string);
            if (DataBindableObject.isNumeric(n3)) {
                this.numericCols.addElement(string);
            } else if (DataBindableObject.isCharacter(n3) || DataBindableObject.isTimeDate(n3)) {
                this.string_dateCols.addElement(string);
            }
            ++n2;
        }
    }

    private void fillObject() {
        if (this.dbObject != null) {
            this.columnNames = this.dbObject.getColumnsNames("");
            this.numericCols = new Vector();
            this.string_dateCols = new Vector();
            this.fillColumnsVectors();
        }
    }
}

