/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jclass.chart.JCChart;
import jclass.chart.JCChartArea;
import jclass.chart.PlotArea;
import jclass.chart.customizer.swing.JBooleanEditor;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JPropertyPage;

public class PlotAreaBorderPage
extends JPropertyPage {
    private JBooleanEditor axisBBox;
    private JCChartArea chartarea;
    private PlotArea region;

    public void init() {
        super.init();
        this.setToolTipText(PlotAreaBorderPage.getPageTitle());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key166")) + ":"));
        this.axisBBox = new JBooleanEditor("");
        this.axisBBox.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.axisBBox, gridBagConstraints);
        this.add(this.axisBBox);
    }

    public void setObject(Object object) {
        if (object instanceof JCChart) {
            this.chartarea = ((JCChart)object).getChartArea();
            this.region = this.chartarea.getPlotArea();
        }
        if (object instanceof JCChartArea) {
            this.chartarea = (JCChartArea)object;
            this.region = this.chartarea.getPlotArea();
        } else if (object instanceof PlotArea) {
            this.region = (PlotArea)object;
            this.chartarea = (JCChartArea)this.region.getParent();
        }
        if (this.chartarea != null) {
            this.axisBBox.setValue(new Boolean(this.chartarea.getAxisBoundingBox()));
        }
    }

    public Object getObject() {
        if (this.region == null) {
            return this.chartarea;
        }
        return this.region;
    }

    public void propertyChanged(Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        if (object == this.axisBBox && this.chartarea != null) {
            boolean bl = (Boolean)object2;
            this.chartarea.setAxisBoundingBox(bl);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(PlotAreaBorderPage.getPageTitle());
        serializable = new PlotAreaBorderPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((PlotAreaBorderPage)serializable).init();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key167");
    }

    public static String getPageName() {
        return "PlotAreaBorderPage";
    }
}

