/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jclass.chart.JCChartStyle;
import jclass.chart.JCLineStyle;
import jclass.chart.customizer.swing.JColorEditor;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JEnumEditor;
import jclass.chart.customizer.swing.JIntegerEditor;
import jclass.chart.customizer.swing.JPropertyPage;

public class LineStylePage
extends JPropertyPage {
    private JColorEditor lineColor;
    private JIntegerEditor lineWidth;
    private JEnumEditor linePattern;
    private JCChartStyle chartStyle;

    public void init() {
        super.init();
        this.setToolTipText(LineStylePage.getPageTitle());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key115")) + ":");
        this.add(jLabel);
        this.lineColor = new JColorEditor();
        this.lineColor.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.lineColor, gridBagConstraints);
        this.add(this.lineColor);
        jLabel = new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key116")) + ":");
        this.add(jLabel);
        this.lineWidth = new JIntegerEditor();
        this.lineWidth.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.lineWidth, gridBagConstraints);
        this.add(this.lineWidth);
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key117")) + ":"));
        this.linePattern = new JEnumEditor(JCLineStyle.linePattern_strings, JCLineStyle.linePattern_values);
        this.linePattern.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.linePattern, gridBagConstraints);
        this.add(this.linePattern);
    }

    public void setObject(Object object) {
        if (object instanceof JCChartStyle) {
            this.chartStyle = (JCChartStyle)object;
            this.lineColor.setValue(this.chartStyle.getLineColor());
            this.lineWidth.setValue(new Integer(this.chartStyle.getLineWidth()));
            this.linePattern.setValue(new Integer(this.chartStyle.getLinePattern()));
        }
    }

    public Object getObject() {
        return this.chartStyle;
    }

    public void propertyChanged(Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        if (object == this.lineColor) {
            if (this.chartStyle != null) {
                this.chartStyle.setLineColor((Color)object2);
                return;
            }
        } else if (object == this.lineWidth) {
            if (this.chartStyle != null) {
                this.chartStyle.setLineWidth((Integer)object2);
                return;
            }
        } else if (object == this.linePattern && this.chartStyle != null) {
            this.chartStyle.setLinePattern((Integer)object2);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(LineStylePage.getPageTitle());
        serializable = new LineStylePage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((LineStylePage)serializable).init();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key118");
    }

    public static String getPageName() {
        return "LineStylePage";
    }
}

