/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jclass.chart.ChartDataView;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JPropertyPage;
import jclass.chart.db.DataBindingMetaData;
import jclass.chart.db.DataBindingMetaDataComponent;
import jclass.chart.db.DataBoundSource;

public class DataBoundSourcePage
extends JPropertyPage {
    private DataBindingMetaDataComponent comp;
    private DataBindingMetaData metaData;
    private ChartDataView target;

    public void init() {
        super.init();
        this.setToolTipText(DataBoundSourcePage.getPageTitle());
        if (this.metaData == null) {
            this.metaData = new DataBindingMetaData();
        }
        this.comp = new DataBindingMetaDataComponent(this.metaData);
        this.comp.addPropertyChangeListener(this);
        this.add(this.comp);
    }

    public void setObject(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof ChartDataView) {
            this.target = (ChartDataView)object;
            DataBoundSource dataBoundSource = this.getDBSource();
            if (dataBoundSource != null) {
                this.metaData = new DataBindingMetaData(dataBoundSource.getDataBindableObject());
                this.metaData.setPointLabelsColumn(dataBoundSource.getPointLabelsColumn());
                this.metaData.setSeriesColumns(dataBoundSource.getSeriesColumns());
                this.metaData.setStartPoint(dataBoundSource.getStartPoint());
                this.metaData.setEndPoint(dataBoundSource.getEndPoint());
                this.metaData.setAllRows(dataBoundSource.getAllRows());
                this.comp.setObject(this.metaData);
            }
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        if (object == null) {
            return;
        }
        if (object instanceof DataBindingMetaDataComponent && object2 instanceof DataBindingMetaData) {
            DataBoundSource dataBoundSource = this.getDBSource();
            this.metaData = (DataBindingMetaData)object2;
            if (dataBoundSource != null) {
                dataBoundSource.setStartPoint(this.metaData.getStartPoint());
                dataBoundSource.setEndPoint(this.metaData.getEndPoint());
                dataBoundSource.setSeriesColumns(this.metaData.getSeriesColumns());
                dataBoundSource.setPointLabelsColumn(this.metaData.getPointLabelsColumn());
                dataBoundSource.setAllRows(this.metaData.getAllRows());
            }
            this.target.setDataSource(dataBoundSource);
            this.target.setPointLabels(dataBoundSource.getPointLabels());
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(DataBoundSourcePage.getPageTitle());
        serializable = new DataBoundSourcePage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((DataBoundSourcePage)serializable).init();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key331");
    }

    public static String getPageName() {
        return "DataBoundSourcePage";
    }

    private DataBoundSource getDBSource() {
        DataBoundSource dataBoundSource = null;
        if (this.target.getDataSource() instanceof DataBoundSource) {
            dataBoundSource = (DataBoundSource)this.target.getDataSource();
        }
        return dataBoundSource;
    }
}

