/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jclass.chart.JCChart;
import jclass.chart.JCChartArea;
import jclass.chart.customizer.swing.JBooleanEditor;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JFontEditor;
import jclass.chart.customizer.swing.JPropertyPage;

public class ChartAreaGeneralPage
extends JPropertyPage {
    private JBooleanEditor isShowingCheck;
    private JBooleanEditor fastActionCheck;
    private JFontEditor areaFont;
    private JCChartArea chartArea;

    public void init() {
        super.init();
        this.setToolTipText(ChartAreaGeneralPage.getPageTitle());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key27")) + ":"));
        this.isShowingCheck = new JBooleanEditor("");
        this.isShowingCheck.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.isShowingCheck, gridBagConstraints);
        this.add(this.isShowingCheck);
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key127")) + ":"));
        this.fastActionCheck = new JBooleanEditor("");
        this.fastActionCheck.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.fastActionCheck, gridBagConstraints);
        this.add(this.fastActionCheck);
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key112")) + ":"));
        this.areaFont = new JFontEditor();
        this.areaFont.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.areaFont, gridBagConstraints);
        this.add(this.areaFont);
    }

    public Object getObject() {
        return this.chartArea;
    }

    public void setObject(Object object) {
        if (object instanceof JCChart) {
            this.chartArea = ((JCChart)object).getChartArea();
        } else if (object instanceof JCChartArea) {
            this.chartArea = (JCChartArea)object;
        }
        if (this.chartArea != null) {
            this.isShowingCheck.setValue(new Boolean(this.chartArea.getIsShowing()));
            this.fastActionCheck.setValue(new Boolean(this.chartArea.getFastAction()));
            this.areaFont.setValue(this.chartArea.getFont());
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.chartArea == null || object2 == null) {
            return;
        }
        if (object2 instanceof Boolean) {
            boolean bl = (Boolean)object2;
            if (object == this.isShowingCheck) {
                this.chartArea.setIsShowing(bl);
                return;
            }
            if (object == this.fastActionCheck) {
                this.chartArea.setFastAction(bl);
                return;
            }
        } else if (object == this.areaFont) {
            this.chartArea.setFont((Font)object2);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(ChartAreaGeneralPage.getPageTitle());
        serializable = new ChartAreaGeneralPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((ChartAreaGeneralPage)serializable).init();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key128");
    }

    public static String getPageName() {
        return "ChartAreaGeneralPage";
    }
}

