/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JDoubleEditor;
import jclass.chart.customizer.swing.JEnumEditor;
import jclass.chart.customizer.swing.JPropertyPage;

public class AxisPlacementPage
extends JPropertyPage {
    protected JEnumEditor axisValCombo;
    protected JDoubleEditor placementField;
    private JCAxis target;

    public void init() {
        super.init();
        this.setToolTipText(AxisPlacementPage.getPageTitle());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        gridBagConstraints.weightx = 1.0;
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key70")) + ":"));
        this.axisValCombo = new JEnumEditor();
        this.axisValCombo.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.axisValCombo, gridBagConstraints);
        this.add(this.axisValCombo);
        this.add(new JLabel(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key97")) + ":"));
        this.placementField = new JDoubleEditor(6);
        this.placementField.addPropertyChangeListener(this);
        gridBagLayout.setConstraints(this.placementField, gridBagConstraints);
        this.add(this.placementField);
    }

    private void setAxisList(JCChart jCChart) {
        JCAxis[] jCAxisArray;
        int n = 0;
        int n2 = 0;
        JCAxis[] jCAxisArray2 = jCChart.getChartArea().getXAxis();
        if (jCAxisArray2 != null) {
            n = jCAxisArray2.length;
        }
        if ((jCAxisArray = jCChart.getChartArea().getYAxis()) != null) {
            n2 = jCAxisArray.length;
        }
        String[] stringArray = new String[n + n2];
        Object[] objectArray = new JCAxis[n + n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            objectArray[n3] = jCAxisArray2[n4];
            stringArray[n3] = new String(String.valueOf(jCAxisArray2[n4].getName()));
            ++n4;
            ++n3;
        }
        int n5 = 0;
        while (n5 < n2) {
            objectArray[n3] = jCAxisArray[n5];
            stringArray[n3] = new String(String.valueOf(jCAxisArray[n5].getName()));
            ++n5;
            ++n3;
        }
        if (n3 > 0) {
            this.axisValCombo.setItems(stringArray, objectArray);
        }
    }

    public Object getObject() {
        return this.target;
    }

    public void setObject(Object object) {
        if (object instanceof JCChart) {
            this.setAxisList((JCChart)object);
            return;
        }
        if (object instanceof JCAxis) {
            this.target = (JCAxis)object;
            JCChart jCChart = this.target.getParent();
            if (jCChart == null) {
                return;
            }
            this.setAxisList(jCChart);
            JCAxis jCAxis = this.target.getPlacementAxis();
            if (jCAxis == null) {
                this.axisValCombo.setValue("");
                this.axisValCombo.setEnabled(true);
                this.placementField.setValue("");
                this.placementField.textField.setEditable(false);
                return;
            }
            this.axisValCombo.setValue(jCAxis);
            this.axisValCombo.setEnabled(false);
            this.placementField.setValue(new Double(this.target.getPlacementLocation()));
            this.placementField.textField.setEditable(true);
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.target == null) {
            return;
        }
        if (object2 instanceof Double && object == this.placementField) {
            this.target.setPlacementLocation((Double)object2);
        }
        if (object2 instanceof Integer && object == this.axisValCombo) {
            JCAxis jCAxis = (JCAxis)this.axisValCombo.getItem((Integer)object2);
            JCAxis jCAxis2 = this.target.getPlacementAxis();
            if (jCAxis2 != jCAxis) {
                this.target.setPlacement(4);
                this.target.setPlacementAxis(jCAxis);
                this.placementField.setValue(new Double(this.target.getPlacementLocation()));
                this.placementField.textField.setEditable(true);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(AxisPlacementPage.getPageTitle());
        serializable = new AxisPlacementPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((AxisPlacementPage)serializable).init();
        ((AxisPlacementPage)serializable).setObject(new JCAxis());
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key208");
    }

    public static String getPageName() {
        return "AxisPlacementPage";
    }
}

