/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.Component;
import java.awt.Frame;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCLabel;
import jclass.bwt.JCSpinBoxEvent;
import jclass.bwt.JCSpinBoxListener;
import jclass.bwt.JCSpinBoxString;
import jclass.chart.ChartDataView;
import jclass.chart.JCChart;
import jclass.chart.JCPieChartFormat;
import jclass.chart.customizer.JCDoubleEditor;
import jclass.chart.customizer.JCIntegerEditor;
import jclass.chart.customizer.JCPropertyPage;
import jclass.util.JCUtilConverter;

public class PieChartPage
extends JCPropertyPage
implements JCSpinBoxListener {
    JCSpinBoxString thresholdMethod;
    JCDoubleEditor thresholdValueField;
    JCSpinBoxString sortOrder;
    JCIntegerEditor minSlicesField;
    ChartDataView view;

    public void init() {
        this.setLayout(new JCAlignerLayout(2, 3, 3));
        this.add(new JCLabel("Threshold Method:"));
        this.thresholdMethod = new JCSpinBoxString(8);
        this.add(this.thresholdMethod);
        this.thresholdMethod.getTextField().setEditable(false);
        this.thresholdMethod.getTextField().setBackground(JCPropertyPage.textBG);
        this.thresholdMethod.getTextField().setShowCursorPosition(false);
        this.thresholdMethod.setStringList(JCPieChartFormat.thresholdMethod_strings);
        this.thresholdMethod.addSpinBoxListener(this);
        this.add(new JCLabel("Threshold Value:"));
        this.thresholdValueField = new JCDoubleEditor(8);
        this.thresholdValueField.addPropertyChangeListener(this);
        this.thresholdValueField.setBackground(JCPropertyPage.textBG);
        this.add(this.thresholdValueField);
        this.add(new JCLabel("Sort Order:"));
        this.sortOrder = new JCSpinBoxString(8);
        this.add(this.sortOrder);
        this.sortOrder.getTextField().setEditable(false);
        this.sortOrder.getTextField().setBackground(JCPropertyPage.textBG);
        this.sortOrder.getTextField().setShowCursorPosition(false);
        this.sortOrder.setStringList(JCPieChartFormat.sortOrder_strings);
        this.sortOrder.addSpinBoxListener(this);
        this.add(new JCLabel("Minimum Slices:"));
        this.minSlicesField = new JCIntegerEditor(4);
        this.minSlicesField.addPropertyChangeListener(this);
        this.minSlicesField.setBackground(JCPropertyPage.textBG);
        this.add(this.minSlicesField);
    }

    public Object getObject() {
        return this.view;
    }

    public void setObject(Object object) {
        if (object instanceof JCChart) {
            this.view = ((JCChart)object).getDataView(0);
        } else if (object instanceof ChartDataView) {
            this.view = (ChartDataView)object;
        }
        if (this.view != null && this.view.getChartType() == 11) {
            JCPieChartFormat jCPieChartFormat = this.view.getPieChartFormat();
            if (jCPieChartFormat != null) {
                String string;
                int n = jCPieChartFormat.getThresholdMethod();
                String string2 = JCUtilConverter.fromEnum(n, JCPieChartFormat.thresholdMethod_strings, JCPieChartFormat.thresholdMethod_values);
                if (string2 != (string = this.thresholdMethod.getText())) {
                    this.thresholdMethod.setText(string2);
                }
                this.thresholdMethod.enable();
                this.thresholdMethod.getTextField().showPosition(0);
                this.thresholdValueField.setValue(new Double(jCPieChartFormat.getThresholdValue()));
                this.thresholdValueField.enable();
                int n2 = jCPieChartFormat.getSortOrder();
                string2 = JCUtilConverter.fromEnum(n2, JCPieChartFormat.sortOrder_strings, JCPieChartFormat.sortOrder_values);
                string = this.sortOrder.getText();
                if (string2 != string) {
                    this.sortOrder.setText(string2);
                }
                this.sortOrder.enable();
                this.sortOrder.getTextField().showPosition(0);
                this.minSlicesField.setValue(new Integer(jCPieChartFormat.getMinSlices()));
                ((Component)this.minSlicesField).enable();
                return;
            }
        } else {
            this.thresholdMethod.disable();
            this.thresholdValueField.disable();
            this.sortOrder.disable();
            ((Component)this.minSlicesField).disable();
        }
    }

    public void spinBoxChangeBegin(JCSpinBoxEvent jCSpinBoxEvent) {
        if (this.view == null) {
            return;
        }
        if (jCSpinBoxEvent.getSource() instanceof JCSpinBoxString) {
            JCSpinBoxString jCSpinBoxString = (JCSpinBoxString)jCSpinBoxEvent.getSource();
            if (jCSpinBoxString == this.thresholdMethod) {
                this.view.getPieChartFormat().setThresholdMethod(JCUtilConverter.toEnum((String)jCSpinBoxEvent.getValue(), JCPieChartFormat.thresholdMethod_strings, JCPieChartFormat.thresholdMethod_values, 0));
                return;
            }
            if (jCSpinBoxString == this.sortOrder) {
                this.view.getPieChartFormat().setSortOrder(JCUtilConverter.toEnum((String)jCSpinBoxEvent.getValue(), JCPieChartFormat.sortOrder_strings, JCPieChartFormat.sortOrder_values, 0));
            }
        }
    }

    public void spinBoxChangeEnd(JCSpinBoxEvent jCSpinBoxEvent) {
        ((JCSpinBoxString)jCSpinBoxEvent.getSource()).getTextField().showPosition(0);
    }

    public void propertyChanged(Object object, Object object2) {
        if (this.view == null) {
            return;
        }
        if (object == this.thresholdValueField) {
            Double d = (Double)object2;
            this.view.getPieChartFormat().setThresholdValue(d);
            return;
        }
        if (object == this.minSlicesField) {
            Integer n = (Integer)object2;
            this.view.getPieChartFormat().setMinSlices(n);
        }
    }

    public static void main(String[] stringArray) {
        String string = PieChartPage.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(PieChartPage.getPageTitle());
        jCPropertyPage.setObject(new JCChart());
    }

    public static String getPageTitle() {
        return "Pie Chart Specific Property Page";
    }

    public static String getPageName() {
        return "PieChartPage";
    }
}

