/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.Serializable;
import javax.swing.JComponent;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCLabel;
import jclass.bwt.JCSpinBox;
import jclass.bwt.JCSpinBoxEvent;
import jclass.bwt.JCSpinBoxListener;
import jclass.bwt.JCTextField;
import jclass.chart.JCAxis;
import jclass.chart.customizer.JCPropertyPage;

public class LabelValuePage
extends JCPropertyPage
implements JCActionListener,
JCItemListener,
JCSpinBoxListener {
    JCTextField numField;
    JCCheckbox numDefault;
    JCTextField tickField;
    JCCheckbox tickDefault;
    JCSpinBox precisionField;
    JCCheckbox precisionDefault;
    JCAxis target;

    public void init() {
        this.setLayout(new JCAlignerLayout(3, 2, 2));
        this.add(new JCLabel("Num Spacing:"));
        this.numField = new JCTextField("", 4);
        this.numField.addActionListener(this);
        this.numField.setBackground(JCPropertyPage.textBG);
        this.add(this.numField);
        this.numDefault = new JCCheckbox("isDefault");
        this.numDefault.addItemListener(this);
        this.add(this.numDefault);
        this.add(new JCLabel("Tick Spacing:"));
        this.tickField = new JCTextField("", 4);
        this.tickField.addActionListener(this);
        this.tickField.setBackground(JCPropertyPage.textBG);
        this.add(this.tickField);
        this.tickDefault = new JCCheckbox("isDefault");
        this.tickDefault.addItemListener(this);
        this.add(this.tickDefault);
        this.add(new JCLabel("Precision:"));
        this.precisionField = new JCSpinBox(4);
        this.precisionField.setMinimum(-6);
        this.precisionField.setMaximum(6);
        this.precisionField.addSpinBoxListener(this);
        this.precisionField.getTextField().setBackground(JCPropertyPage.textBG);
        this.precisionField.getTextField().addActionListener(this);
        this.add(this.precisionField);
        this.precisionDefault = new JCCheckbox("isDefault");
        this.precisionDefault.addItemListener(this);
        this.add(this.precisionDefault);
    }

    public void setObject(Object object) {
        if (object instanceof JCAxis) {
            boolean bl;
            this.target = (JCAxis)object;
            String string = String.valueOf(this.target.getNumSpacing());
            if (string != this.numField.getText()) {
                this.numField.setText(string);
            }
            this.numDefault.setState((bl = this.target.getNumSpacingIsDefault()) ? 1 : 0);
            if (bl) {
                this.numField.disable();
            } else {
                this.numField.enable();
            }
            string = String.valueOf(this.target.getTickSpacing());
            if (string != this.tickField.getText()) {
                this.tickField.setText(string);
            }
            this.tickDefault.setState((bl = this.target.getTickSpacingIsDefault()) ? 1 : 0);
            if (bl) {
                this.tickField.disable();
            } else {
                this.tickField.enable();
            }
            int n = this.target.getPrecision();
            if (n != this.precisionField.getIntValue()) {
                this.precisionField.setIntValue(n);
            }
            this.precisionDefault.setState((bl = this.target.getPrecisionIsDefault()) ? 1 : 0);
            if (bl) {
                this.precisionField.disable();
                this.precisionField.getIncrementArrow().disable();
                this.precisionField.getDecrementArrow().disable();
                return;
            }
            this.precisionField.enable();
            this.precisionField.getIncrementArrow().enable();
            this.precisionField.getDecrementArrow().enable();
        }
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (this.target == null) {
            return;
        }
        if (jCActionEvent.getSource() instanceof JCTextField) {
            JCTextField jCTextField = (JCTextField)jCActionEvent.getSource();
            if (jCTextField == this.numField) {
                Double d = new Double(jCTextField.getText());
                this.target.setNumSpacing(d);
            } else if (jCTextField == this.tickField) {
                Double d = new Double(jCTextField.getText());
                this.target.setTickSpacing(d);
            } else if (this.precisionField != null && jCTextField == this.precisionField.getTextField()) {
                int n = this.precisionField.getIntValue();
                this.target.setPrecision(n);
            }
            this.setObject(this.target);
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (this.target == null) {
            return;
        }
        if (jCItemEvent.getSource() instanceof JCCheckbox) {
            boolean bl;
            JCCheckbox jCCheckbox = (JCCheckbox)jCItemEvent.getSource();
            if (jCCheckbox == null) {
                return;
            }
            boolean bl2 = bl = jCCheckbox.getState() != 0;
            if (jCCheckbox == this.numDefault) {
                this.target.setNumSpacingIsDefault(bl);
            } else if (jCCheckbox == this.tickDefault) {
                this.target.setTickSpacingIsDefault(bl);
            } else if (jCCheckbox == this.precisionDefault) {
                this.target.setPrecisionIsDefault(bl);
            } else {
                System.out.println("Unknown Checkbox: " + jCCheckbox.getText() + ": " + bl);
            }
            this.setObject(this.target);
        }
    }

    public void spinBoxChangeBegin(JCSpinBoxEvent jCSpinBoxEvent) {
        if (this.target == null) {
            return;
        }
        if (jCSpinBoxEvent.getSource() == this.precisionField) {
            Integer n = new Integer(jCSpinBoxEvent.getValue().toString());
            this.target.setPrecision(n);
        }
    }

    public void spinBoxChangeEnd(JCSpinBoxEvent jCSpinBoxEvent) {
        this.setObject(this.target);
    }

    public static void main(String[] stringArray) {
        Frame frame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.demos.DemoFrame");
            frame = (Frame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            frame = new Frame();
        }
        frame.setTitle("Chart Axis Property Page");
        serializable = new LabelValuePage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((LabelValuePage)serializable).init();
        frame.add((Component)serializable);
        frame.pack();
        Dimension dimension = ((Container)serializable).preferredSize();
        frame.resize(dimension.width + 10, dimension.height + 30);
        frame.show();
    }
}

