/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCComboBox;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCSpinBox;
import jclass.bwt.JCSpinBoxEvent;
import jclass.bwt.JCSpinBoxListener;
import jclass.bwt.JCTextField;
import jclass.chart.customizer.JCPropertyPage;
import jclass.util.JCUtilConverter;

public class JCFontEditor
extends JCPropertyPage
implements JCActionListener,
JCItemListener,
JCSpinBoxListener,
PropertyEditor {
    protected JCComboBox fontNameCombo;
    protected JCComboBox fontStyleCombo;
    protected JCSpinBox fontSizeCombo;
    protected JCTextField fontSizeField;
    protected JCButton useFontButton;
    static int[] font_style_values;
    static String[] font_style_names;
    String long_label = "      Use this Font      ";
    String short_label = " Use this Font ";

    public JCFontEditor() {
        this.init();
    }

    public void init() {
        this.setLayout(new JCGridLayout(1, 4, 0, 0));
        String[] stringArray = this.getToolkit().getFontList();
        this.fontNameCombo = new JCComboBox(stringArray, "fontNameCombo");
        this.fontNameCombo.getTextField().setColumns(9);
        this.fontNameCombo.getTextField().setEditable(false);
        this.fontNameCombo.addItemListener(this);
        this.add(this.fontNameCombo);
        this.fontStyleCombo = new JCComboBox(font_style_names, "fontStyleCombo");
        this.fontStyleCombo.getTextField().setColumns(5);
        this.fontStyleCombo.getTextField().setEditable(false);
        this.fontStyleCombo.setVisibleRows(font_style_names.length);
        this.fontStyleCombo.getTextField().setShowCursorPosition(false);
        this.fontStyleCombo.addItemListener(this);
        this.add(this.fontStyleCombo);
        this.fontSizeCombo = new JCSpinBox(2);
        this.fontSizeCombo.setMinimum(8);
        this.fontSizeCombo.setMaximum(36);
        this.fontSizeField = this.fontSizeCombo.getTextField();
        this.fontSizeField.addActionListener(this);
        this.fontSizeCombo.addSpinBoxListener(this);
        this.add(this.fontSizeCombo);
        this.useFontButton = new JCButton(this.long_label);
        this.useFontButton.addActionListener(this);
        this.add(this.useFontButton);
    }

    public void setValue(Object object) {
        if (object instanceof Font) {
            this.setEditFont((Font)object);
        }
    }

    public Object getValue() {
        return this.getEditFont();
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getJavaInitializationString() {
        String string;
        Font font = this.getEditFont();
        switch (font.getStyle()) {
            case 1: {
                string = "Font.BOLD";
                break;
            }
            case 2: {
                string = "Font.ITALIC";
                break;
            }
            case 3: {
                string = "Font.BOLD + Font.ITALIC";
                break;
            }
            default: {
                string = "Font.PLAIN";
            }
        }
        return "new Font(" + font.getName() + ", " + string + ", " + font.getSize() + ")";
    }

    public String getAsText() {
        Font font = this.getEditFont();
        return font.toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Font getEditFont() {
        Font font = null;
        try {
            String string = this.fontNameCombo.getTextField().getText();
            int n = this.fontStyleCombo.getSelectedIndex();
            int n2 = font_style_values[n];
            String string2 = this.fontSizeField.getText();
            int n3 = Integer.parseInt(string2);
            font = new Font(string, n2, n3);
        }
        catch (Exception exception) {}
        return font;
    }

    public void setEditFont(Font font) {
        String string = font.getName();
        String[] stringArray = this.fontNameCombo.getItems();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                if (this.fontNameCombo.getSelectedIndex() != n) {
                    this.fontNameCombo.select(n);
                }
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            try {
                this.fontNameCombo.add(string);
                this.fontNameCombo.select(string);
            }
            catch (Exception exception) {
                System.out.println("Unknown font: " + string);
            }
        }
        int n2 = font.getStyle();
        int n3 = 0;
        while (n3 < font_style_values.length) {
            if (n2 == font_style_values[n3]) {
                if (this.fontStyleCombo.getSelectedIndex() == n3) break;
                this.fontStyleCombo.select(n3);
                break;
            }
            ++n3;
        }
        int n4 = font.getSize();
        this.fontSizeCombo.setIntValue(n4);
        this.fontChanged();
    }

    private void fontChanged() {
        try {
            String string = this.fontNameCombo.getSelectedItem();
            String string2 = this.fontStyleCombo.getSelectedItem();
            String string3 = this.fontSizeField.getText();
            if (string != "" && string2 != "" && string3 != "") {
                int n = JCUtilConverter.toEnum(string2, font_style_names, font_style_values, 0);
                Integer n2 = new Integer(string3);
                int n3 = n2;
                Font font = new Font(string, n, n3);
                if (n3 > 14) {
                    this.useFontButton.setText(this.short_label);
                } else {
                    this.useFontButton.setText(this.long_label);
                }
                this.useFontButton.setFont(font);
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("Bad Font: " + exception.getMessage());
        }
    }

    private void comboChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getStateChange() == 2) {
            return;
        }
        JCComboBox jCComboBox = (JCComboBox)jCItemEvent.getSource();
        if (jCComboBox == this.fontNameCombo || jCComboBox == this.fontStyleCombo) {
            this.fontChanged();
            jCComboBox.getTextField().showPosition(0);
        }
    }

    private void textChanged(JCActionEvent jCActionEvent) {
        JCTextField jCTextField = (JCTextField)jCActionEvent.getSource();
        if (jCTextField == this.fontSizeField) {
            this.fontChanged();
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getSource() instanceof JCComboBox) {
            this.comboChanged(jCItemEvent);
        }
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() instanceof JCTextField) {
            try {
                this.textChanged(jCActionEvent);
                return;
            }
            catch (Exception exception) {
                System.out.println("Text: " + exception.getMessage());
                return;
            }
        }
        if (jCActionEvent.getSource() instanceof JCButton) {
            this.firePropertyChange("", null, this.getValue());
        }
    }

    public void spinBoxChangeBegin(JCSpinBoxEvent jCSpinBoxEvent) {
    }

    public void spinBoxChangeEnd(JCSpinBoxEvent jCSpinBoxEvent) {
        this.fontChanged();
    }

    public void setBackground(Color color) {
        if (this.fontNameCombo != null) {
            this.fontNameCombo.getTextField().setBackground(color);
        }
        if (this.fontStyleCombo != null) {
            this.fontStyleCombo.getTextField().setBackground(color);
        }
        if (this.fontSizeField != null) {
            this.fontSizeField.setBackground(color);
        }
    }

    public static void main(String[] stringArray) {
        String string = JCFontEditor.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(JCFontEditor.getPageTitle());
    }

    public static String getPageTitle() {
        return "JClass Font Editor";
    }

    public static String getPageName() {
        return "JCFontEditor";
    }

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        font_style_values = nArray;
        font_style_names = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};
    }
}

