/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.bwt.JCContainer;
import jclass.bwt.JCLabel;
import jclass.chart.customizer.JCPropertyPage;

public class JCAddRemoveDialog
extends JCPropertyPage
implements JCActionListener {
    JCLabel title;
    JCPropertyPage editor;
    JCContainer controls;
    JCButton addButton;
    JCButton previewButton;
    JCButton removeButton;
    JCButton cancelButton;
    public static int MODE_ADD = 1;
    public static int MODE_REMOVE = 3;
    int currentMode;
    Object container;
    Object target;
    Object model;
    static String[][] editorDialogs = new String[][]{{"ChartDataViewDialog", "DataViewCustomizer"}, {"JCAxisDialog", "AxisCustomizer"}, {"JCChartLabelDialog", "ChartLabelTabs"}};
    static String dataViewDialog = "ChartDataViewDialog";
    static String axisDialog = "JCAxisDialog";

    public void init() {
        super.init();
        this.setLayout(new BorderLayout());
        this.controls = new JCContainer();
        this.controls.setLayout(new BorderLayout());
        this.editor = JCPropertyPage.getPage(this.getEditorName());
        this.editor.init();
        this.controls.add("Center", this.editor);
        JCContainer jCContainer = new JCContainer();
        jCContainer.setLayout(new FlowLayout(1, 10, 2));
        this.addButton = new JCButton("Add");
        this.addButton.addActionListener(this);
        jCContainer.add(this.addButton);
        if (this.hasPreview()) {
            this.previewButton = new JCButton("Preview");
            this.previewButton.addActionListener(this);
            jCContainer.add(this.previewButton);
        }
        this.removeButton = new JCButton("Remove");
        this.removeButton.addActionListener(this);
        jCContainer.add(this.removeButton);
        this.cancelButton = new JCButton("Cancel");
        this.cancelButton.addActionListener(this);
        jCContainer.add(this.cancelButton);
        this.controls.add("South", jCContainer);
        this.add("South", this.controls);
        this.setMode(MODE_ADD);
    }

    public void setMode(int n) {
        if (n != this.currentMode) {
            this.currentMode = n;
            if (n == MODE_ADD) {
                this.addButton.enable();
                this.removeButton.disable();
                return;
            }
            if (n == MODE_REMOVE) {
                this.addButton.disable();
                this.removeButton.enable();
            }
        }
    }

    public int getMode() {
        return this.currentMode;
    }

    public boolean hasPreview() {
        return false;
    }

    public void showPreview() {
    }

    public void setObject(Object object) {
        if (object == null) {
            return;
        }
        this.target = object;
    }

    public void setModel(Object object) {
        if (object == null) {
            return;
        }
        this.model = object;
    }

    public void setValue(Object object) {
        this.setObject(object);
    }

    public Object getValue() {
        return this.target;
    }

    public void cancelAction() {
        ((Component)JCPropertyPage.getFrame(this)).hide();
    }

    public void previewAction() {
        this.showPreview();
    }

    public void removeAction() {
        this.firePropertyChange("", null, this.getValue());
    }

    public void addAction() {
        this.firePropertyChange("", null, this.getValue());
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.cancelButton) {
            this.cancelAction();
            return;
        }
        if (jCActionEvent.getSource() == this.previewButton) {
            this.previewAction();
            return;
        }
        if (jCActionEvent.getSource() == this.removeButton) {
            this.removeAction();
            return;
        }
        this.addAction();
    }

    public String getEditorName() {
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        int n = 0;
        while (n < editorDialogs.length) {
            if (editorDialogs[n][0].equals(string2)) {
                return editorDialogs[n][1];
            }
            ++n;
        }
        return "JCFieldEditor";
    }

    public static void main(String[] stringArray) {
        String string = JCAddRemoveDialog.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(JCAddRemoveDialog.getPageTitle());
    }

    public static String getPageTitle() {
        return "Add or Remove Object";
    }

    public static String getPageName() {
        return "JCAddRemoveDialog";
    }
}

