/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jclass.chart.JCChart;
import jclass.chart.customizer.JCLoadDialog;
import jclass.chart.customizer.JCPropertyPage;
import jclass.chart.customizer.JCSaveDialog;

public class ChartCustomizerFrame
extends Frame {
    private static boolean exitOnClose;
    private static int instances;
    private MenuItem openItem;
    private MenuItem saveItem;
    private MenuItem closeItem;
    JCSaveDialog saveDialog;
    JCLoadDialog loadDialog;
    JCChart target;

    public ChartCustomizerFrame() {
        this.init();
    }

    public ChartCustomizerFrame(String string) {
        super(string);
        this.init();
    }

    private void init() {
        this.addInstance();
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        Menu menu = new Menu("File");
        menuBar.add(menu);
        this.openItem = new MenuItem("Load...");
        menu.add(this.openItem);
        this.saveItem = new MenuItem("Save As...");
        menu.add(this.saveItem);
        menu.addSeparator();
        this.closeItem = new MenuItem("Close");
        menu.add(this.closeItem);
        this.addWindowListener(new 1());
    }

    public void setExitOnClose(boolean bl) {
        exitOnClose = bl;
    }

    public void setObject(Object object) {
        System.out.println("CCFrame setObject: " + object);
        this.target = (JCChart)object;
    }

    private JCPropertyPage getPropertyPageChild(Container container) {
        JCPropertyPage jCPropertyPage = null;
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            if (component instanceof JCPropertyPage) {
                jCPropertyPage = (JCPropertyPage)component;
                break;
            }
            if (component instanceof Container) {
                jCPropertyPage = this.getPropertyPageChild((Container)component);
            }
            ++n;
        }
        return jCPropertyPage;
    }

    public Object getObject() {
        JCPropertyPage jCPropertyPage = this.getPropertyPageChild(this);
        if (jCPropertyPage == null) {
            return null;
        }
        return jCPropertyPage.getObject();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            ((Component)this).hide();
        } else if (event.target instanceof MenuItem) {
            if (event.target == this.openItem) {
                if (this.loadDialog == null) {
                    this.loadDialog = new JCLoadDialog();
                    this.loadDialog.init();
                    this.loadDialog.launch();
                }
                this.loadDialog.setModel(this.getObject());
                Frame frame = JCPropertyPage.getFrame(this.loadDialog);
                frame.show();
                frame.toFront();
            } else if (event.target == this.saveItem) {
                if (this.saveDialog == null) {
                    this.saveDialog = new JCSaveDialog();
                    this.saveDialog.init();
                    this.saveDialog.launch();
                }
                this.saveDialog.setObject(this.getObject());
                Frame frame = JCPropertyPage.getFrame(this.saveDialog);
                frame.show();
                frame.toFront();
            } else if (event.target == this.closeItem) {
                ((Component)this).hide();
            }
        }
        return super.handleEvent(event);
    }

    public synchronized void dispose() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Applet) {
                ((Applet)componentArray[n]).destroy();
            }
            ++n;
        }
        super.dispose();
        this.removeInstance();
    }

    private void addInstance() {
        ++instances;
    }

    private void removeInstance() {
        if (--instances == 0 && exitOnClose) {
            System.exit(0);
        }
    }

    public void propertyChanged(Object object, Object object2) {
        System.out.println("CCFrame propertyChanged: " + object2);
        if (this.target == null) {
            return;
        }
        if (object2 instanceof JCChart) {
            JCChart jCChart = (JCChart)object2;
            this.remove(this.target);
            this.add(jCChart);
            this.setObject(jCChart);
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)ChartCustomizerFrame.this).hide();
        }

        /* synthetic */ 1() {
        }
    }
}

